/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *          The <code>&lt;project&gt;</code> element is the root of
 * the descriptor.
 *          The following table lists all of the possible child
 * elements.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Model extends ModelBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field extend
     */
    private String extend;

    /**
     * Field pomVersion
     */
    private String pomVersion;

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field id
     */
    private String id;

    /**
     * Field name
     */
    private String name;

    /**
     * Field currentVersion
     */
    private String currentVersion;

    /**
     * Field shortDescription
     */
    private String shortDescription;

    /**
     * Field description
     */
    private String description;

    /**
     * Field url
     */
    private String url;

    /**
     * Field logo
     */
    private String logo;

    /**
     * Field issueTrackingUrl
     */
    private String issueTrackingUrl;

    /**
     * Field inceptionYear
     */
    private String inceptionYear;

    /**
     * Field gumpRepositoryId
     */
    private String gumpRepositoryId;

    /**
     * Field siteAddress
     */
    private String siteAddress;

    /**
     * Field siteDirectory
     */
    private String siteDirectory;

    /**
     * Field distributionSite
     */
    private String distributionSite;

    /**
     * Field distributionDirectory
     */
    private String distributionDirectory;

    /**
     * Field mailingLists
     */
    private java.util.List mailingLists;

    /**
     * Field developers
     */
    private java.util.List developers;

    /**
     * Field contributors
     */
    private java.util.List contributors;

    /**
     * Field licenses
     */
    private java.util.List licenses;

    /**
     * Field versions
     */
    private java.util.List versions;

    /**
     * Field branches
     */
    private java.util.List branches;

    /**
     * Field packageGroups
     */
    private java.util.List packageGroups;

    /**
     * Field reports
     */
    private java.util.List reports;

    /**
     * Field repository
     */
    private Repository repository;

    /**
     * Field organization
     */
    private Organization organization;

    /**
     * Field properties
     */
    private java.util.Properties properties;

    /**
     * Field packageName
     */
    private String packageName;

    /**
     * Field build
     */
    private Build build;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addBranch
     * 
     * @param branch
     */
    public void addBranch(Branch branch)
    {
        if ( !(branch instanceof Branch) )
        {
            throw new ClassCastException( "Model.addBranches(branch) parameter must be instanceof " + Branch.class.getName() );
        }
        getBranches().add( branch );
    } //-- void addBranch(Branch) 

    /**
     * Method addContributor
     * 
     * @param contributor
     */
    public void addContributor(Contributor contributor)
    {
        if ( !(contributor instanceof Contributor) )
        {
            throw new ClassCastException( "Model.addContributors(contributor) parameter must be instanceof " + Contributor.class.getName() );
        }
        getContributors().add( contributor );
    } //-- void addContributor(Contributor) 

    /**
     * Method addDeveloper
     * 
     * @param developer
     */
    public void addDeveloper(Developer developer)
    {
        if ( !(developer instanceof Developer) )
        {
            throw new ClassCastException( "Model.addDevelopers(developer) parameter must be instanceof " + Developer.class.getName() );
        }
        getDevelopers().add( developer );
    } //-- void addDeveloper(Developer) 

    /**
     * Method addLicense
     * 
     * @param license
     */
    public void addLicense(License license)
    {
        if ( !(license instanceof License) )
        {
            throw new ClassCastException( "Model.addLicenses(license) parameter must be instanceof " + License.class.getName() );
        }
        getLicenses().add( license );
    } //-- void addLicense(License) 

    /**
     * Method addMailingList
     * 
     * @param mailingList
     */
    public void addMailingList(MailingList mailingList)
    {
        if ( !(mailingList instanceof MailingList) )
        {
            throw new ClassCastException( "Model.addMailingLists(mailingList) parameter must be instanceof " + MailingList.class.getName() );
        }
        getMailingLists().add( mailingList );
    } //-- void addMailingList(MailingList) 

    /**
     * Method addPackageGroup
     * 
     * @param packageGroup
     */
    public void addPackageGroup(PackageGroup packageGroup)
    {
        if ( !(packageGroup instanceof PackageGroup) )
        {
            throw new ClassCastException( "Model.addPackageGroups(packageGroup) parameter must be instanceof " + PackageGroup.class.getName() );
        }
        getPackageGroups().add( packageGroup );
    } //-- void addPackageGroup(PackageGroup) 

    /**
     * Method addProperty
     * 
     * @param key
     * @param value
     */
    public void addProperty(String key, String value)
    {
        getProperties().put( key, value );
    } //-- void addProperty(String, String) 

    /**
     * Method addReport
     * 
     * @param string
     */
    public void addReport(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Model.addReports(string) parameter must be instanceof " + String.class.getName() );
        }
        getReports().add( string );
    } //-- void addReport(String) 

    /**
     * Method addVersion
     * 
     * @param version
     */
    public void addVersion(Version version)
    {
        if ( !(version instanceof Version) )
        {
            throw new ClassCastException( "Model.addVersions(version) parameter must be instanceof " + Version.class.getName() );
        }
        getVersions().add( version );
    } //-- void addVersion(Version) 

    /**
     * Get 
     *             The identifier for this artifact that is unique
     * within the group given by the group ID.
     *             An artifact is something that is either produced
     * or used by a project. Examples of artifacts produced by
     *             Maven for a project include: JARs, source and
     * binary distributions, and WARs.
     *           
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Method getBranches
     */
    public java.util.List getBranches()
    {
        if ( this.branches == null )
        {
            this.branches = new java.util.ArrayList();
        }
        
        return this.branches;
    } //-- java.util.List getBranches() 

    /**
     * Get Information required to build the project.
     */
    public Build getBuild()
    {
        return this.build;
    } //-- Build getBuild() 

    /**
     * Method getContributors
     */
    public java.util.List getContributors()
    {
        if ( this.contributors == null )
        {
            this.contributors = new java.util.ArrayList();
        }
        
        return this.contributors;
    } //-- java.util.List getContributors() 

    /**
     * Get 
     *             The current version of the artifact produced by
     * this project.
     *           
     */
    public String getCurrentVersion()
    {
        return this.currentVersion;
    } //-- String getCurrentVersion() 

    /**
     * Get 
     *             A detailed description of the project, used by
     * Maven whenever it needs to describe the project,
     *             such as on the web site. While this element can
     * be specified as CDATA to enable
     *             the use of HTML tags within the description, it
     * is discouraged to allow plain text representation.
     *             If you need to modify the index page of the
     * generated web site, you are able to specify your own instead
     *             of adjusting this text.
     *           
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription() 

    /**
     * Method getDevelopers
     */
    public java.util.List getDevelopers()
    {
        if ( this.developers == null )
        {
            this.developers = new java.util.ArrayList();
        }
        
        return this.developers;
    } //-- java.util.List getDevelopers() 

    /**
     * Get 
     *             The directory on the web server where the final
     * distributions will be published.  This is used when the
     *             distributions are deployed.
     *           
     */
    public String getDistributionDirectory()
    {
        return this.distributionDirectory;
    } //-- String getDistributionDirectory() 

    /**
     * Get 
     *             The server where the final distributions will be
     * published.  This is used when the
     *             distributions are deployed. If this isn't
     * defined, the central repository is used instead as
     *               determined by <code>maven.repo.central</code>
     * and <code>maven.repo.central.directory</code>.
     *           
     */
    public String getDistributionSite()
    {
        return this.distributionSite;
    } //-- String getDistributionSite() 

    /**
     * Get 
     *             The location of the parent project, if one
     * exists. Values from the 
     *             parent project will be the default for this
     * project if they are 
     *             left unspecified. The path may be absolute, or
     * relative to the 
     *             current <code>project.xml</code> file. For
     * example,
     *            
     * <code>&lt;extend&gt;${basedir}/../project.xml&lt;/extend&gt;</code>.
     *           
     */
    public String getExtend()
    {
        return this.extend;
    } //-- String getExtend() 

    /**
     * Get 
     *             A universally unique identifier for a project.
     * It is normal to
     *             use a fully-qualified package name to
     * distinguish it from other projects with a similar name
     *             (eg. <code>org.apache.maven</code>).
     *           
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get 
     *             This is the repository identifier in Gump that
     * this project is part of.
     *           
     */
    public String getGumpRepositoryId()
    {
        return this.gumpRepositoryId;
    } //-- String getGumpRepositoryId() 

    /**
     * Get 
     *             <b>Deprecated</b>. When used, this sets both the
     * <code>groupId</code> and <code>artifactId</code> elements
     *             if they were previously empty.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             The year of the project's inception, specified
     * with 4 digits.
     *             This value is used when generating copyright
     * notices as well as being informational.
     *           
     */
    public String getInceptionYear()
    {
        return this.inceptionYear;
    } //-- String getInceptionYear() 

    /**
     * Get 
     *              The URL of the project's issue tracking system.
     *           
     */
    public String getIssueTrackingUrl()
    {
        return this.issueTrackingUrl;
    } //-- String getIssueTrackingUrl() 

    /**
     * Method getLicenses
     */
    public java.util.List getLicenses()
    {
        if ( this.licenses == null )
        {
            this.licenses = new java.util.ArrayList();
        }
        
        return this.licenses;
    } //-- java.util.List getLicenses() 

    /**
     * Get 
     *             The URL of the project's logo image.  This can
     * be an URL relative
     *             to the base directory of the generated web site,
     *             (e.g., <code>/images/project-logo.png</code>) or
     * an absolute URL
     *             (e.g.,
     * <code>http://my.corp/project-logo.png</code>).  This is used
     *             when generating the project documentation.
     *           
     */
    public String getLogo()
    {
        return this.logo;
    } //-- String getLogo() 

    /**
     * Method getMailingLists
     */
    public java.util.List getMailingLists()
    {
        if ( this.mailingLists == null )
        {
            this.mailingLists = new java.util.ArrayList();
        }
        
        return this.mailingLists;
    } //-- java.util.List getMailingLists() 

    /**
     * Get 
     *             The full name of the project.
     *           
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get 
     *             This element describes various attributes of the
     * organization to
     *             which the project belongs.  These attributes are
     * utilized when
     *             documentation is created (for copyright notices
     * and links).
     *           
     */
    public Organization getOrganization()
    {
        return this.organization;
    } //-- Organization getOrganization() 

    /**
     * Method getPackageGroups
     */
    public java.util.List getPackageGroups()
    {
        if ( this.packageGroups == null )
        {
            this.packageGroups = new java.util.ArrayList();
        }
        
        return this.packageGroups;
    } //-- java.util.List getPackageGroups() 

    /**
     * Get 
     *             The Java package name of the project.  This
     * value is used
     *             when generating JavaDoc.
     *           
     */
    public String getPackageName()
    {
        return this.packageName;
    } //-- String getPackageName() 

    /**
     * Get 
     *             Declares to which version of project descriptor
     * this POM conforms. The only valid value is <code>3</code>.
     */
    public String getPomVersion()
    {
        return this.pomVersion;
    } //-- String getPomVersion() 

    /**
     * Method getProperties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }
        
        return this.properties;
    } //-- java.util.Properties getProperties() 

    /**
     * Method getReports
     */
    public java.util.List getReports()
    {
        if ( this.reports == null )
        {
            this.reports = new java.util.ArrayList();
        }
        
        return this.reports;
    } //-- java.util.List getReports() 

    /**
     * Get 
     *             Specification for the SCM used by the project,
     * such as CVS, Subversion, etc.
     */
    public Repository getRepository()
    {
        return this.repository;
    } //-- Repository getRepository() 

    /**
     * Get 
     *              A short description of the project. The short
     * description should be 
     *              limited to a single line.
     *           
     */
    public String getShortDescription()
    {
        return this.shortDescription;
    } //-- String getShortDescription() 

    /**
     * Get 
     *             The hostname of the web server that hosts the
     * project's web site. This is used when the web site is
     *              deployed.
     *           
     */
    public String getSiteAddress()
    {
        return this.siteAddress;
    } //-- String getSiteAddress() 

    /**
     * Get 
     *             The directory on the web server where the public
     * web site
     *             for this project resides.  This is used when the
     * web site is deployed.
     *           
     */
    public String getSiteDirectory()
    {
        return this.siteDirectory;
    } //-- String getSiteDirectory() 

    /**
     * Get 
     *              The URL to the project's homepage.
     *           
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Method getVersions
     */
    public java.util.List getVersions()
    {
        if ( this.versions == null )
        {
            this.versions = new java.util.ArrayList();
        }
        
        return this.versions;
    } //-- java.util.List getVersions() 

    /**
     * Method removeBranch
     * 
     * @param branch
     */
    public void removeBranch(Branch branch)
    {
        if ( !(branch instanceof Branch) )
        {
            throw new ClassCastException( "Model.removeBranches(branch) parameter must be instanceof " + Branch.class.getName() );
        }
        getBranches().remove( branch );
    } //-- void removeBranch(Branch) 

    /**
     * Method removeContributor
     * 
     * @param contributor
     */
    public void removeContributor(Contributor contributor)
    {
        if ( !(contributor instanceof Contributor) )
        {
            throw new ClassCastException( "Model.removeContributors(contributor) parameter must be instanceof " + Contributor.class.getName() );
        }
        getContributors().remove( contributor );
    } //-- void removeContributor(Contributor) 

    /**
     * Method removeDeveloper
     * 
     * @param developer
     */
    public void removeDeveloper(Developer developer)
    {
        if ( !(developer instanceof Developer) )
        {
            throw new ClassCastException( "Model.removeDevelopers(developer) parameter must be instanceof " + Developer.class.getName() );
        }
        getDevelopers().remove( developer );
    } //-- void removeDeveloper(Developer) 

    /**
     * Method removeLicense
     * 
     * @param license
     */
    public void removeLicense(License license)
    {
        if ( !(license instanceof License) )
        {
            throw new ClassCastException( "Model.removeLicenses(license) parameter must be instanceof " + License.class.getName() );
        }
        getLicenses().remove( license );
    } //-- void removeLicense(License) 

    /**
     * Method removeMailingList
     * 
     * @param mailingList
     */
    public void removeMailingList(MailingList mailingList)
    {
        if ( !(mailingList instanceof MailingList) )
        {
            throw new ClassCastException( "Model.removeMailingLists(mailingList) parameter must be instanceof " + MailingList.class.getName() );
        }
        getMailingLists().remove( mailingList );
    } //-- void removeMailingList(MailingList) 

    /**
     * Method removePackageGroup
     * 
     * @param packageGroup
     */
    public void removePackageGroup(PackageGroup packageGroup)
    {
        if ( !(packageGroup instanceof PackageGroup) )
        {
            throw new ClassCastException( "Model.removePackageGroups(packageGroup) parameter must be instanceof " + PackageGroup.class.getName() );
        }
        getPackageGroups().remove( packageGroup );
    } //-- void removePackageGroup(PackageGroup) 

    /**
     * Method removeReport
     * 
     * @param string
     */
    public void removeReport(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "Model.removeReports(string) parameter must be instanceof " + String.class.getName() );
        }
        getReports().remove( string );
    } //-- void removeReport(String) 

    /**
     * Method removeVersion
     * 
     * @param version
     */
    public void removeVersion(Version version)
    {
        if ( !(version instanceof Version) )
        {
            throw new ClassCastException( "Model.removeVersions(version) parameter must be instanceof " + Version.class.getName() );
        }
        getVersions().remove( version );
    } //-- void removeVersion(Version) 

    /**
     * Set 
     *             The identifier for this artifact that is unique
     * within the group given by the group ID.
     *             An artifact is something that is either produced
     * or used by a project. Examples of artifacts produced by
     *             Maven for a project include: JARs, source and
     * binary distributions, and WARs.
     *           
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set 
     *             Contains information on SCM branches of the
     * project.
     *           
     * 
     * @param branches
     */
    public void setBranches(java.util.List branches)
    {
        this.branches = branches;
    } //-- void setBranches(java.util.List) 

    /**
     * Set Information required to build the project.
     * 
     * @param build
     */
    public void setBuild(Build build)
    {
        this.build = build;
    } //-- void setBuild(Build) 

    /**
     * Set 
     *             Describes the contributors to a project that are
     * not yet committers.
     *           
     * 
     * @param contributors
     */
    public void setContributors(java.util.List contributors)
    {
        this.contributors = contributors;
    } //-- void setContributors(java.util.List) 

    /**
     * Set 
     *             The current version of the artifact produced by
     * this project.
     *           
     * 
     * @param currentVersion
     */
    public void setCurrentVersion(String currentVersion)
    {
        this.currentVersion = currentVersion;
    } //-- void setCurrentVersion(String) 

    /**
     * Set 
     *             A detailed description of the project, used by
     * Maven whenever it needs to describe the project,
     *             such as on the web site. While this element can
     * be specified as CDATA to enable
     *             the use of HTML tags within the description, it
     * is discouraged to allow plain text representation.
     *             If you need to modify the index page of the
     * generated web site, you are able to specify your own instead
     *             of adjusting this text.
     *           
     * 
     * @param description
     */
    public void setDescription(String description)
    {
        this.description = description;
    } //-- void setDescription(String) 

    /**
     * Set 
     *             Describes the committers of a project.
     *           
     * 
     * @param developers
     */
    public void setDevelopers(java.util.List developers)
    {
        this.developers = developers;
    } //-- void setDevelopers(java.util.List) 

    /**
     * Set 
     *             The directory on the web server where the final
     * distributions will be published.  This is used when the
     *             distributions are deployed.
     *           
     * 
     * @param distributionDirectory
     */
    public void setDistributionDirectory(String distributionDirectory)
    {
        this.distributionDirectory = distributionDirectory;
    } //-- void setDistributionDirectory(String) 

    /**
     * Set 
     *             The server where the final distributions will be
     * published.  This is used when the
     *             distributions are deployed. If this isn't
     * defined, the central repository is used instead as
     *               determined by <code>maven.repo.central</code>
     * and <code>maven.repo.central.directory</code>.
     *           
     * 
     * @param distributionSite
     */
    public void setDistributionSite(String distributionSite)
    {
        this.distributionSite = distributionSite;
    } //-- void setDistributionSite(String) 

    /**
     * Set 
     *             The location of the parent project, if one
     * exists. Values from the 
     *             parent project will be the default for this
     * project if they are 
     *             left unspecified. The path may be absolute, or
     * relative to the 
     *             current <code>project.xml</code> file. For
     * example,
     *            
     * <code>&lt;extend&gt;${basedir}/../project.xml&lt;/extend&gt;</code>.
     *           
     * 
     * @param extend
     */
    public void setExtend(String extend)
    {
        this.extend = extend;
    } //-- void setExtend(String) 

    /**
     * Set 
     *             A universally unique identifier for a project.
     * It is normal to
     *             use a fully-qualified package name to
     * distinguish it from other projects with a similar name
     *             (eg. <code>org.apache.maven</code>).
     *           
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set 
     *             This is the repository identifier in Gump that
     * this project is part of.
     *           
     * 
     * @param gumpRepositoryId
     */
    public void setGumpRepositoryId(String gumpRepositoryId)
    {
        this.gumpRepositoryId = gumpRepositoryId;
    } //-- void setGumpRepositoryId(String) 

    /**
     * Set 
     *             <b>Deprecated</b>. When used, this sets both the
     * <code>groupId</code> and <code>artifactId</code> elements
     *             if they were previously empty.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             The year of the project's inception, specified
     * with 4 digits.
     *             This value is used when generating copyright
     * notices as well as being informational.
     *           
     * 
     * @param inceptionYear
     */
    public void setInceptionYear(String inceptionYear)
    {
        this.inceptionYear = inceptionYear;
    } //-- void setInceptionYear(String) 

    /**
     * Set 
     *              The URL of the project's issue tracking system.
     *           
     * 
     * @param issueTrackingUrl
     */
    public void setIssueTrackingUrl(String issueTrackingUrl)
    {
        this.issueTrackingUrl = issueTrackingUrl;
    } //-- void setIssueTrackingUrl(String) 

    /**
     * Set 
     *             This element describes all of the licenses for
     * this project.  
     *             Each license is described by a
     * <code>license</code> element, which 
     *             is then described by additional elements.
     *             Projects should only list the license(s) that
     * applies to the project 
     *             and not the licenses that apply to dependencies.
     *             If multiple licenses are listed, it is assumed
     * that the user can select any of them, not that they
     *             must accept all.
     *           
     * 
     * @param licenses
     */
    public void setLicenses(java.util.List licenses)
    {
        this.licenses = licenses;
    } //-- void setLicenses(java.util.List) 

    /**
     * Set 
     *             The URL of the project's logo image.  This can
     * be an URL relative
     *             to the base directory of the generated web site,
     *             (e.g., <code>/images/project-logo.png</code>) or
     * an absolute URL
     *             (e.g.,
     * <code>http://my.corp/project-logo.png</code>).  This is used
     *             when generating the project documentation.
     *           
     * 
     * @param logo
     */
    public void setLogo(String logo)
    {
        this.logo = logo;
    } //-- void setLogo(String) 

    /**
     * Set 
     *             Contains information about a project's mailing
     * lists.
     *           
     * 
     * @param mailingLists
     */
    public void setMailingLists(java.util.List mailingLists)
    {
        this.mailingLists = mailingLists;
    } //-- void setMailingLists(java.util.List) 

    /**
     * Set 
     *             The full name of the project.
     *           
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *             This element describes various attributes of the
     * organization to
     *             which the project belongs.  These attributes are
     * utilized when
     *             documentation is created (for copyright notices
     * and links).
     *           
     * 
     * @param organization
     */
    public void setOrganization(Organization organization)
    {
        this.organization = organization;
    } //-- void setOrganization(Organization) 

    /**
     * Set Package groups required for complete javadocs.
     * 
     * @param packageGroups
     */
    public void setPackageGroups(java.util.List packageGroups)
    {
        this.packageGroups = packageGroups;
    } //-- void setPackageGroups(java.util.List) 

    /**
     * Set 
     *             The Java package name of the project.  This
     * value is used
     *             when generating JavaDoc.
     *           
     * 
     * @param packageName
     */
    public void setPackageName(String packageName)
    {
        this.packageName = packageName;
    } //-- void setPackageName(String) 

    /**
     * Set 
     *             Declares to which version of project descriptor
     * this POM conforms. The only valid value is <code>3</code>.
     * 
     * @param pomVersion
     */
    public void setPomVersion(String pomVersion)
    {
        this.pomVersion = pomVersion;
    } //-- void setPomVersion(String) 

    /**
     * Set 
     *              Project properties that will be used by various
     * plugins. The format is
     * <code>&lt;name&gt;value&lt;/name&gt;</code>.
     *           
     * 
     * @param properties
     */
    public void setProperties(java.util.Properties properties)
    {
        this.properties = properties;
    } //-- void setProperties(java.util.Properties) 

    /**
     * Set 
     *             This element includes the specification of
     * reports to be
     *             included in a Maven-generated site.  These
     * reports will be run
     *             when a user executes <code>maven site</code>. 
     * All of the
     *             reports will be included in the navigation bar
     * for browsing in
     *             the order they are specified.
     *           
     * 
     * @param reports
     */
    public void setReports(java.util.List reports)
    {
        this.reports = reports;
    } //-- void setReports(java.util.List) 

    /**
     * Set 
     *             Specification for the SCM used by the project,
     * such as CVS, Subversion, etc.
     * 
     * @param repository
     */
    public void setRepository(Repository repository)
    {
        this.repository = repository;
    } //-- void setRepository(Repository) 

    /**
     * Set 
     *              A short description of the project. The short
     * description should be 
     *              limited to a single line.
     *           
     * 
     * @param shortDescription
     */
    public void setShortDescription(String shortDescription)
    {
        this.shortDescription = shortDescription;
    } //-- void setShortDescription(String) 

    /**
     * Set 
     *             The hostname of the web server that hosts the
     * project's web site. This is used when the web site is
     *              deployed.
     *           
     * 
     * @param siteAddress
     */
    public void setSiteAddress(String siteAddress)
    {
        this.siteAddress = siteAddress;
    } //-- void setSiteAddress(String) 

    /**
     * Set 
     *             The directory on the web server where the public
     * web site
     *             for this project resides.  This is used when the
     * web site is deployed.
     *           
     * 
     * @param siteDirectory
     */
    public void setSiteDirectory(String siteDirectory)
    {
        this.siteDirectory = siteDirectory;
    } //-- void setSiteDirectory(String) 

    /**
     * Set 
     *              The URL to the project's homepage.
     *           
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 

    /**
     * Set 
     *             Contains information on previous versions of the
     * project.
     *           
     * 
     * @param versions
     */
    public void setVersions(java.util.List versions)
    {
        this.versions = versions;
    } //-- void setVersions(java.util.List) 


              public void setVersion(String version)
              {
                  this.currentVersion = version;
              } 
              
              public String getVersion() 
              {
                  return currentVersion;
              } 
              
              /* We need this because we can't use package as a field name.*/ 
              public void setPackage(String packageName) 
              {
                  this.packageName = packageName;
              } 
              
              public String getPackage() 
              {
                  return packageName;
              } 
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
