/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         This element describes all of the classpath resources
 * associated with a project or
 *         unit tests.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Resource extends FileSet 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field targetPath
     */
    private String targetPath;

    /**
     * Field filtering
     */
    private boolean filtering = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             Describe the resource target path. For example,
     * if you want that 
     *             resource to appear in a specific package
     *             (<code>org.apache.maven.messages</code>), you
     * must specify this 
     *             element with this value:
     * <code>org/apache/maven/messages</code>.
     *             This is not required if you simply put the
     * resources in that directory structure at the source,
     * however.
     *           
     */
    public String getTargetPath()
    {
        return this.targetPath;
    } //-- String getTargetPath() 

    /**
     * Get 
     *             Whether resources are filtered to replace tokens
     * with parameterised values or not.
     *             The values are taken from the
     * <code>properties</code> element and from the properties in
     * the files listed
     *             in the <code>filters</code> element.
     *           
     */
    public boolean isFiltering()
    {
        return this.filtering;
    } //-- boolean isFiltering() 

    /**
     * Set 
     *             Whether resources are filtered to replace tokens
     * with parameterised values or not.
     *             The values are taken from the
     * <code>properties</code> element and from the properties in
     * the files listed
     *             in the <code>filters</code> element.
     *           
     * 
     * @param filtering
     */
    public void setFiltering(boolean filtering)
    {
        this.filtering = filtering;
    } //-- void setFiltering(boolean) 

    /**
     * Set 
     *             Describe the resource target path. For example,
     * if you want that 
     *             resource to appear in a specific package
     *             (<code>org.apache.maven.messages</code>), you
     * must specify this 
     *             element with this value:
     * <code>org/apache/maven/messages</code>.
     *             This is not required if you simply put the
     * resources in that directory structure at the source,
     * however.
     *           
     * 
     * @param targetPath
     */
    public void setTargetPath(String targetPath)
    {
        this.targetPath = targetPath;
    } //-- void setTargetPath(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
