/*
 * $Id$
 */

package org.apache.maven.model.io.dom4j;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.model.Branch;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.PackageGroup;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.SourceModification;
import org.apache.maven.model.UnitTest;
import org.apache.maven.model.Version;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/**
 * Class MavenDom4jReader.
 * 
 * @version $Revision$ $Date$
 */
public class MavenDom4jReader {


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method getBooleanValue
     * 
     * @param s
     * @param attribute
     */
    public boolean getBooleanValue(String s, String attribute)
    {
        if ( s != null )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue(String, String) 

    /**
     * Method getCharacterValue
     * 
     * @param s
     * @param attribute
     */
    public char getCharacterValue(String s, String attribute)
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue(String, String) 

    /**
     * Method getDateValue
     * 
     * @param s
     * @param attribute
     */
    public java.util.Date getDateValue(String s, String attribute)
        throws DocumentException
    {
        if ( s != null )
        {
            DateFormat dateParser = DateFormat.getDateTimeInstance( DateFormat.FULL, DateFormat.FULL , Locale.US );
            dateParser.setLenient( true );
            try
            {
                return dateParser.parse( s );
            }
            catch ( java.text.ParseException e )
            {
                throw new DocumentException( e.getMessage() );
            }
        }
        return null;
    } //-- java.util.Date getDateValue(String, String) 

    /**
     * Method getDoubleValue
     * 
     * @param s
     * @param strict
     * @param attribute
     */
    public double getDoubleValue(String s, String attribute, boolean strict)
        throws DocumentException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new DocumentException( "Unable to parse element '" + attribute + "', must be a floating point number" );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue(String, String, boolean) 

    /**
     * Method getFloatValue
     * 
     * @param s
     * @param strict
     * @param attribute
     */
    public float getFloatValue(String s, String attribute, boolean strict)
        throws DocumentException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new DocumentException( "Unable to parse element '" + attribute + "', must be a floating point number" );
                }
            }
        }
        return 0;
    } //-- float getFloatValue(String, String, boolean) 

    /**
     * Method getIntegerValue
     * 
     * @param s
     * @param strict
     * @param attribute
     */
    public int getIntegerValue(String s, String attribute, boolean strict)
        throws DocumentException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new DocumentException( "Unable to parse element '" + attribute + "', must be an integer" );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue(String, String, boolean) 

    /**
     * Method getLongValue
     * 
     * @param s
     * @param strict
     * @param attribute
     */
    public long getLongValue(String s, String attribute, boolean strict)
        throws DocumentException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new DocumentException( "Unable to parse element '" + attribute + "', must be a long integer" );
                }
            }
        }
        return 0;
    } //-- long getLongValue(String, String, boolean) 

    /**
     * Method getShortValue
     * 
     * @param s
     * @param strict
     * @param attribute
     */
    public short getShortValue(String s, String attribute, boolean strict)
        throws DocumentException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new DocumentException( "Unable to parse element '" + attribute + "', must be a short integer" );
                }
            }
        }
        return 0;
    } //-- short getShortValue(String, String, boolean) 

    /**
     * Method getTrimmedValue
     * 
     * @param s
     */
    public String getTrimmedValue(String s)
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue(String) 

    /**
     * Method writeElementToXpp3Dom
     * 
     * @param element
     */
    public Xpp3Dom writeElementToXpp3Dom(Element element)
    {
        Xpp3Dom xpp3Dom = new Xpp3Dom( element.getName() );
        if ( element.elements().isEmpty() && element.getText() != null )
        {
            xpp3Dom.setValue( element.getText() );
        }
        for ( Iterator i = element.attributeIterator(); i.hasNext(); )
        {
            Attribute attribute = (Attribute) i.next();
            xpp3Dom.setAttribute( attribute.getName(), attribute.getValue() );
        }
        for ( Iterator i = element.elementIterator(); i.hasNext(); )
        {
            Element child = (Element) i.next();
            xpp3Dom.addChild( writeElementToXpp3Dom( child ) );
        }
        return xpp3Dom;
    } //-- Xpp3Dom writeElementToXpp3Dom(Element) 

    /**
     * Method parseBranch
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private Branch parseBranch(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        Branch branch = new Branch();
        branch.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "tag" )  )
                {
                    if ( parsed.contains( "tag" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "tag" );
                    branch.setTag( getTrimmedValue( childElement.getText() ) );
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return branch;
    } //-- Branch parseBranch(String, Element, boolean, String) 

    /**
     * Method parseBuild
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private Build parseBuild(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        Build build = new Build();
        build.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "nagEmailAddress" )  )
                {
                    if ( parsed.contains( "nagEmailAddress" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "nagEmailAddress" );
                    build.setNagEmailAddress( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "sourceDirectory" )  )
                {
                    if ( parsed.contains( "sourceDirectory" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "sourceDirectory" );
                    build.setSourceDirectory( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "unitTestSourceDirectory" )  )
                {
                    if ( parsed.contains( "unitTestSourceDirectory" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "unitTestSourceDirectory" );
                    build.setUnitTestSourceDirectory( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "aspectSourceDirectory" )  )
                {
                    if ( parsed.contains( "aspectSourceDirectory" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "aspectSourceDirectory" );
                    build.setAspectSourceDirectory( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "integrationUnitTestSourceDirectory" )  )
                {
                    if ( parsed.contains( "integrationUnitTestSourceDirectory" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "integrationUnitTestSourceDirectory" );
                    build.setIntegrationUnitTestSourceDirectory( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "sourceModifications" )  )
                {
                    if ( parsed.contains( "sourceModifications" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "sourceModifications" );
                    java.util.List sourceModifications = new java.util.ArrayList();
                    build.setSourceModifications( sourceModifications );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "sourceModification" ) )
                            {
                                sourceModifications.add( parseSourceModification( "sourceModification", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "unitTest" )  )
                {
                    if ( parsed.contains( "unitTest" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "unitTest" );
                    build.setUnitTest( parseUnitTest( "unitTest", childElement, strict, encoding ) );
                }
                else if ( childElement.getName().equals( "defaultGoal" )  )
                {
                    if ( parsed.contains( "defaultGoal" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "defaultGoal" );
                    build.setDefaultGoal( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "resources" )  )
                {
                    if ( parsed.contains( "resources" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "resources" );
                    java.util.List resources = new java.util.ArrayList();
                    build.setResources( resources );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "resource" ) )
                            {
                                resources.add( parseResource( "resource", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return build;
    } //-- Build parseBuild(String, Element, boolean, String) 

    /**
     * Method parseBuildBase
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private BuildBase parseBuildBase(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        BuildBase buildBase = new BuildBase();
        buildBase.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "defaultGoal" )  )
                {
                    if ( parsed.contains( "defaultGoal" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "defaultGoal" );
                    buildBase.setDefaultGoal( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "resources" )  )
                {
                    if ( parsed.contains( "resources" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "resources" );
                    java.util.List resources = new java.util.ArrayList();
                    buildBase.setResources( resources );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "resource" ) )
                            {
                                resources.add( parseResource( "resource", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return buildBase;
    } //-- BuildBase parseBuildBase(String, Element, boolean, String) 

    /**
     * Method parseContributor
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private Contributor parseContributor(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        Contributor contributor = new Contributor();
        contributor.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "name" )  )
                {
                    if ( parsed.contains( "name" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "name" );
                    contributor.setName( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "email" )  )
                {
                    if ( parsed.contains( "email" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "email" );
                    contributor.setEmail( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "url" )  )
                {
                    if ( parsed.contains( "url" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "url" );
                    contributor.setUrl( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "organization" ) || childElement.getName().equals( "organisation" )  )
                {
                    if ( parsed.contains( "organization" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "organization" );
                    contributor.setOrganization( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "organizationUrl" ) || childElement.getName().equals( "organisationUrl" )  )
                {
                    if ( parsed.contains( "organizationUrl" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "organizationUrl" );
                    contributor.setOrganizationUrl( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "roles" )  )
                {
                    if ( parsed.contains( "roles" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "roles" );
                    java.util.List roles = new java.util.ArrayList();
                    contributor.setRoles( roles );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "role" ) )
                            {
                                roles.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "timezone" )  )
                {
                    if ( parsed.contains( "timezone" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "timezone" );
                    contributor.setTimezone( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "properties" )  )
                {
                    if ( parsed.contains( "properties" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "properties" );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            String key = listElement.getName();
                            String value = listElement.getText()
                            .trim()
                            ;
                            contributor.addProperty( key, value );
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return contributor;
    } //-- Contributor parseContributor(String, Element, boolean, String) 

    /**
     * Method parseDependency
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private Dependency parseDependency(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        Dependency dependency = new Dependency();
        dependency.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "id" )  )
                {
                    if ( parsed.contains( "id" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "id" );
                    dependency.setId( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "groupId" )  )
                {
                    if ( parsed.contains( "groupId" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "groupId" );
                    dependency.setGroupId( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "artifactId" )  )
                {
                    if ( parsed.contains( "artifactId" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "artifactId" );
                    dependency.setArtifactId( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "version" )  )
                {
                    if ( parsed.contains( "version" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "version" );
                    dependency.setVersion( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "url" )  )
                {
                    if ( parsed.contains( "url" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "url" );
                    dependency.setUrl( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "jar" )  )
                {
                    if ( parsed.contains( "jar" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "jar" );
                    dependency.setJar( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "type" )  )
                {
                    if ( parsed.contains( "type" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "type" );
                    dependency.setType( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "properties" )  )
                {
                    if ( parsed.contains( "properties" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "properties" );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            String key = listElement.getName();
                            String value = listElement.getText()
                            .trim()
                            ;
                            dependency.addProperty( key, value );
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return dependency;
    } //-- Dependency parseDependency(String, Element, boolean, String) 

    /**
     * Method parseDeveloper
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private Developer parseDeveloper(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        Developer developer = new Developer();
        developer.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "id" )  )
                {
                    if ( parsed.contains( "id" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "id" );
                    developer.setId( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "name" )  )
                {
                    if ( parsed.contains( "name" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "name" );
                    developer.setName( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "email" )  )
                {
                    if ( parsed.contains( "email" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "email" );
                    developer.setEmail( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "url" )  )
                {
                    if ( parsed.contains( "url" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "url" );
                    developer.setUrl( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "organization" ) || childElement.getName().equals( "organisation" )  )
                {
                    if ( parsed.contains( "organization" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "organization" );
                    developer.setOrganization( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "organizationUrl" ) || childElement.getName().equals( "organisationUrl" )  )
                {
                    if ( parsed.contains( "organizationUrl" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "organizationUrl" );
                    developer.setOrganizationUrl( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "roles" )  )
                {
                    if ( parsed.contains( "roles" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "roles" );
                    java.util.List roles = new java.util.ArrayList();
                    developer.setRoles( roles );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "role" ) )
                            {
                                roles.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "timezone" )  )
                {
                    if ( parsed.contains( "timezone" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "timezone" );
                    developer.setTimezone( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "properties" )  )
                {
                    if ( parsed.contains( "properties" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "properties" );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            String key = listElement.getName();
                            String value = listElement.getText()
                            .trim()
                            ;
                            developer.addProperty( key, value );
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return developer;
    } //-- Developer parseDeveloper(String, Element, boolean, String) 

    /**
     * Method parseFileSet
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private FileSet parseFileSet(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        FileSet fileSet = new FileSet();
        fileSet.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "directory" )  )
                {
                    if ( parsed.contains( "directory" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "directory" );
                    fileSet.setDirectory( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "includes" )  )
                {
                    if ( parsed.contains( "includes" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "includes" );
                    java.util.List includes = new java.util.ArrayList();
                    fileSet.setIncludes( includes );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "include" ) )
                            {
                                includes.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "excludes" )  )
                {
                    if ( parsed.contains( "excludes" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "excludes" );
                    java.util.List excludes = new java.util.ArrayList();
                    fileSet.setExcludes( excludes );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "exclude" ) )
                            {
                                excludes.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return fileSet;
    } //-- FileSet parseFileSet(String, Element, boolean, String) 

    /**
     * Method parseLicense
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private License parseLicense(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        License license = new License();
        license.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "name" )  )
                {
                    if ( parsed.contains( "name" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "name" );
                    license.setName( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "url" )  )
                {
                    if ( parsed.contains( "url" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "url" );
                    license.setUrl( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "distribution" )  )
                {
                    if ( parsed.contains( "distribution" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "distribution" );
                    license.setDistribution( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "comments" )  )
                {
                    if ( parsed.contains( "comments" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "comments" );
                    license.setComments( getTrimmedValue( childElement.getText() ) );
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return license;
    } //-- License parseLicense(String, Element, boolean, String) 

    /**
     * Method parseMailingList
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private MailingList parseMailingList(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        MailingList mailingList = new MailingList();
        mailingList.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "name" )  )
                {
                    if ( parsed.contains( "name" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "name" );
                    mailingList.setName( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "subscribe" )  )
                {
                    if ( parsed.contains( "subscribe" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "subscribe" );
                    mailingList.setSubscribe( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "unsubscribe" )  )
                {
                    if ( parsed.contains( "unsubscribe" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "unsubscribe" );
                    mailingList.setUnsubscribe( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "post" )  )
                {
                    if ( parsed.contains( "post" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "post" );
                    mailingList.setPost( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "archive" )  )
                {
                    if ( parsed.contains( "archive" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "archive" );
                    mailingList.setArchive( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "otherArchives" )  )
                {
                    if ( parsed.contains( "otherArchives" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "otherArchives" );
                    java.util.List otherArchives = new java.util.ArrayList();
                    mailingList.setOtherArchives( otherArchives );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "otherArchive" ) )
                            {
                                otherArchives.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return mailingList;
    } //-- MailingList parseMailingList(String, Element, boolean, String) 

    /**
     * Method parseModel
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private Model parseModel(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        Model model = new Model();
        model.setModelEncoding( encoding );
        if ( strict )
        {
            if ( !element.getName().equals( tagName ) )
            {
                throw new DocumentException( "Error parsing model: root element tag is '" + element.getName() + "' instead of '" + tagName + "'" );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "extend" )  )
                {
                    if ( parsed.contains( "extend" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "extend" );
                    model.setExtend( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "pomVersion" )  )
                {
                    if ( parsed.contains( "pomVersion" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "pomVersion" );
                    model.setPomVersion( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "groupId" )  )
                {
                    if ( parsed.contains( "groupId" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "groupId" );
                    model.setGroupId( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "artifactId" )  )
                {
                    if ( parsed.contains( "artifactId" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "artifactId" );
                    model.setArtifactId( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "id" )  )
                {
                    if ( parsed.contains( "id" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "id" );
                    model.setId( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "name" )  )
                {
                    if ( parsed.contains( "name" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "name" );
                    model.setName( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "currentVersion" )  )
                {
                    if ( parsed.contains( "currentVersion" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "currentVersion" );
                    model.setCurrentVersion( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "shortDescription" )  )
                {
                    if ( parsed.contains( "shortDescription" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "shortDescription" );
                    model.setShortDescription( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "description" )  )
                {
                    if ( parsed.contains( "description" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "description" );
                    model.setDescription( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "url" )  )
                {
                    if ( parsed.contains( "url" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "url" );
                    model.setUrl( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "logo" )  )
                {
                    if ( parsed.contains( "logo" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "logo" );
                    model.setLogo( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "issueTrackingUrl" )  )
                {
                    if ( parsed.contains( "issueTrackingUrl" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "issueTrackingUrl" );
                    model.setIssueTrackingUrl( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "inceptionYear" )  )
                {
                    if ( parsed.contains( "inceptionYear" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "inceptionYear" );
                    model.setInceptionYear( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "gumpRepositoryId" )  )
                {
                    if ( parsed.contains( "gumpRepositoryId" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "gumpRepositoryId" );
                    model.setGumpRepositoryId( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "siteAddress" )  )
                {
                    if ( parsed.contains( "siteAddress" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "siteAddress" );
                    model.setSiteAddress( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "siteDirectory" )  )
                {
                    if ( parsed.contains( "siteDirectory" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "siteDirectory" );
                    model.setSiteDirectory( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "distributionSite" )  )
                {
                    if ( parsed.contains( "distributionSite" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "distributionSite" );
                    model.setDistributionSite( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "distributionDirectory" )  )
                {
                    if ( parsed.contains( "distributionDirectory" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "distributionDirectory" );
                    model.setDistributionDirectory( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "mailingLists" )  )
                {
                    if ( parsed.contains( "mailingLists" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "mailingLists" );
                    java.util.List mailingLists = new java.util.ArrayList();
                    model.setMailingLists( mailingLists );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "mailingList" ) )
                            {
                                mailingLists.add( parseMailingList( "mailingList", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "developers" )  )
                {
                    if ( parsed.contains( "developers" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "developers" );
                    java.util.List developers = new java.util.ArrayList();
                    model.setDevelopers( developers );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "developer" ) )
                            {
                                developers.add( parseDeveloper( "developer", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "contributors" )  )
                {
                    if ( parsed.contains( "contributors" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "contributors" );
                    java.util.List contributors = new java.util.ArrayList();
                    model.setContributors( contributors );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "contributor" ) )
                            {
                                contributors.add( parseContributor( "contributor", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "licenses" )  )
                {
                    if ( parsed.contains( "licenses" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "licenses" );
                    java.util.List licenses = new java.util.ArrayList();
                    model.setLicenses( licenses );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "license" ) )
                            {
                                licenses.add( parseLicense( "license", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "versions" )  )
                {
                    if ( parsed.contains( "versions" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "versions" );
                    java.util.List versions = new java.util.ArrayList();
                    model.setVersions( versions );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "version" ) )
                            {
                                versions.add( parseVersion( "version", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "branches" )  )
                {
                    if ( parsed.contains( "branches" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "branches" );
                    java.util.List branches = new java.util.ArrayList();
                    model.setBranches( branches );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "branch" ) )
                            {
                                branches.add( parseBranch( "branch", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "packageGroups" )  )
                {
                    if ( parsed.contains( "packageGroups" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "packageGroups" );
                    java.util.List packageGroups = new java.util.ArrayList();
                    model.setPackageGroups( packageGroups );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "packageGroup" ) )
                            {
                                packageGroups.add( parsePackageGroup( "packageGroup", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "reports" )  )
                {
                    if ( parsed.contains( "reports" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "reports" );
                    java.util.List reports = new java.util.ArrayList();
                    model.setReports( reports );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "report" ) )
                            {
                                reports.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "repository" )  )
                {
                    if ( parsed.contains( "repository" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "repository" );
                    model.setRepository( parseRepository( "repository", childElement, strict, encoding ) );
                }
                else if ( childElement.getName().equals( "organization" ) || childElement.getName().equals( "organisation" )  )
                {
                    if ( parsed.contains( "organization" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "organization" );
                    model.setOrganization( parseOrganization( "organization", childElement, strict, encoding ) );
                }
                else if ( childElement.getName().equals( "properties" )  )
                {
                    if ( parsed.contains( "properties" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "properties" );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            String key = listElement.getName();
                            String value = listElement.getText()
                            .trim()
                            ;
                            model.addProperty( key, value );
                        }
                    }
                }
                else if ( childElement.getName().equals( "package" )  )
                {
                    if ( parsed.contains( "package" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "package" );
                    model.setPackageName( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "build" )  )
                {
                    if ( parsed.contains( "build" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "build" );
                    model.setBuild( parseBuild( "build", childElement, strict, encoding ) );
                }
                else if ( childElement.getName().equals( "dependencies" )  )
                {
                    if ( parsed.contains( "dependencies" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "dependencies" );
                    java.util.List dependencies = new java.util.ArrayList();
                    model.setDependencies( dependencies );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "dependency" ) )
                            {
                                dependencies.add( parseDependency( "dependency", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return model;
    } //-- Model parseModel(String, Element, boolean, String) 

    /**
     * Method parseModelBase
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private ModelBase parseModelBase(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        ModelBase modelBase = new ModelBase();
        modelBase.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "dependencies" )  )
                {
                    if ( parsed.contains( "dependencies" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "dependencies" );
                    java.util.List dependencies = new java.util.ArrayList();
                    modelBase.setDependencies( dependencies );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "dependency" ) )
                            {
                                dependencies.add( parseDependency( "dependency", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return modelBase;
    } //-- ModelBase parseModelBase(String, Element, boolean, String) 

    /**
     * Method parseOrganization
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private Organization parseOrganization(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        Organization organization = new Organization();
        organization.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "name" )  )
                {
                    if ( parsed.contains( "name" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "name" );
                    organization.setName( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "url" )  )
                {
                    if ( parsed.contains( "url" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "url" );
                    organization.setUrl( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "logo" )  )
                {
                    if ( parsed.contains( "logo" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "logo" );
                    organization.setLogo( getTrimmedValue( childElement.getText() ) );
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return organization;
    } //-- Organization parseOrganization(String, Element, boolean, String) 

    /**
     * Method parsePackageGroup
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private PackageGroup parsePackageGroup(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        PackageGroup packageGroup = new PackageGroup();
        packageGroup.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "title" )  )
                {
                    if ( parsed.contains( "title" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "title" );
                    packageGroup.setTitle( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "packages" )  )
                {
                    if ( parsed.contains( "packages" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "packages" );
                    packageGroup.setPackages( getTrimmedValue( childElement.getText() ) );
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return packageGroup;
    } //-- PackageGroup parsePackageGroup(String, Element, boolean, String) 

    /**
     * Method parsePatternSet
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private PatternSet parsePatternSet(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        PatternSet patternSet = new PatternSet();
        patternSet.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "includes" )  )
                {
                    if ( parsed.contains( "includes" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "includes" );
                    java.util.List includes = new java.util.ArrayList();
                    patternSet.setIncludes( includes );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "include" ) )
                            {
                                includes.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "excludes" )  )
                {
                    if ( parsed.contains( "excludes" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "excludes" );
                    java.util.List excludes = new java.util.ArrayList();
                    patternSet.setExcludes( excludes );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "exclude" ) )
                            {
                                excludes.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return patternSet;
    } //-- PatternSet parsePatternSet(String, Element, boolean, String) 

    /**
     * Method parsePluginConfiguration
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private PluginConfiguration parsePluginConfiguration(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        pluginConfiguration.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( strict )
                {
                    throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                }
            }
        }
        return pluginConfiguration;
    } //-- PluginConfiguration parsePluginConfiguration(String, Element, boolean, String) 

    /**
     * Method parsePluginContainer
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private PluginContainer parsePluginContainer(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        PluginContainer pluginContainer = new PluginContainer();
        pluginContainer.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( strict )
                {
                    throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                }
            }
        }
        return pluginContainer;
    } //-- PluginContainer parsePluginContainer(String, Element, boolean, String) 

    /**
     * Method parseRepository
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private Repository parseRepository(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        Repository repository = new Repository();
        repository.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "connection" )  )
                {
                    if ( parsed.contains( "connection" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "connection" );
                    repository.setConnection( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "developerConnection" )  )
                {
                    if ( parsed.contains( "developerConnection" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "developerConnection" );
                    repository.setDeveloperConnection( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "url" )  )
                {
                    if ( parsed.contains( "url" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "url" );
                    repository.setUrl( getTrimmedValue( childElement.getText() ) );
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return repository;
    } //-- Repository parseRepository(String, Element, boolean, String) 

    /**
     * Method parseResource
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private Resource parseResource(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        Resource resource = new Resource();
        resource.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "targetPath" )  )
                {
                    if ( parsed.contains( "targetPath" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "targetPath" );
                    resource.setTargetPath( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "filtering" )  )
                {
                    if ( parsed.contains( "filtering" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "filtering" );
                    resource.setFiltering( getBooleanValue( getTrimmedValue( childElement.getText() ), "filtering" ) );
                }
                else if ( childElement.getName().equals( "directory" )  )
                {
                    if ( parsed.contains( "directory" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "directory" );
                    resource.setDirectory( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "includes" )  )
                {
                    if ( parsed.contains( "includes" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "includes" );
                    java.util.List includes = new java.util.ArrayList();
                    resource.setIncludes( includes );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "include" ) )
                            {
                                includes.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "excludes" )  )
                {
                    if ( parsed.contains( "excludes" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "excludes" );
                    java.util.List excludes = new java.util.ArrayList();
                    resource.setExcludes( excludes );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "exclude" ) )
                            {
                                excludes.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return resource;
    } //-- Resource parseResource(String, Element, boolean, String) 

    /**
     * Method parseSourceModification
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private SourceModification parseSourceModification(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        SourceModification sourceModification = new SourceModification();
        sourceModification.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "className" )  )
                {
                    if ( parsed.contains( "className" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "className" );
                    sourceModification.setClassName( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "property" )  )
                {
                    if ( parsed.contains( "property" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "property" );
                    sourceModification.setProperty( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "directory" )  )
                {
                    if ( parsed.contains( "directory" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "directory" );
                    sourceModification.setDirectory( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "includes" )  )
                {
                    if ( parsed.contains( "includes" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "includes" );
                    java.util.List includes = new java.util.ArrayList();
                    sourceModification.setIncludes( includes );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "include" ) )
                            {
                                includes.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "excludes" )  )
                {
                    if ( parsed.contains( "excludes" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "excludes" );
                    java.util.List excludes = new java.util.ArrayList();
                    sourceModification.setExcludes( excludes );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "exclude" ) )
                            {
                                excludes.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return sourceModification;
    } //-- SourceModification parseSourceModification(String, Element, boolean, String) 

    /**
     * Method parseUnitTest
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private UnitTest parseUnitTest(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        UnitTest unitTest = new UnitTest();
        unitTest.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "resources" )  )
                {
                    if ( parsed.contains( "resources" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "resources" );
                    java.util.List resources = new java.util.ArrayList();
                    unitTest.setResources( resources );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "resource" ) )
                            {
                                resources.add( parseResource( "resource", listElement, strict, encoding ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "includes" )  )
                {
                    if ( parsed.contains( "includes" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "includes" );
                    java.util.List includes = new java.util.ArrayList();
                    unitTest.setIncludes( includes );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "include" ) )
                            {
                                includes.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else if ( childElement.getName().equals( "excludes" )  )
                {
                    if ( parsed.contains( "excludes" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "excludes" );
                    java.util.List excludes = new java.util.ArrayList();
                    unitTest.setExcludes( excludes );
                    for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )
                    {
                        Node n = (Node) j.next();
                        if ( n.getNodeType() != Node.ELEMENT_NODE )
                        {
                        }
                        else
                        {
                            Element listElement = (Element) n;
                            if ( listElement.getName().equals( "exclude" ) )
                            {
                                excludes.add( getTrimmedValue( listElement.getText() ) );
                            }
                            else
                            {
                            }
                        }
                    }
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return unitTest;
    } //-- UnitTest parseUnitTest(String, Element, boolean, String) 

    /**
     * Method parseVersion
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param element
     */
    private Version parseVersion(String tagName, Element element, boolean strict, String encoding)
        throws IOException, DocumentException
    {
        Version version = new Version();
        version.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        for ( Iterator i = element.nodeIterator(); i.hasNext(); )
        {
            Node node = (Node) i.next();
            if ( node.getNodeType() != Node.ELEMENT_NODE )
            {
            }
            else
            {
                Element childElement = (Element) node;
                if ( childElement.getName().equals( "name" )  )
                {
                    if ( parsed.contains( "name" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "name" );
                    version.setName( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "tag" )  )
                {
                    if ( parsed.contains( "tag" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "tag" );
                    version.setTag( getTrimmedValue( childElement.getText() ) );
                }
                else if ( childElement.getName().equals( "id" )  )
                {
                    if ( parsed.contains( "id" ) )
                    {
                        throw new DocumentException( "Duplicated tag: '" + element.getName() + "'");
                    }
                    parsed.add( "id" );
                    version.setId( getTrimmedValue( childElement.getText() ) );
                }
                else
                {
                    if ( strict )
                    {
                        throw new DocumentException( "Unrecognised tag: '" + childElement.getName() + "'" );
                    }
                }
            }
        }
        return version;
    } //-- Version parseVersion(String, Element, boolean, String) 

    /**
     * Method read
     * 
     * @param reader
     * @param strict
     */
    public Model read(Reader reader, boolean strict)
        throws IOException, DocumentException
    {
        SAXReader parser = new SAXReader();
        Document document = parser.read( reader );
        String encoding = document.getXMLEncoding();
        return parseModel( "project", document.getRootElement(), strict, encoding );
    } //-- Model read(Reader, boolean) 

    /**
     * Method read
     * 
     * @param reader
     */
    public Model read(Reader reader)
        throws IOException, DocumentException
    {
        return read( reader, true );
    } //-- Model read(Reader) 

    /**
     * Method read
     * 
     * @param url
     * @param strict
     */
    public Model read(URL url, boolean strict)
        throws IOException, DocumentException
    {
        SAXReader parser = new SAXReader();
        Document document = parser.read( url );
        String encoding = document.getXMLEncoding();
        return parseModel( "project", document.getRootElement(), strict, encoding );
    } //-- Model read(URL, boolean) 

    /**
     * Method read
     * 
     * @param url
     */
    public Model read(URL url)
        throws IOException, DocumentException
    {
        return read( url, true );
    } //-- Model read(URL) 


}
