/*
 * $Id$
 */

package org.apache.maven.model.io.dom4j;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.model.Branch;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.PackageGroup;
import org.apache.maven.model.PatternSet;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.SourceModification;
import org.apache.maven.model.UnitTest;
import org.apache.maven.model.Version;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/**
 * Class MavenDom4jWriter.
 * 
 * @version $Revision$ $Date$
 */
public class MavenDom4jWriter {


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param project
     */
    public void write(Writer writer, Model project)
        throws java.io.IOException
    {
        Document document = new DocumentFactory().createDocument();
        writeModel( project, "project", document );
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setLineSeparator( System.getProperty( "line.separator" ) );
        XMLWriter serializer = new XMLWriter( writer, format );
        serializer.write( document );
    } //-- void write(Writer, Model) 

    /**
     * Method writeXpp3DomToElement
     * 
     * @param xpp3Dom
     * @param parentElement
     */
    public void writeXpp3DomToElement(Xpp3Dom xpp3Dom, Element parentElement)
    {
        Element element = parentElement.addElement( xpp3Dom.getName() );
        if ( xpp3Dom.getValue() != null )
        {
            element.setText( xpp3Dom.getValue() );
        }
        for ( Iterator i = Arrays.asList( xpp3Dom.getAttributeNames() ).iterator(); i.hasNext(); )
        {
            String name = (String) i.next();
            element.addAttribute( name, xpp3Dom.getAttribute( name ) );
        }
        for ( Iterator i = Arrays.asList( xpp3Dom.getChildren() ).iterator(); i.hasNext(); )
        {
            Xpp3Dom child = (Xpp3Dom) i.next();
            writeXpp3DomToElement( child, element );
        }
    } //-- void writeXpp3DomToElement(Xpp3Dom, Element) 

    /**
     * Method writeBranch
     * 
     * @param branch
     * @param parentElement
     * @param tagName
     */
    private void writeBranch(Branch branch, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( branch != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( branch.getTag() != null )
            {
                element.addElement( "tag" ).setText( branch.getTag() );
            }
        }
    } //-- void writeBranch(Branch, String, Element) 

    /**
     * Method writeBuild
     * 
     * @param build
     * @param parentElement
     * @param tagName
     */
    private void writeBuild(Build build, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( build != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( build.getNagEmailAddress() != null )
            {
                element.addElement( "nagEmailAddress" ).setText( build.getNagEmailAddress() );
            }
            if ( build.getSourceDirectory() != null )
            {
                element.addElement( "sourceDirectory" ).setText( build.getSourceDirectory() );
            }
            if ( build.getUnitTestSourceDirectory() != null )
            {
                element.addElement( "unitTestSourceDirectory" ).setText( build.getUnitTestSourceDirectory() );
            }
            if ( build.getAspectSourceDirectory() != null )
            {
                element.addElement( "aspectSourceDirectory" ).setText( build.getAspectSourceDirectory() );
            }
            if ( build.getIntegrationUnitTestSourceDirectory() != null )
            {
                element.addElement( "integrationUnitTestSourceDirectory" ).setText( build.getIntegrationUnitTestSourceDirectory() );
            }
            if ( build.getSourceModifications() != null && build.getSourceModifications().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "sourceModifications" );
                for ( Iterator iter = build.getSourceModifications().iterator(); iter.hasNext(); )
                {
                    SourceModification o = (SourceModification) iter.next();
                    writeSourceModification( o, "sourceModification", listElement );
                }
            }
            if ( build.getUnitTest() != null )
            {
                writeUnitTest( build.getUnitTest(), "unitTest", element );
            }
            if ( build.getDefaultGoal() != null )
            {
                element.addElement( "defaultGoal" ).setText( build.getDefaultGoal() );
            }
            if ( build.getResources() != null && build.getResources().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "resources" );
                for ( Iterator iter = build.getResources().iterator(); iter.hasNext(); )
                {
                    Resource o = (Resource) iter.next();
                    writeResource( o, "resource", listElement );
                }
            }
        }
    } //-- void writeBuild(Build, String, Element) 

    /**
     * Method writeBuildBase
     * 
     * @param buildBase
     * @param parentElement
     * @param tagName
     */
    private void writeBuildBase(BuildBase buildBase, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( buildBase != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( buildBase.getDefaultGoal() != null )
            {
                element.addElement( "defaultGoal" ).setText( buildBase.getDefaultGoal() );
            }
            if ( buildBase.getResources() != null && buildBase.getResources().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "resources" );
                for ( Iterator iter = buildBase.getResources().iterator(); iter.hasNext(); )
                {
                    Resource o = (Resource) iter.next();
                    writeResource( o, "resource", listElement );
                }
            }
        }
    } //-- void writeBuildBase(BuildBase, String, Element) 

    /**
     * Method writeContributor
     * 
     * @param contributor
     * @param parentElement
     * @param tagName
     */
    private void writeContributor(Contributor contributor, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( contributor != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( contributor.getName() != null )
            {
                element.addElement( "name" ).setText( contributor.getName() );
            }
            if ( contributor.getEmail() != null )
            {
                element.addElement( "email" ).setText( contributor.getEmail() );
            }
            if ( contributor.getUrl() != null )
            {
                element.addElement( "url" ).setText( contributor.getUrl() );
            }
            if ( contributor.getOrganization() != null )
            {
                element.addElement( "organization" ).setText( contributor.getOrganization() );
            }
            if ( contributor.getOrganizationUrl() != null )
            {
                element.addElement( "organizationUrl" ).setText( contributor.getOrganizationUrl() );
            }
            if ( contributor.getRoles() != null && contributor.getRoles().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "roles" );
                for ( Iterator iter = contributor.getRoles().iterator(); iter.hasNext(); )
                {
                    String role = (String) iter.next();
                    listElement.addElement( "role" ).setText( role );
                }
            }
            if ( contributor.getTimezone() != null )
            {
                element.addElement( "timezone" ).setText( contributor.getTimezone() );
            }
            if ( contributor.getProperties() != null && contributor.getProperties().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "properties" );
                for ( Iterator iter = contributor.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) contributor.getProperties().get( key );
                    listElement.addElement( key ).setText( value );
                }
            }
        }
    } //-- void writeContributor(Contributor, String, Element) 

    /**
     * Method writeDependency
     * 
     * @param dependency
     * @param parentElement
     * @param tagName
     */
    private void writeDependency(Dependency dependency, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( dependency != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( dependency.getId() != null )
            {
                element.addElement( "id" ).setText( dependency.getId() );
            }
            if ( dependency.getGroupId() != null )
            {
                element.addElement( "groupId" ).setText( dependency.getGroupId() );
            }
            if ( dependency.getArtifactId() != null )
            {
                element.addElement( "artifactId" ).setText( dependency.getArtifactId() );
            }
            if ( dependency.getVersion() != null )
            {
                element.addElement( "version" ).setText( dependency.getVersion() );
            }
            if ( dependency.getUrl() != null )
            {
                element.addElement( "url" ).setText( dependency.getUrl() );
            }
            if ( dependency.getJar() != null )
            {
                element.addElement( "jar" ).setText( dependency.getJar() );
            }
            if ( dependency.getType() != null && !dependency.getType().equals( "jar" ) )
            {
                element.addElement( "type" ).setText( dependency.getType() );
            }
            if ( dependency.getProperties() != null && dependency.getProperties().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "properties" );
                for ( Iterator iter = dependency.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) dependency.getProperties().get( key );
                    listElement.addElement( key ).setText( value );
                }
            }
        }
    } //-- void writeDependency(Dependency, String, Element) 

    /**
     * Method writeDeveloper
     * 
     * @param developer
     * @param parentElement
     * @param tagName
     */
    private void writeDeveloper(Developer developer, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( developer != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( developer.getId() != null )
            {
                element.addElement( "id" ).setText( developer.getId() );
            }
            if ( developer.getName() != null )
            {
                element.addElement( "name" ).setText( developer.getName() );
            }
            if ( developer.getEmail() != null )
            {
                element.addElement( "email" ).setText( developer.getEmail() );
            }
            if ( developer.getUrl() != null )
            {
                element.addElement( "url" ).setText( developer.getUrl() );
            }
            if ( developer.getOrganization() != null )
            {
                element.addElement( "organization" ).setText( developer.getOrganization() );
            }
            if ( developer.getOrganizationUrl() != null )
            {
                element.addElement( "organizationUrl" ).setText( developer.getOrganizationUrl() );
            }
            if ( developer.getRoles() != null && developer.getRoles().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "roles" );
                for ( Iterator iter = developer.getRoles().iterator(); iter.hasNext(); )
                {
                    String role = (String) iter.next();
                    listElement.addElement( "role" ).setText( role );
                }
            }
            if ( developer.getTimezone() != null )
            {
                element.addElement( "timezone" ).setText( developer.getTimezone() );
            }
            if ( developer.getProperties() != null && developer.getProperties().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "properties" );
                for ( Iterator iter = developer.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) developer.getProperties().get( key );
                    listElement.addElement( key ).setText( value );
                }
            }
        }
    } //-- void writeDeveloper(Developer, String, Element) 

    /**
     * Method writeFileSet
     * 
     * @param fileSet
     * @param parentElement
     * @param tagName
     */
    private void writeFileSet(FileSet fileSet, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( fileSet != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( fileSet.getDirectory() != null )
            {
                element.addElement( "directory" ).setText( fileSet.getDirectory() );
            }
            if ( fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "includes" );
                for ( Iterator iter = fileSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    listElement.addElement( "include" ).setText( include );
                }
            }
            if ( fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "excludes" );
                for ( Iterator iter = fileSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    listElement.addElement( "exclude" ).setText( exclude );
                }
            }
        }
    } //-- void writeFileSet(FileSet, String, Element) 

    /**
     * Method writeLicense
     * 
     * @param license
     * @param parentElement
     * @param tagName
     */
    private void writeLicense(License license, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( license != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( license.getName() != null )
            {
                element.addElement( "name" ).setText( license.getName() );
            }
            if ( license.getUrl() != null )
            {
                element.addElement( "url" ).setText( license.getUrl() );
            }
            if ( license.getDistribution() != null )
            {
                element.addElement( "distribution" ).setText( license.getDistribution() );
            }
            if ( license.getComments() != null )
            {
                element.addElement( "comments" ).setText( license.getComments() );
            }
        }
    } //-- void writeLicense(License, String, Element) 

    /**
     * Method writeMailingList
     * 
     * @param mailingList
     * @param parentElement
     * @param tagName
     */
    private void writeMailingList(MailingList mailingList, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( mailingList != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( mailingList.getName() != null )
            {
                element.addElement( "name" ).setText( mailingList.getName() );
            }
            if ( mailingList.getSubscribe() != null )
            {
                element.addElement( "subscribe" ).setText( mailingList.getSubscribe() );
            }
            if ( mailingList.getUnsubscribe() != null )
            {
                element.addElement( "unsubscribe" ).setText( mailingList.getUnsubscribe() );
            }
            if ( mailingList.getPost() != null )
            {
                element.addElement( "post" ).setText( mailingList.getPost() );
            }
            if ( mailingList.getArchive() != null )
            {
                element.addElement( "archive" ).setText( mailingList.getArchive() );
            }
            if ( mailingList.getOtherArchives() != null && mailingList.getOtherArchives().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "otherArchives" );
                for ( Iterator iter = mailingList.getOtherArchives().iterator(); iter.hasNext(); )
                {
                    String otherArchive = (String) iter.next();
                    listElement.addElement( "otherArchive" ).setText( otherArchive );
                }
            }
        }
    } //-- void writeMailingList(MailingList, String, Element) 

    /**
     * Method writeModel
     * 
     * @param model
     * @param parentElement
     * @param tagName
     */
    private void writeModel(Model model, String tagName, Document parentElement)
        throws java.io.IOException
    {
        if ( model != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( model.getExtend() != null )
            {
                element.addElement( "extend" ).setText( model.getExtend() );
            }
            if ( model.getPomVersion() != null )
            {
                element.addElement( "pomVersion" ).setText( model.getPomVersion() );
            }
            if ( model.getGroupId() != null )
            {
                element.addElement( "groupId" ).setText( model.getGroupId() );
            }
            if ( model.getArtifactId() != null )
            {
                element.addElement( "artifactId" ).setText( model.getArtifactId() );
            }
            if ( model.getId() != null )
            {
                element.addElement( "id" ).setText( model.getId() );
            }
            if ( model.getName() != null )
            {
                element.addElement( "name" ).setText( model.getName() );
            }
            if ( model.getCurrentVersion() != null )
            {
                element.addElement( "currentVersion" ).setText( model.getCurrentVersion() );
            }
            if ( model.getShortDescription() != null )
            {
                element.addElement( "shortDescription" ).setText( model.getShortDescription() );
            }
            if ( model.getDescription() != null )
            {
                element.addElement( "description" ).setText( model.getDescription() );
            }
            if ( model.getUrl() != null )
            {
                element.addElement( "url" ).setText( model.getUrl() );
            }
            if ( model.getLogo() != null )
            {
                element.addElement( "logo" ).setText( model.getLogo() );
            }
            if ( model.getIssueTrackingUrl() != null )
            {
                element.addElement( "issueTrackingUrl" ).setText( model.getIssueTrackingUrl() );
            }
            if ( model.getInceptionYear() != null )
            {
                element.addElement( "inceptionYear" ).setText( model.getInceptionYear() );
            }
            if ( model.getGumpRepositoryId() != null )
            {
                element.addElement( "gumpRepositoryId" ).setText( model.getGumpRepositoryId() );
            }
            if ( model.getSiteAddress() != null )
            {
                element.addElement( "siteAddress" ).setText( model.getSiteAddress() );
            }
            if ( model.getSiteDirectory() != null )
            {
                element.addElement( "siteDirectory" ).setText( model.getSiteDirectory() );
            }
            if ( model.getDistributionSite() != null )
            {
                element.addElement( "distributionSite" ).setText( model.getDistributionSite() );
            }
            if ( model.getDistributionDirectory() != null )
            {
                element.addElement( "distributionDirectory" ).setText( model.getDistributionDirectory() );
            }
            if ( model.getMailingLists() != null && model.getMailingLists().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "mailingLists" );
                for ( Iterator iter = model.getMailingLists().iterator(); iter.hasNext(); )
                {
                    MailingList o = (MailingList) iter.next();
                    writeMailingList( o, "mailingList", listElement );
                }
            }
            if ( model.getDevelopers() != null && model.getDevelopers().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "developers" );
                for ( Iterator iter = model.getDevelopers().iterator(); iter.hasNext(); )
                {
                    Developer o = (Developer) iter.next();
                    writeDeveloper( o, "developer", listElement );
                }
            }
            if ( model.getContributors() != null && model.getContributors().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "contributors" );
                for ( Iterator iter = model.getContributors().iterator(); iter.hasNext(); )
                {
                    Contributor o = (Contributor) iter.next();
                    writeContributor( o, "contributor", listElement );
                }
            }
            if ( model.getLicenses() != null && model.getLicenses().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "licenses" );
                for ( Iterator iter = model.getLicenses().iterator(); iter.hasNext(); )
                {
                    License o = (License) iter.next();
                    writeLicense( o, "license", listElement );
                }
            }
            if ( model.getVersions() != null && model.getVersions().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "versions" );
                for ( Iterator iter = model.getVersions().iterator(); iter.hasNext(); )
                {
                    Version o = (Version) iter.next();
                    writeVersion( o, "version", listElement );
                }
            }
            if ( model.getBranches() != null && model.getBranches().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "branches" );
                for ( Iterator iter = model.getBranches().iterator(); iter.hasNext(); )
                {
                    Branch o = (Branch) iter.next();
                    writeBranch( o, "branch", listElement );
                }
            }
            if ( model.getPackageGroups() != null && model.getPackageGroups().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "packageGroups" );
                for ( Iterator iter = model.getPackageGroups().iterator(); iter.hasNext(); )
                {
                    PackageGroup o = (PackageGroup) iter.next();
                    writePackageGroup( o, "packageGroup", listElement );
                }
            }
            if ( model.getReports() != null && model.getReports().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "reports" );
                for ( Iterator iter = model.getReports().iterator(); iter.hasNext(); )
                {
                    String report = (String) iter.next();
                    listElement.addElement( "report" ).setText( report );
                }
            }
            if ( model.getRepository() != null )
            {
                writeRepository( model.getRepository(), "repository", element );
            }
            if ( model.getOrganization() != null )
            {
                writeOrganization( model.getOrganization(), "organization", element );
            }
            if ( model.getProperties() != null && model.getProperties().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "properties" );
                for ( Iterator iter = model.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) model.getProperties().get( key );
                    listElement.addElement( key ).setText( value );
                }
            }
            if ( model.getPackageName() != null )
            {
                element.addElement( "package" ).setText( model.getPackageName() );
            }
            if ( model.getBuild() != null )
            {
                writeBuild( model.getBuild(), "build", element );
            }
            if ( model.getDependencies() != null && model.getDependencies().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "dependencies" );
                for ( Iterator iter = model.getDependencies().iterator(); iter.hasNext(); )
                {
                    Dependency o = (Dependency) iter.next();
                    writeDependency( o, "dependency", listElement );
                }
            }
        }
    } //-- void writeModel(Model, String, Document) 

    /**
     * Method writeModelBase
     * 
     * @param modelBase
     * @param parentElement
     * @param tagName
     */
    private void writeModelBase(ModelBase modelBase, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( modelBase != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( modelBase.getDependencies() != null && modelBase.getDependencies().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "dependencies" );
                for ( Iterator iter = modelBase.getDependencies().iterator(); iter.hasNext(); )
                {
                    Dependency o = (Dependency) iter.next();
                    writeDependency( o, "dependency", listElement );
                }
            }
        }
    } //-- void writeModelBase(ModelBase, String, Element) 

    /**
     * Method writeOrganization
     * 
     * @param organization
     * @param parentElement
     * @param tagName
     */
    private void writeOrganization(Organization organization, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( organization != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( organization.getName() != null )
            {
                element.addElement( "name" ).setText( organization.getName() );
            }
            if ( organization.getUrl() != null )
            {
                element.addElement( "url" ).setText( organization.getUrl() );
            }
            if ( organization.getLogo() != null )
            {
                element.addElement( "logo" ).setText( organization.getLogo() );
            }
        }
    } //-- void writeOrganization(Organization, String, Element) 

    /**
     * Method writePackageGroup
     * 
     * @param packageGroup
     * @param parentElement
     * @param tagName
     */
    private void writePackageGroup(PackageGroup packageGroup, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( packageGroup != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( packageGroup.getTitle() != null )
            {
                element.addElement( "title" ).setText( packageGroup.getTitle() );
            }
            if ( packageGroup.getPackages() != null )
            {
                element.addElement( "packages" ).setText( packageGroup.getPackages() );
            }
        }
    } //-- void writePackageGroup(PackageGroup, String, Element) 

    /**
     * Method writePatternSet
     * 
     * @param patternSet
     * @param parentElement
     * @param tagName
     */
    private void writePatternSet(PatternSet patternSet, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( patternSet != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( patternSet.getIncludes() != null && patternSet.getIncludes().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "includes" );
                for ( Iterator iter = patternSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    listElement.addElement( "include" ).setText( include );
                }
            }
            if ( patternSet.getExcludes() != null && patternSet.getExcludes().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "excludes" );
                for ( Iterator iter = patternSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    listElement.addElement( "exclude" ).setText( exclude );
                }
            }
        }
    } //-- void writePatternSet(PatternSet, String, Element) 

    /**
     * Method writePluginConfiguration
     * 
     * @param pluginConfiguration
     * @param parentElement
     * @param tagName
     */
    private void writePluginConfiguration(PluginConfiguration pluginConfiguration, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( pluginConfiguration != null )
        {
            Element element = parentElement.addElement( tagName );
        }
    } //-- void writePluginConfiguration(PluginConfiguration, String, Element) 

    /**
     * Method writePluginContainer
     * 
     * @param pluginContainer
     * @param parentElement
     * @param tagName
     */
    private void writePluginContainer(PluginContainer pluginContainer, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( pluginContainer != null )
        {
            Element element = parentElement.addElement( tagName );
        }
    } //-- void writePluginContainer(PluginContainer, String, Element) 

    /**
     * Method writeRepository
     * 
     * @param repository
     * @param parentElement
     * @param tagName
     */
    private void writeRepository(Repository repository, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( repository != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( repository.getConnection() != null )
            {
                element.addElement( "connection" ).setText( repository.getConnection() );
            }
            if ( repository.getDeveloperConnection() != null )
            {
                element.addElement( "developerConnection" ).setText( repository.getDeveloperConnection() );
            }
            if ( repository.getUrl() != null )
            {
                element.addElement( "url" ).setText( repository.getUrl() );
            }
        }
    } //-- void writeRepository(Repository, String, Element) 

    /**
     * Method writeResource
     * 
     * @param resource
     * @param parentElement
     * @param tagName
     */
    private void writeResource(Resource resource, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( resource != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( resource.getTargetPath() != null )
            {
                element.addElement( "targetPath" ).setText( resource.getTargetPath() );
            }
            if ( resource.isFiltering() != false )
            {
                element.addElement( "filtering" ).setText( String.valueOf( resource.isFiltering() ) );
            }
            if ( resource.getDirectory() != null )
            {
                element.addElement( "directory" ).setText( resource.getDirectory() );
            }
            if ( resource.getIncludes() != null && resource.getIncludes().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "includes" );
                for ( Iterator iter = resource.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    listElement.addElement( "include" ).setText( include );
                }
            }
            if ( resource.getExcludes() != null && resource.getExcludes().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "excludes" );
                for ( Iterator iter = resource.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    listElement.addElement( "exclude" ).setText( exclude );
                }
            }
        }
    } //-- void writeResource(Resource, String, Element) 

    /**
     * Method writeSourceModification
     * 
     * @param sourceModification
     * @param parentElement
     * @param tagName
     */
    private void writeSourceModification(SourceModification sourceModification, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( sourceModification != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( sourceModification.getClassName() != null )
            {
                element.addElement( "className" ).setText( sourceModification.getClassName() );
            }
            if ( sourceModification.getProperty() != null )
            {
                element.addElement( "property" ).setText( sourceModification.getProperty() );
            }
            if ( sourceModification.getDirectory() != null )
            {
                element.addElement( "directory" ).setText( sourceModification.getDirectory() );
            }
            if ( sourceModification.getIncludes() != null && sourceModification.getIncludes().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "includes" );
                for ( Iterator iter = sourceModification.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    listElement.addElement( "include" ).setText( include );
                }
            }
            if ( sourceModification.getExcludes() != null && sourceModification.getExcludes().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "excludes" );
                for ( Iterator iter = sourceModification.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    listElement.addElement( "exclude" ).setText( exclude );
                }
            }
        }
    } //-- void writeSourceModification(SourceModification, String, Element) 

    /**
     * Method writeUnitTest
     * 
     * @param unitTest
     * @param parentElement
     * @param tagName
     */
    private void writeUnitTest(UnitTest unitTest, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( unitTest != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( unitTest.getResources() != null && unitTest.getResources().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "resources" );
                for ( Iterator iter = unitTest.getResources().iterator(); iter.hasNext(); )
                {
                    Resource o = (Resource) iter.next();
                    writeResource( o, "resource", listElement );
                }
            }
            if ( unitTest.getIncludes() != null && unitTest.getIncludes().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "includes" );
                for ( Iterator iter = unitTest.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    listElement.addElement( "include" ).setText( include );
                }
            }
            if ( unitTest.getExcludes() != null && unitTest.getExcludes().size() > 0 )
            {
                Element listElement = element;
                listElement = element.addElement( "excludes" );
                for ( Iterator iter = unitTest.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    listElement.addElement( "exclude" ).setText( exclude );
                }
            }
        }
    } //-- void writeUnitTest(UnitTest, String, Element) 

    /**
     * Method writeVersion
     * 
     * @param version
     * @param parentElement
     * @param tagName
     */
    private void writeVersion(Version version, String tagName, Element parentElement)
        throws java.io.IOException
    {
        if ( version != null )
        {
            Element element = parentElement.addElement( tagName );
            if ( version.getName() != null )
            {
                element.addElement( "name" ).setText( version.getName() );
            }
            if ( version.getTag() != null )
            {
                element.addElement( "tag" ).setText( version.getTag() );
            }
            if ( version.getId() != null )
            {
                element.addElement( "id" ).setText( version.getId() );
            }
        }
    } //-- void writeVersion(Version, String, Element) 


}
