/*
 * $Id$
 */

package org.apache.maven.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Build extends BuildBase 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field nagEmailAddress
     */
    private String nagEmailAddress;

    /**
     * Field sourceDirectory
     */
    private String sourceDirectory;

    /**
     * Field unitTestSourceDirectory
     */
    private String unitTestSourceDirectory;

    /**
     * Field aspectSourceDirectory
     */
    private String aspectSourceDirectory;

    /**
     * Field integrationUnitTestSourceDirectory
     */
    private String integrationUnitTestSourceDirectory;

    /**
     * Field sourceModifications
     */
    private java.util.List sourceModifications;

    /**
     * Field unitTest
     */
    private UnitTest unitTest = new UnitTest();


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addSourceModification
     * 
     * @param sourceModification
     */
    public void addSourceModification(SourceModification sourceModification)
    {
        if ( !(sourceModification instanceof SourceModification) )
        {
            throw new ClassCastException( "Build.addSourceModifications(sourceModification) parameter must be instanceof " + SourceModification.class.getName() );
        }
        getSourceModifications().add( sourceModification );
    } //-- void addSourceModification(SourceModification) 

    /**
     * Get     
     *              This element specifies a directory containing
     * Aspect    
     *              sources of the project.  The generated build
     * system will    
     *              compile the Aspects in this directory when the
     * project is    
     *              built if Aspects have been enabled.
     *              The path given is relative to the project
     * descriptor.    
     *            
     */
    public String getAspectSourceDirectory()
    {
        return this.aspectSourceDirectory;
    } //-- String getAspectSourceDirectory() 

    /**
     * Get     
     *              This element is <strong>deprecated</strong> and
     * should no longer be used.
     *              Initially it was used by the first Cactus
     * plugin. Now
     *              the location of the Cactus test sources is
     * defined
     *              through a plugin property. See the Cactus
     * plugin
     *              <a
     * href="http://jakarta.apache.org/cactus/integration/maven/properties.html">properties</a>
     *              page.
     *             
     */
    public String getIntegrationUnitTestSourceDirectory()
    {
        return this.integrationUnitTestSourceDirectory;
    } //-- String getIntegrationUnitTestSourceDirectory() 

    /**
     * Get 
     *             An address to which notifications regarding the
     * status of builds
     *             for this project can be sent. This is intended
     * for use by tools
     *             which do unattended builds, for example those
     * providing for
     *             continuous integration.
     *           
     */
    public String getNagEmailAddress()
    {
        return this.nagEmailAddress;
    } //-- String getNagEmailAddress() 

    /**
     * Get 
     *             This element specifies a directory containing
     * the source
     *             of the project. The generated build system will
     * compile
     *             the source in this directory when the project is
     * built.
     *             The path given is relative to the project
     * descriptor.
     *           
     */
    public String getSourceDirectory()
    {
        return this.sourceDirectory;
    } //-- String getSourceDirectory() 

    /**
     * Method getSourceModifications
     */
    public java.util.List getSourceModifications()
    {
        if ( this.sourceModifications == null )
        {
            this.sourceModifications = new java.util.ArrayList();
        }
        
        return this.sourceModifications;
    } //-- java.util.List getSourceModifications() 

    /**
     * Get 
     *             This element specifies unit tests associated
     * with the project.
     *           
     */
    public UnitTest getUnitTest()
    {
        return this.unitTest;
    } //-- UnitTest getUnitTest() 

    /**
     * Get 
     *             This element specifies a directory containing
     * the unit test
     *             source of the project. The generated build
     * system will
     *             compile these directories when the project is
     * being tested.
     *             The path given is relative to the project
     * descriptor.
     *           
     */
    public String getUnitTestSourceDirectory()
    {
        return this.unitTestSourceDirectory;
    } //-- String getUnitTestSourceDirectory() 

    /**
     * Method removeSourceModification
     * 
     * @param sourceModification
     */
    public void removeSourceModification(SourceModification sourceModification)
    {
        if ( !(sourceModification instanceof SourceModification) )
        {
            throw new ClassCastException( "Build.removeSourceModifications(sourceModification) parameter must be instanceof " + SourceModification.class.getName() );
        }
        getSourceModifications().remove( sourceModification );
    } //-- void removeSourceModification(SourceModification) 

    /**
     * Set     
     *              This element specifies a directory containing
     * Aspect    
     *              sources of the project.  The generated build
     * system will    
     *              compile the Aspects in this directory when the
     * project is    
     *              built if Aspects have been enabled.
     *              The path given is relative to the project
     * descriptor.    
     *            
     * 
     * @param aspectSourceDirectory
     */
    public void setAspectSourceDirectory(String aspectSourceDirectory)
    {
        this.aspectSourceDirectory = aspectSourceDirectory;
    } //-- void setAspectSourceDirectory(String) 

    /**
     * Set     
     *              This element is <strong>deprecated</strong> and
     * should no longer be used.
     *              Initially it was used by the first Cactus
     * plugin. Now
     *              the location of the Cactus test sources is
     * defined
     *              through a plugin property. See the Cactus
     * plugin
     *              <a
     * href="http://jakarta.apache.org/cactus/integration/maven/properties.html">properties</a>
     *              page.
     *             
     * 
     * @param integrationUnitTestSourceDirectory
     */
    public void setIntegrationUnitTestSourceDirectory(String integrationUnitTestSourceDirectory)
    {
        this.integrationUnitTestSourceDirectory = integrationUnitTestSourceDirectory;
    } //-- void setIntegrationUnitTestSourceDirectory(String) 

    /**
     * Set 
     *             An address to which notifications regarding the
     * status of builds
     *             for this project can be sent. This is intended
     * for use by tools
     *             which do unattended builds, for example those
     * providing for
     *             continuous integration.
     *           
     * 
     * @param nagEmailAddress
     */
    public void setNagEmailAddress(String nagEmailAddress)
    {
        this.nagEmailAddress = nagEmailAddress;
    } //-- void setNagEmailAddress(String) 

    /**
     * Set 
     *             This element specifies a directory containing
     * the source
     *             of the project. The generated build system will
     * compile
     *             the source in this directory when the project is
     * built.
     *             The path given is relative to the project
     * descriptor.
     *           
     * 
     * @param sourceDirectory
     */
    public void setSourceDirectory(String sourceDirectory)
    {
        this.sourceDirectory = sourceDirectory;
    } //-- void setSourceDirectory(String) 

    /**
     * Set 
     *             This element describes all of the
     * sourceModifications associated 
     *             with a project. These modifications are used
     *             to exclude or include various source depending
     * on the environment
     *              the build is running in.
     *           
     * 
     * @param sourceModifications
     */
    public void setSourceModifications(java.util.List sourceModifications)
    {
        this.sourceModifications = sourceModifications;
    } //-- void setSourceModifications(java.util.List) 

    /**
     * Set 
     *             This element specifies unit tests associated
     * with the project.
     *           
     * 
     * @param unitTest
     */
    public void setUnitTest(UnitTest unitTest)
    {
        this.unitTest = unitTest;
    } //-- void setUnitTest(UnitTest) 

    /**
     * Set 
     *             This element specifies a directory containing
     * the unit test
     *             source of the project. The generated build
     * system will
     *             compile these directories when the project is
     * being tested.
     *             The path given is relative to the project
     * descriptor.
     *           
     * 
     * @param unitTestSourceDirectory
     */
    public void setUnitTestSourceDirectory(String unitTestSourceDirectory)
    {
        this.unitTestSourceDirectory = unitTestSourceDirectory;
    } //-- void setUnitTestSourceDirectory(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
