/*
 * $Id$
 */

package org.apache.maven.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class BuildBase extends PluginConfiguration 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field defaultGoal
     */
    private String defaultGoal;

    /**
     * Field resources
     */
    private java.util.List resources;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addResource
     * 
     * @param resource
     */
    public void addResource(Resource resource)
    {
        if ( !(resource instanceof Resource) )
        {
            throw new ClassCastException( "BuildBase.addResources(resource) parameter must be instanceof " + Resource.class.getName() );
        }
        getResources().add( resource );
    } //-- void addResource(Resource) 

    /**
     * Get 
     *             The default goal (or phase in Maven 2) to
     * execute when none is specified for the project.
     *           
     */
    public String getDefaultGoal()
    {
        return this.defaultGoal;
    } //-- String getDefaultGoal() 

    /**
     * Method getResources
     */
    public java.util.List getResources()
    {
        if ( this.resources == null )
        {
            this.resources = new java.util.ArrayList();
        }
        
        return this.resources;
    } //-- java.util.List getResources() 

    /**
     * Method removeResource
     * 
     * @param resource
     */
    public void removeResource(Resource resource)
    {
        if ( !(resource instanceof Resource) )
        {
            throw new ClassCastException( "BuildBase.removeResources(resource) parameter must be instanceof " + Resource.class.getName() );
        }
        getResources().remove( resource );
    } //-- void removeResource(Resource) 

    /**
     * Set 
     *             The default goal (or phase in Maven 2) to
     * execute when none is specified for the project.
     *           
     * 
     * @param defaultGoal
     */
    public void setDefaultGoal(String defaultGoal)
    {
        this.defaultGoal = defaultGoal;
    } //-- void setDefaultGoal(String) 

    /**
     * Set 
     *             This element describes all of the classpath
     * resources such as properties files associated with a
     *             project. These resources are often included in
     * the final package.
     *           
     * 
     * @param resources
     */
    public void setResources(java.util.List resources)
    {
        this.resources = resources;
    } //-- void setResources(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
