/*
 * $Id$
 */

package org.apache.maven.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ModelBase implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field dependencies
     */
    private java.util.List dependencies;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addDependency
     * 
     * @param dependency
     */
    public void addDependency(Dependency dependency)
    {
        if ( !(dependency instanceof Dependency) )
        {
            throw new ClassCastException( "ModelBase.addDependencies(dependency) parameter must be instanceof " + Dependency.class.getName() );
        }
        getDependencies().add( dependency );
    } //-- void addDependency(Dependency) 

    /**
     * Method getDependencies
     */
    public java.util.List getDependencies()
    {
        if ( this.dependencies == null )
        {
            this.dependencies = new java.util.ArrayList();
        }
        
        return this.dependencies;
    } //-- java.util.List getDependencies() 

    /**
     * Method removeDependency
     * 
     * @param dependency
     */
    public void removeDependency(Dependency dependency)
    {
        if ( !(dependency instanceof Dependency) )
        {
            throw new ClassCastException( "ModelBase.removeDependencies(dependency) parameter must be instanceof " + Dependency.class.getName() );
        }
        getDependencies().remove( dependency );
    } //-- void removeDependency(Dependency) 

    /**
     * Set 
     *               This element describes all of the dependencies
     * associated with a
     *               project.
     *               These dependencies are used to construct a
     * classpath for your 
     *               project during the build process. They are
     * automatically downloaded from the
     *               repositories defined in this project.
     *               See <a
     * href="http://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html">the
     *               dependency mechanism</a> for more information.
     *           
     * 
     * @param dependencies
     */
    public void setDependencies(java.util.List dependencies)
    {
        this.dependencies = dependencies;
    } //-- void setDependencies(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
