/*
 * $Id$
 */

package org.apache.maven.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         This element describes all of the source modifications
 * associated with a
 *         project. These modifications are used
 *         to exclude or include various source depending on the
 * environment
 *         the build is running in.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class SourceModification extends FileSet 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field className
     */
    private String className;

    /**
     * Field property
     */
    private String property;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             If the class with this name can
     * <strong>not</strong> be
     *             loaded, then the includes and excludes specified
     * below 
     *             will be applied to the contents of the
     * <code>sourceDirectory</code>.
     *           
     */
    public String getClassName()
    {
        return this.className;
    } //-- String getClassName() 

    /**
     * Get 
     *             If the property with this name is
     * <strong>not</strong> set,
     *             then the includes and excludes specified below
     *             will be applied to the contents of the
     * <code>sourceDirectory</code>.
     *           
     */
    public String getProperty()
    {
        return this.property;
    } //-- String getProperty() 

    /**
     * Set 
     *             If the class with this name can
     * <strong>not</strong> be
     *             loaded, then the includes and excludes specified
     * below 
     *             will be applied to the contents of the
     * <code>sourceDirectory</code>.
     *           
     * 
     * @param className
     */
    public void setClassName(String className)
    {
        this.className = className;
    } //-- void setClassName(String) 

    /**
     * Set 
     *             If the property with this name is
     * <strong>not</strong> set,
     *             then the includes and excludes specified below
     *             will be applied to the contents of the
     * <code>sourceDirectory</code>.
     *           
     * 
     * @param property
     */
    public void setProperty(String property)
    {
        this.property = property;
    } //-- void setProperty(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
