/*
 * $Id$
 */

package org.apache.maven.project;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         This element describes each of the previous versions of
 * the
 *         project. Each version is described by a
 * <code>version</code>
 *         element
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Version implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field tag
     */
    private String tag;

    /**
     * Field id
     */
    private String id;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             A unique identifier for a version. This is
     * usually identical to the name.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             The external version number under which this
     * release was distributed. Examples include:
     *             <code>1.0</code>,
     *             <code>1.1-alpha1</code>,
     *             <code>1.2-beta</code>,
     *             <code>1.3.2</code> etc.
     *           
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get 
     *             The name given in the SCM (e.g. CVS) used by the
     * project for the source
     *             code associated with this version of the
     * project.
     *           
     */
    public String getTag()
    {
        return this.tag;
    } //-- String getTag() 

    /**
     * Set 
     *             A unique identifier for a version. This is
     * usually identical to the name.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             The external version number under which this
     * release was distributed. Examples include:
     *             <code>1.0</code>,
     *             <code>1.1-alpha1</code>,
     *             <code>1.2-beta</code>,
     *             <code>1.3.2</code> etc.
     *           
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set 
     *             The name given in the SCM (e.g. CVS) used by the
     * project for the source
     *             code associated with this version of the
     * project.
     *           
     * 
     * @param tag
     */
    public void setTag(String tag)
    {
        this.tag = tag;
    } //-- void setTag(String) 


              public String toString()
              {
                  return getId();
              }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
