/*
 * $Id$
 */

package org.apache.maven.project.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.jar.Manifest;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.*;
import org.apache.maven.project.Branch;
import org.apache.maven.project.Build;
import org.apache.maven.project.BuildBase;
import org.apache.maven.project.Contributor;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Developer;
import org.apache.maven.project.FileSet;
import org.apache.maven.project.License;
import org.apache.maven.project.MailingList;
import org.apache.maven.project.Model;
import org.apache.maven.project.ModelBase;
import org.apache.maven.project.Organization;
import org.apache.maven.project.PackageGroup;
import org.apache.maven.project.PatternSet;
import org.apache.maven.project.PluginConfiguration;
import org.apache.maven.project.PluginContainer;
import org.apache.maven.project.Repository;
import org.apache.maven.project.Resource;
import org.apache.maven.project.SourceModification;
import org.apache.maven.project.UnitTest;
import org.apache.maven.project.Version;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/**
 * Class MavenStaxWriter.
 * 
 * @version $Revision$ $Date$
 */
public class MavenStaxWriter {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field curId
     */
    private int curId;

    /**
     * Field idMap
     */
    private java.util.Map idMap;


      //----------------/
     //- Constructors -/
    //----------------/

    public MavenStaxWriter() {
        idMap = new java.util.HashMap();
    } //-- org.apache.maven.project.io.stax.MavenStaxWriter()


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param model
     */
    public void write(Writer writer, Model model)
        throws java.io.IOException, XMLStreamException
    {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if ( factory.isPropertySupported( "com.ctc.wstx.outputEscapeCr" ) )
        {
            factory.setProperty( "com.ctc.wstx.outputEscapeCr", Boolean.FALSE );
            supportWindowsLineEndings = true;
        }
        if ( factory.isPropertySupported( "org.codehaus.stax2.automaticEmptyElements" ) )
        {
            factory.setProperty( "org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE );
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter( factory.createXMLStreamWriter( writer ) );
        if ( supportWindowsLineEndings )
        {
            serializer.setNewLine( serializer.getLineSeparator() );
        }
        serializer.writeStartDocument( model.getModelEncoding(), "1.0" );
        writeModel( model, "project", serializer );
        serializer.writeEndDocument();
    } //-- void write(Writer, Model) 

    /**
     * Method writeBranch
     * 
     * @param branch
     * @param serializer
     * @param tagName
     */
    private void writeBranch(Branch branch, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( branch != null )
        {
            serializer.writeStartElement( tagName );
            if ( branch.getTag() != null )
            {
                serializer.writeStartElement( "tag" );
                serializer.writeCharacters( branch.getTag() );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeBranch(Branch, String, XMLStreamWriter) 

    /**
     * Method writeBuild
     * 
     * @param build
     * @param serializer
     * @param tagName
     */
    private void writeBuild(Build build, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( build != null )
        {
            serializer.writeStartElement( tagName );
            if ( build.getNagEmailAddress() != null )
            {
                serializer.writeStartElement( "nagEmailAddress" );
                serializer.writeCharacters( build.getNagEmailAddress() );
                serializer.writeEndElement();
            }
            if ( build.getSourceDirectory() != null )
            {
                serializer.writeStartElement( "sourceDirectory" );
                serializer.writeCharacters( build.getSourceDirectory() );
                serializer.writeEndElement();
            }
            if ( build.getUnitTestSourceDirectory() != null )
            {
                serializer.writeStartElement( "unitTestSourceDirectory" );
                serializer.writeCharacters( build.getUnitTestSourceDirectory() );
                serializer.writeEndElement();
            }
            if ( build.getAspectSourceDirectory() != null )
            {
                serializer.writeStartElement( "aspectSourceDirectory" );
                serializer.writeCharacters( build.getAspectSourceDirectory() );
                serializer.writeEndElement();
            }
            if ( build.getIntegrationUnitTestSourceDirectory() != null )
            {
                serializer.writeStartElement( "integrationUnitTestSourceDirectory" );
                serializer.writeCharacters( build.getIntegrationUnitTestSourceDirectory() );
                serializer.writeEndElement();
            }
            if ( build.getSourceModifications() != null && build.getSourceModifications().size() > 0 )
            {
                serializer.writeStartElement( "sourceModifications" );
                for ( Iterator iter = build.getSourceModifications().iterator(); iter.hasNext(); )
                {
                    SourceModification o = (SourceModification) iter.next();
                    writeSourceModification( o, "sourceModification", serializer );
                }
                serializer.writeEndElement();
            }
            if ( build.getUnitTest() != null )
            {
                writeUnitTest( (UnitTest) build.getUnitTest(), "unitTest", serializer );
            }
            if ( build.getDefaultGoal() != null )
            {
                serializer.writeStartElement( "defaultGoal" );
                serializer.writeCharacters( build.getDefaultGoal() );
                serializer.writeEndElement();
            }
            if ( build.getResources() != null && build.getResources().size() > 0 )
            {
                serializer.writeStartElement( "resources" );
                for ( Iterator iter = build.getResources().iterator(); iter.hasNext(); )
                {
                    Resource o = (Resource) iter.next();
                    writeResource( o, "resource", serializer );
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeBuild(Build, String, XMLStreamWriter) 

    /**
     * Method writeBuildBase
     * 
     * @param buildBase
     * @param serializer
     * @param tagName
     */
    private void writeBuildBase(BuildBase buildBase, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( buildBase != null )
        {
            serializer.writeStartElement( tagName );
            if ( buildBase.getDefaultGoal() != null )
            {
                serializer.writeStartElement( "defaultGoal" );
                serializer.writeCharacters( buildBase.getDefaultGoal() );
                serializer.writeEndElement();
            }
            if ( buildBase.getResources() != null && buildBase.getResources().size() > 0 )
            {
                serializer.writeStartElement( "resources" );
                for ( Iterator iter = buildBase.getResources().iterator(); iter.hasNext(); )
                {
                    Resource o = (Resource) iter.next();
                    writeResource( o, "resource", serializer );
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeBuildBase(BuildBase, String, XMLStreamWriter) 

    /**
     * Method writeContributor
     * 
     * @param contributor
     * @param serializer
     * @param tagName
     */
    private void writeContributor(Contributor contributor, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( contributor != null )
        {
            serializer.writeStartElement( tagName );
            if ( contributor.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( contributor.getName() );
                serializer.writeEndElement();
            }
            if ( contributor.getEmail() != null )
            {
                serializer.writeStartElement( "email" );
                serializer.writeCharacters( contributor.getEmail() );
                serializer.writeEndElement();
            }
            if ( contributor.getUrl() != null )
            {
                serializer.writeStartElement( "url" );
                serializer.writeCharacters( contributor.getUrl() );
                serializer.writeEndElement();
            }
            if ( contributor.getOrganization() != null )
            {
                serializer.writeStartElement( "organization" );
                serializer.writeCharacters( contributor.getOrganization() );
                serializer.writeEndElement();
            }
            if ( contributor.getOrganizationUrl() != null )
            {
                serializer.writeStartElement( "organizationUrl" );
                serializer.writeCharacters( contributor.getOrganizationUrl() );
                serializer.writeEndElement();
            }
            if ( contributor.getRoles() != null && contributor.getRoles().size() > 0 )
            {
                serializer.writeStartElement( "roles" );
                for ( Iterator iter = contributor.getRoles().iterator(); iter.hasNext(); )
                {
                    String role = (String) iter.next();
                    serializer.writeStartElement( "role" );
                    serializer.writeCharacters( role );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( contributor.getTimezone() != null )
            {
                serializer.writeStartElement( "timezone" );
                serializer.writeCharacters( contributor.getTimezone() );
                serializer.writeEndElement();
            }
            if ( contributor.getProperties() != null && contributor.getProperties().size() > 0 )
            {
                serializer.writeStartElement( "properties" );
                for ( Iterator iter = contributor.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) contributor.getProperties().get( key );
                    serializer.writeStartElement( "" + key + "" );
                    serializer.writeCharacters( value );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeContributor(Contributor, String, XMLStreamWriter) 

    /**
     * Method writeDependency
     * 
     * @param dependency
     * @param serializer
     * @param tagName
     */
    private void writeDependency(Dependency dependency, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( dependency != null )
        {
            serializer.writeStartElement( tagName );
            if ( dependency.getId() != null )
            {
                serializer.writeStartElement( "id" );
                serializer.writeCharacters( dependency.getId() );
                serializer.writeEndElement();
            }
            if ( dependency.getGroupId() != null )
            {
                serializer.writeStartElement( "groupId" );
                serializer.writeCharacters( dependency.getGroupId() );
                serializer.writeEndElement();
            }
            if ( dependency.getArtifactId() != null )
            {
                serializer.writeStartElement( "artifactId" );
                serializer.writeCharacters( dependency.getArtifactId() );
                serializer.writeEndElement();
            }
            if ( dependency.getVersion() != null )
            {
                serializer.writeStartElement( "version" );
                serializer.writeCharacters( dependency.getVersion() );
                serializer.writeEndElement();
            }
            if ( dependency.getUrl() != null )
            {
                serializer.writeStartElement( "url" );
                serializer.writeCharacters( dependency.getUrl() );
                serializer.writeEndElement();
            }
            if ( dependency.getJar() != null )
            {
                serializer.writeStartElement( "jar" );
                serializer.writeCharacters( dependency.getJar() );
                serializer.writeEndElement();
            }
            if ( dependency.getType() != null && !dependency.getType().equals( "jar" ) )
            {
                serializer.writeStartElement( "type" );
                serializer.writeCharacters( dependency.getType() );
                serializer.writeEndElement();
            }
            if ( dependency.getProperties() != null && dependency.getProperties().size() > 0 )
            {
                serializer.writeStartElement( "properties" );
                for ( Iterator iter = dependency.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) dependency.getProperties().get( key );
                    serializer.writeStartElement( "" + key + "" );
                    serializer.writeCharacters( value );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeDependency(Dependency, String, XMLStreamWriter) 

    /**
     * Method writeDeveloper
     * 
     * @param developer
     * @param serializer
     * @param tagName
     */
    private void writeDeveloper(Developer developer, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( developer != null )
        {
            serializer.writeStartElement( tagName );
            if ( developer.getId() != null )
            {
                serializer.writeStartElement( "id" );
                serializer.writeCharacters( developer.getId() );
                serializer.writeEndElement();
            }
            if ( developer.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( developer.getName() );
                serializer.writeEndElement();
            }
            if ( developer.getEmail() != null )
            {
                serializer.writeStartElement( "email" );
                serializer.writeCharacters( developer.getEmail() );
                serializer.writeEndElement();
            }
            if ( developer.getUrl() != null )
            {
                serializer.writeStartElement( "url" );
                serializer.writeCharacters( developer.getUrl() );
                serializer.writeEndElement();
            }
            if ( developer.getOrganization() != null )
            {
                serializer.writeStartElement( "organization" );
                serializer.writeCharacters( developer.getOrganization() );
                serializer.writeEndElement();
            }
            if ( developer.getOrganizationUrl() != null )
            {
                serializer.writeStartElement( "organizationUrl" );
                serializer.writeCharacters( developer.getOrganizationUrl() );
                serializer.writeEndElement();
            }
            if ( developer.getRoles() != null && developer.getRoles().size() > 0 )
            {
                serializer.writeStartElement( "roles" );
                for ( Iterator iter = developer.getRoles().iterator(); iter.hasNext(); )
                {
                    String role = (String) iter.next();
                    serializer.writeStartElement( "role" );
                    serializer.writeCharacters( role );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( developer.getTimezone() != null )
            {
                serializer.writeStartElement( "timezone" );
                serializer.writeCharacters( developer.getTimezone() );
                serializer.writeEndElement();
            }
            if ( developer.getProperties() != null && developer.getProperties().size() > 0 )
            {
                serializer.writeStartElement( "properties" );
                for ( Iterator iter = developer.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) developer.getProperties().get( key );
                    serializer.writeStartElement( "" + key + "" );
                    serializer.writeCharacters( value );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeDeveloper(Developer, String, XMLStreamWriter) 

    /**
     * Method writeDom
     * 
     * @param dom
     * @param serializer
     */
    public void writeDom(Xpp3Dom dom, XMLStreamWriter serializer)
        throws XMLStreamException
    {
        serializer.writeStartElement( dom.getName() );
        String[] attributeNames = dom.getAttributeNames();
        for ( int i = 0; i < attributeNames.length; i++ )
        {
            String attributeName = attributeNames[i];
            serializer.writeAttribute( attributeName, dom.getAttribute( attributeName ) );
        }
        Xpp3Dom[] children = dom.getChildren();
        for ( int i = 0; i < children.length; i++ )
        {
            writeDom( children[i], serializer );
        }
        String value = dom.getValue();
        if ( value != null )
        {
            serializer.writeCharacters( value );
        }
        serializer.writeEndElement();
    } //-- void writeDom(Xpp3Dom, XMLStreamWriter) 

    /**
     * Method writeFileSet
     * 
     * @param fileSet
     * @param serializer
     * @param tagName
     */
    private void writeFileSet(FileSet fileSet, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( fileSet != null )
        {
            serializer.writeStartElement( tagName );
            if ( fileSet.getDirectory() != null )
            {
                serializer.writeStartElement( "directory" );
                serializer.writeCharacters( fileSet.getDirectory() );
                serializer.writeEndElement();
            }
            if ( fileSet.getIncludes() != null && fileSet.getIncludes().size() > 0 )
            {
                serializer.writeStartElement( "includes" );
                for ( Iterator iter = fileSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.writeStartElement( "include" );
                    serializer.writeCharacters( include );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( fileSet.getExcludes() != null && fileSet.getExcludes().size() > 0 )
            {
                serializer.writeStartElement( "excludes" );
                for ( Iterator iter = fileSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.writeStartElement( "exclude" );
                    serializer.writeCharacters( exclude );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeFileSet(FileSet, String, XMLStreamWriter) 

    /**
     * Method writeLicense
     * 
     * @param license
     * @param serializer
     * @param tagName
     */
    private void writeLicense(License license, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( license != null )
        {
            serializer.writeStartElement( tagName );
            if ( license.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( license.getName() );
                serializer.writeEndElement();
            }
            if ( license.getUrl() != null )
            {
                serializer.writeStartElement( "url" );
                serializer.writeCharacters( license.getUrl() );
                serializer.writeEndElement();
            }
            if ( license.getDistribution() != null )
            {
                serializer.writeStartElement( "distribution" );
                serializer.writeCharacters( license.getDistribution() );
                serializer.writeEndElement();
            }
            if ( license.getComments() != null )
            {
                serializer.writeStartElement( "comments" );
                serializer.writeCharacters( license.getComments() );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeLicense(License, String, XMLStreamWriter) 

    /**
     * Method writeMailingList
     * 
     * @param mailingList
     * @param serializer
     * @param tagName
     */
    private void writeMailingList(MailingList mailingList, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( mailingList != null )
        {
            serializer.writeStartElement( tagName );
            if ( mailingList.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( mailingList.getName() );
                serializer.writeEndElement();
            }
            if ( mailingList.getSubscribe() != null )
            {
                serializer.writeStartElement( "subscribe" );
                serializer.writeCharacters( mailingList.getSubscribe() );
                serializer.writeEndElement();
            }
            if ( mailingList.getUnsubscribe() != null )
            {
                serializer.writeStartElement( "unsubscribe" );
                serializer.writeCharacters( mailingList.getUnsubscribe() );
                serializer.writeEndElement();
            }
            if ( mailingList.getPost() != null )
            {
                serializer.writeStartElement( "post" );
                serializer.writeCharacters( mailingList.getPost() );
                serializer.writeEndElement();
            }
            if ( mailingList.getArchive() != null )
            {
                serializer.writeStartElement( "archive" );
                serializer.writeCharacters( mailingList.getArchive() );
                serializer.writeEndElement();
            }
            if ( mailingList.getOtherArchives() != null && mailingList.getOtherArchives().size() > 0 )
            {
                serializer.writeStartElement( "otherArchives" );
                for ( Iterator iter = mailingList.getOtherArchives().iterator(); iter.hasNext(); )
                {
                    String otherArchive = (String) iter.next();
                    serializer.writeStartElement( "otherArchive" );
                    serializer.writeCharacters( otherArchive );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeMailingList(MailingList, String, XMLStreamWriter) 

    /**
     * Method writeModel
     * 
     * @param model
     * @param serializer
     * @param tagName
     */
    private void writeModel(Model model, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( model != null )
        {
            serializer.writeStartElement( tagName );
            if ( model.getExtend() != null )
            {
                serializer.writeStartElement( "extend" );
                serializer.writeCharacters( model.getExtend() );
                serializer.writeEndElement();
            }
            if ( model.getPomVersion() != null )
            {
                serializer.writeStartElement( "pomVersion" );
                serializer.writeCharacters( model.getPomVersion() );
                serializer.writeEndElement();
            }
            if ( model.getGroupId() != null )
            {
                serializer.writeStartElement( "groupId" );
                serializer.writeCharacters( model.getGroupId() );
                serializer.writeEndElement();
            }
            if ( model.getArtifactId() != null )
            {
                serializer.writeStartElement( "artifactId" );
                serializer.writeCharacters( model.getArtifactId() );
                serializer.writeEndElement();
            }
            if ( model.getId() != null )
            {
                serializer.writeStartElement( "id" );
                serializer.writeCharacters( model.getId() );
                serializer.writeEndElement();
            }
            if ( model.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( model.getName() );
                serializer.writeEndElement();
            }
            if ( model.getCurrentVersion() != null )
            {
                serializer.writeStartElement( "currentVersion" );
                serializer.writeCharacters( model.getCurrentVersion() );
                serializer.writeEndElement();
            }
            if ( model.getShortDescription() != null )
            {
                serializer.writeStartElement( "shortDescription" );
                serializer.writeCharacters( model.getShortDescription() );
                serializer.writeEndElement();
            }
            if ( model.getDescription() != null )
            {
                serializer.writeStartElement( "description" );
                serializer.writeCharacters( model.getDescription() );
                serializer.writeEndElement();
            }
            if ( model.getUrl() != null )
            {
                serializer.writeStartElement( "url" );
                serializer.writeCharacters( model.getUrl() );
                serializer.writeEndElement();
            }
            if ( model.getLogo() != null )
            {
                serializer.writeStartElement( "logo" );
                serializer.writeCharacters( model.getLogo() );
                serializer.writeEndElement();
            }
            if ( model.getIssueTrackingUrl() != null )
            {
                serializer.writeStartElement( "issueTrackingUrl" );
                serializer.writeCharacters( model.getIssueTrackingUrl() );
                serializer.writeEndElement();
            }
            if ( model.getInceptionYear() != null )
            {
                serializer.writeStartElement( "inceptionYear" );
                serializer.writeCharacters( model.getInceptionYear() );
                serializer.writeEndElement();
            }
            if ( model.getGumpRepositoryId() != null )
            {
                serializer.writeStartElement( "gumpRepositoryId" );
                serializer.writeCharacters( model.getGumpRepositoryId() );
                serializer.writeEndElement();
            }
            if ( model.getSiteAddress() != null )
            {
                serializer.writeStartElement( "siteAddress" );
                serializer.writeCharacters( model.getSiteAddress() );
                serializer.writeEndElement();
            }
            if ( model.getSiteDirectory() != null )
            {
                serializer.writeStartElement( "siteDirectory" );
                serializer.writeCharacters( model.getSiteDirectory() );
                serializer.writeEndElement();
            }
            if ( model.getDistributionSite() != null )
            {
                serializer.writeStartElement( "distributionSite" );
                serializer.writeCharacters( model.getDistributionSite() );
                serializer.writeEndElement();
            }
            if ( model.getDistributionDirectory() != null )
            {
                serializer.writeStartElement( "distributionDirectory" );
                serializer.writeCharacters( model.getDistributionDirectory() );
                serializer.writeEndElement();
            }
            if ( model.getMailingLists() != null && model.getMailingLists().size() > 0 )
            {
                serializer.writeStartElement( "mailingLists" );
                for ( Iterator iter = model.getMailingLists().iterator(); iter.hasNext(); )
                {
                    MailingList o = (MailingList) iter.next();
                    writeMailingList( o, "mailingList", serializer );
                }
                serializer.writeEndElement();
            }
            if ( model.getDevelopers() != null && model.getDevelopers().size() > 0 )
            {
                serializer.writeStartElement( "developers" );
                for ( Iterator iter = model.getDevelopers().iterator(); iter.hasNext(); )
                {
                    Developer o = (Developer) iter.next();
                    writeDeveloper( o, "developer", serializer );
                }
                serializer.writeEndElement();
            }
            if ( model.getContributors() != null && model.getContributors().size() > 0 )
            {
                serializer.writeStartElement( "contributors" );
                for ( Iterator iter = model.getContributors().iterator(); iter.hasNext(); )
                {
                    Contributor o = (Contributor) iter.next();
                    writeContributor( o, "contributor", serializer );
                }
                serializer.writeEndElement();
            }
            if ( model.getLicenses() != null && model.getLicenses().size() > 0 )
            {
                serializer.writeStartElement( "licenses" );
                for ( Iterator iter = model.getLicenses().iterator(); iter.hasNext(); )
                {
                    License o = (License) iter.next();
                    writeLicense( o, "license", serializer );
                }
                serializer.writeEndElement();
            }
            if ( model.getVersions() != null && model.getVersions().size() > 0 )
            {
                serializer.writeStartElement( "versions" );
                for ( Iterator iter = model.getVersions().iterator(); iter.hasNext(); )
                {
                    Version o = (Version) iter.next();
                    writeVersion( o, "version", serializer );
                }
                serializer.writeEndElement();
            }
            if ( model.getBranches() != null && model.getBranches().size() > 0 )
            {
                serializer.writeStartElement( "branches" );
                for ( Iterator iter = model.getBranches().iterator(); iter.hasNext(); )
                {
                    Branch o = (Branch) iter.next();
                    writeBranch( o, "branch", serializer );
                }
                serializer.writeEndElement();
            }
            if ( model.getPackageGroups() != null && model.getPackageGroups().size() > 0 )
            {
                serializer.writeStartElement( "packageGroups" );
                for ( Iterator iter = model.getPackageGroups().iterator(); iter.hasNext(); )
                {
                    PackageGroup o = (PackageGroup) iter.next();
                    writePackageGroup( o, "packageGroup", serializer );
                }
                serializer.writeEndElement();
            }
            if ( model.getReports() != null && model.getReports().size() > 0 )
            {
                serializer.writeStartElement( "reports" );
                for ( Iterator iter = model.getReports().iterator(); iter.hasNext(); )
                {
                    String report = (String) iter.next();
                    serializer.writeStartElement( "report" );
                    serializer.writeCharacters( report );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( model.getRepository() != null )
            {
                writeRepository( (Repository) model.getRepository(), "repository", serializer );
            }
            if ( model.getOrganization() != null )
            {
                writeOrganization( (Organization) model.getOrganization(), "organization", serializer );
            }
            if ( model.getProperties() != null && model.getProperties().size() > 0 )
            {
                serializer.writeStartElement( "properties" );
                for ( Iterator iter = model.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String value = (String) model.getProperties().get( key );
                    serializer.writeStartElement( "" + key + "" );
                    serializer.writeCharacters( value );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( model.getPackageName() != null )
            {
                serializer.writeStartElement( "package" );
                serializer.writeCharacters( model.getPackageName() );
                serializer.writeEndElement();
            }
            if ( model.getBuild() != null )
            {
                writeBuild( (Build) model.getBuild(), "build", serializer );
            }
            if ( model.getDependencies() != null && model.getDependencies().size() > 0 )
            {
                serializer.writeStartElement( "dependencies" );
                for ( Iterator iter = model.getDependencies().iterator(); iter.hasNext(); )
                {
                    Dependency o = (Dependency) iter.next();
                    writeDependency( o, "dependency", serializer );
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeModel(Model, String, XMLStreamWriter) 

    /**
     * Method writeModelBase
     * 
     * @param modelBase
     * @param serializer
     * @param tagName
     */
    private void writeModelBase(ModelBase modelBase, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( modelBase != null )
        {
            serializer.writeStartElement( tagName );
            if ( modelBase.getDependencies() != null && modelBase.getDependencies().size() > 0 )
            {
                serializer.writeStartElement( "dependencies" );
                for ( Iterator iter = modelBase.getDependencies().iterator(); iter.hasNext(); )
                {
                    Dependency o = (Dependency) iter.next();
                    writeDependency( o, "dependency", serializer );
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeModelBase(ModelBase, String, XMLStreamWriter) 

    /**
     * Method writeOrganization
     * 
     * @param organization
     * @param serializer
     * @param tagName
     */
    private void writeOrganization(Organization organization, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( organization != null )
        {
            serializer.writeStartElement( tagName );
            if ( organization.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( organization.getName() );
                serializer.writeEndElement();
            }
            if ( organization.getUrl() != null )
            {
                serializer.writeStartElement( "url" );
                serializer.writeCharacters( organization.getUrl() );
                serializer.writeEndElement();
            }
            if ( organization.getLogo() != null )
            {
                serializer.writeStartElement( "logo" );
                serializer.writeCharacters( organization.getLogo() );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeOrganization(Organization, String, XMLStreamWriter) 

    /**
     * Method writePackageGroup
     * 
     * @param packageGroup
     * @param serializer
     * @param tagName
     */
    private void writePackageGroup(PackageGroup packageGroup, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( packageGroup != null )
        {
            serializer.writeStartElement( tagName );
            if ( packageGroup.getTitle() != null )
            {
                serializer.writeStartElement( "title" );
                serializer.writeCharacters( packageGroup.getTitle() );
                serializer.writeEndElement();
            }
            if ( packageGroup.getPackages() != null )
            {
                serializer.writeStartElement( "packages" );
                serializer.writeCharacters( packageGroup.getPackages() );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writePackageGroup(PackageGroup, String, XMLStreamWriter) 

    /**
     * Method writePatternSet
     * 
     * @param patternSet
     * @param serializer
     * @param tagName
     */
    private void writePatternSet(PatternSet patternSet, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( patternSet != null )
        {
            serializer.writeStartElement( tagName );
            if ( patternSet.getIncludes() != null && patternSet.getIncludes().size() > 0 )
            {
                serializer.writeStartElement( "includes" );
                for ( Iterator iter = patternSet.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.writeStartElement( "include" );
                    serializer.writeCharacters( include );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( patternSet.getExcludes() != null && patternSet.getExcludes().size() > 0 )
            {
                serializer.writeStartElement( "excludes" );
                for ( Iterator iter = patternSet.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.writeStartElement( "exclude" );
                    serializer.writeCharacters( exclude );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writePatternSet(PatternSet, String, XMLStreamWriter) 

    /**
     * Method writePluginConfiguration
     * 
     * @param pluginConfiguration
     * @param serializer
     * @param tagName
     */
    private void writePluginConfiguration(PluginConfiguration pluginConfiguration, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( pluginConfiguration != null )
        {
            serializer.writeStartElement( tagName );
            serializer.writeEndElement();
        }
    } //-- void writePluginConfiguration(PluginConfiguration, String, XMLStreamWriter) 

    /**
     * Method writePluginContainer
     * 
     * @param pluginContainer
     * @param serializer
     * @param tagName
     */
    private void writePluginContainer(PluginContainer pluginContainer, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( pluginContainer != null )
        {
            serializer.writeStartElement( tagName );
            serializer.writeEndElement();
        }
    } //-- void writePluginContainer(PluginContainer, String, XMLStreamWriter) 

    /**
     * Method writeRepository
     * 
     * @param repository
     * @param serializer
     * @param tagName
     */
    private void writeRepository(Repository repository, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( repository != null )
        {
            serializer.writeStartElement( tagName );
            if ( repository.getConnection() != null )
            {
                serializer.writeStartElement( "connection" );
                serializer.writeCharacters( repository.getConnection() );
                serializer.writeEndElement();
            }
            if ( repository.getDeveloperConnection() != null )
            {
                serializer.writeStartElement( "developerConnection" );
                serializer.writeCharacters( repository.getDeveloperConnection() );
                serializer.writeEndElement();
            }
            if ( repository.getUrl() != null )
            {
                serializer.writeStartElement( "url" );
                serializer.writeCharacters( repository.getUrl() );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeRepository(Repository, String, XMLStreamWriter) 

    /**
     * Method writeResource
     * 
     * @param resource
     * @param serializer
     * @param tagName
     */
    private void writeResource(Resource resource, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( resource != null )
        {
            serializer.writeStartElement( tagName );
            if ( resource.getTargetPath() != null )
            {
                serializer.writeStartElement( "targetPath" );
                serializer.writeCharacters( resource.getTargetPath() );
                serializer.writeEndElement();
            }
            if ( resource.isFiltering() != false )
            {
                serializer.writeStartElement( "filtering" );
                serializer.writeCharacters( String.valueOf( resource.isFiltering() ) );
                serializer.writeEndElement();
            }
            if ( resource.getDirectory() != null )
            {
                serializer.writeStartElement( "directory" );
                serializer.writeCharacters( resource.getDirectory() );
                serializer.writeEndElement();
            }
            if ( resource.getIncludes() != null && resource.getIncludes().size() > 0 )
            {
                serializer.writeStartElement( "includes" );
                for ( Iterator iter = resource.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.writeStartElement( "include" );
                    serializer.writeCharacters( include );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( resource.getExcludes() != null && resource.getExcludes().size() > 0 )
            {
                serializer.writeStartElement( "excludes" );
                for ( Iterator iter = resource.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.writeStartElement( "exclude" );
                    serializer.writeCharacters( exclude );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeResource(Resource, String, XMLStreamWriter) 

    /**
     * Method writeSourceModification
     * 
     * @param sourceModification
     * @param serializer
     * @param tagName
     */
    private void writeSourceModification(SourceModification sourceModification, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( sourceModification != null )
        {
            serializer.writeStartElement( tagName );
            if ( sourceModification.getClassName() != null )
            {
                serializer.writeStartElement( "className" );
                serializer.writeCharacters( sourceModification.getClassName() );
                serializer.writeEndElement();
            }
            if ( sourceModification.getProperty() != null )
            {
                serializer.writeStartElement( "property" );
                serializer.writeCharacters( sourceModification.getProperty() );
                serializer.writeEndElement();
            }
            if ( sourceModification.getDirectory() != null )
            {
                serializer.writeStartElement( "directory" );
                serializer.writeCharacters( sourceModification.getDirectory() );
                serializer.writeEndElement();
            }
            if ( sourceModification.getIncludes() != null && sourceModification.getIncludes().size() > 0 )
            {
                serializer.writeStartElement( "includes" );
                for ( Iterator iter = sourceModification.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.writeStartElement( "include" );
                    serializer.writeCharacters( include );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( sourceModification.getExcludes() != null && sourceModification.getExcludes().size() > 0 )
            {
                serializer.writeStartElement( "excludes" );
                for ( Iterator iter = sourceModification.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.writeStartElement( "exclude" );
                    serializer.writeCharacters( exclude );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeSourceModification(SourceModification, String, XMLStreamWriter) 

    /**
     * Method writeUnitTest
     * 
     * @param unitTest
     * @param serializer
     * @param tagName
     */
    private void writeUnitTest(UnitTest unitTest, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( unitTest != null )
        {
            serializer.writeStartElement( tagName );
            if ( unitTest.getResources() != null && unitTest.getResources().size() > 0 )
            {
                serializer.writeStartElement( "resources" );
                for ( Iterator iter = unitTest.getResources().iterator(); iter.hasNext(); )
                {
                    Resource o = (Resource) iter.next();
                    writeResource( o, "resource", serializer );
                }
                serializer.writeEndElement();
            }
            if ( unitTest.getIncludes() != null && unitTest.getIncludes().size() > 0 )
            {
                serializer.writeStartElement( "includes" );
                for ( Iterator iter = unitTest.getIncludes().iterator(); iter.hasNext(); )
                {
                    String include = (String) iter.next();
                    serializer.writeStartElement( "include" );
                    serializer.writeCharacters( include );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            if ( unitTest.getExcludes() != null && unitTest.getExcludes().size() > 0 )
            {
                serializer.writeStartElement( "excludes" );
                for ( Iterator iter = unitTest.getExcludes().iterator(); iter.hasNext(); )
                {
                    String exclude = (String) iter.next();
                    serializer.writeStartElement( "exclude" );
                    serializer.writeCharacters( exclude );
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeUnitTest(UnitTest, String, XMLStreamWriter) 

    /**
     * Method writeVersion
     * 
     * @param version
     * @param serializer
     * @param tagName
     */
    private void writeVersion(Version version, String tagName, XMLStreamWriter serializer)
        throws java.io.IOException, XMLStreamException
    {
        if ( version != null )
        {
            serializer.writeStartElement( tagName );
            if ( version.getName() != null )
            {
                serializer.writeStartElement( "name" );
                serializer.writeCharacters( version.getName() );
                serializer.writeEndElement();
            }
            if ( version.getTag() != null )
            {
                serializer.writeStartElement( "tag" );
                serializer.writeCharacters( version.getTag() );
                serializer.writeEndElement();
            }
            if ( version.getId() != null )
            {
                serializer.writeStartElement( "id" );
                serializer.writeCharacters( version.getId() );
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    } //-- void writeVersion(Version, String, XMLStreamWriter) 


}
