/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class PluginToTags {
    private String pluginScript;
    private String xdoc;

    public String getXdoc() {
        return this.xdoc;
    }

    public void setXdoc(String outputFile) {
        this.xdoc = outputFile;
    }

    public String getPluginScript() {
        return this.pluginScript;
    }

    public void setPluginScript(String pluginScript) {
        this.pluginScript = pluginScript;
    }

    public void transform() throws JDOMException, IOException {
        File output = new File(this.getXdoc());
        BufferedWriter bw = new BufferedWriter(new FileWriter(output));
        bw.write("<document>\n");
        bw.write("  <properties>\n");
        bw.write("    <title>Plugin tags</title>\n");
        bw.write("  </properties>\n");
        bw.write("  <body>\n");
        List taglibs = this.getTaglibs();
        this.writeOverview(bw, taglibs);
        this.writeTaglibs(bw, taglibs);
        bw.write("  </body>\n");
        bw.write("</document>\n");
        bw.close();
    }

    private void writeTaglibs(BufferedWriter bw, List taglibs) throws IOException {
        Iterator taglibIter = taglibs.iterator();
        while (taglibIter.hasNext()) {
            Map taglib = (Map)taglibIter.next();
            bw.write("    <section name='" + taglib.get("uri") + " Tag Library'>\n");
            List tagNames = (List)taglib.get("tagNames");
            Iterator tagIter = tagNames.iterator();
            while (tagIter.hasNext()) {
                String name = (String)tagIter.next();
                bw.write("      <subsection name='" + name + " Tag'>\n");
                bw.write("        <p>No description</p>\n");
                bw.write("        <table>\n");
                bw.write("          <tr><th>Attribute</th><th>Optional?</th><th>Description</th></tr>\n");
                bw.write("        </table>\n");
                bw.write("      </subsection>\n");
            }
            bw.write("    </section>\n");
        }
    }

    private void writeOverview(BufferedWriter bw, List taglibs) throws IOException {
        bw.write("    <section name='Overview'>\n");
        bw.write("      <p>The following tag libraries and tags are provided by this plugin.</p>\n");
        bw.write("      <ol>\n");
        Iterator taglibIter = taglibs.iterator();
        while (taglibIter.hasNext()) {
            Map taglib = (Map)taglibIter.next();
            String title = taglib.get("uri") + " Tag Library";
            String linkStart = "<a href='#" + StringUtils.replace((String)title, (String)" ", (String)"_") + "'>";
            bw.write("        <li>" + linkStart + taglib.get("uri") + "</a>\n");
            bw.write("          <ol>\n");
            List tagNames = (List)taglib.get("tagNames");
            Iterator tagIter = tagNames.iterator();
            while (tagIter.hasNext()) {
                String name = (String)tagIter.next();
                bw.write("            <li><a href='#" + name + "_Tag'>" + name + "</a></li>\n");
            }
            bw.write("          </ol>\n");
            bw.write("        </li>\n");
        }
        bw.write("      </ol>\n");
        bw.write("    </section>\n");
    }

    public List getTaglibs() throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(new File(this.getPluginScript()));
        XPath xpath = XPath.newInstance((String)"/project/define:taglib");
        List taglibElements = xpath.selectNodes((Object)doc);
        LinkedList taglibs = new LinkedList();
        Iterator iter = taglibElements.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            HashMap<String, Object> taglib = new HashMap<String, Object>();
            taglib.put("uri", element.getAttributeValue("uri"));
            taglib.put("tagNames", new LinkedList());
            XPath tagsXp = XPath.newInstance((String)"define:tag|define:jellybean");
            List tagsElements = tagsXp.selectNodes((Object)element);
            Iterator tagsIter = tagsElements.iterator();
            while (tagsIter.hasNext()) {
                Element tagsElement = (Element)tagsIter.next();
                ((List)taglib.get("tagNames")).add(tagsElement.getAttributeValue("name"));
            }
            taglibs.add(taglib);
        }
        return taglibs;
    }
}

