/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import com.sun.msv.verifier.jarv.TheFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.XPathLocationTracker;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class JaxpMsvBean {
    private String schema;
    private String file;
    private Log log = LogFactory.getLog((Class)(class$org$apache$maven$JaxpMsvBean == null ? (class$org$apache$maven$JaxpMsvBean = JaxpMsvBean.class$("org.apache.maven.JaxpMsvBean")) : class$org$apache$maven$JaxpMsvBean));
    private static final String EMPTY = "";
    private static final ByteArrayInputStream EMPTY_STREAM = new ByteArrayInputStream("".getBytes());
    private static final int MSV_WARNING = 0;
    private static final int MSV_ERROR = 1;
    private static final int MSV_FATAL_ERROR = 2;
    private boolean isValid = true;
    private boolean validNamespace = true;
    private XPathLocationTracker tracker;
    static /* synthetic */ Class class$org$apache$maven$JaxpMsvBean;

    public void validate() throws Exception {
        TheFactoryImpl verifierFactory = new TheFactoryImpl();
        Verifier verifier = verifierFactory.newVerifier(new File(this.schema));
        verifier.setErrorHandler((ErrorHandler)new ErrorHandlerImpl());
        VerifierHandler handler = verifier.getVerifierHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        XMLReader reader = factory.newSAXParser().getXMLReader();
        this.tracker = new XPathLocationTracker();
        this.tracker.setParent(reader);
        this.tracker.setContentHandler((ContentHandler)handler);
        this.tracker.setEntityResolver(new EntityResolverImpl());
        this.tracker.parse(new InputSource(new FileInputStream(this.file)));
        this.endMessage();
    }

    public void setSchema(String newSchema) {
        this.schema = newSchema;
    }

    public void setFile(String newFile) {
        this.file = newFile;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getFile() {
        return this.file;
    }

    private void endMessage() {
        if (this.isValid) {
            this.log.info((Object)(this.file + " verified: OK"));
        } else {
            this.log.info((Object)(this.file + " is NOT valid!"));
        }
    }

    private void errorMessage(SAXParseException e, int type) {
        File xmlFile = new File(this.file);
        if (type == 1) {
            if (this.validNamespace) {
                this.log.error((Object)("    ERROR on line " + e.getLineNumber() + " of file " + xmlFile.getName() + ","));
                this.log.error((Object)("    XPath location " + this.tracker.getXPath() + ":"));
                this.log.error((Object)("    " + e.getMessage()));
            }
        } else if (type == 2) {
            this.log.error((Object)("    Non-recoverable parsing error on line " + e.getLineNumber() + " of file " + xmlFile.getName() + ","));
            this.log.error((Object)("    XPath location " + this.tracker.getXPath() + ":"));
            this.log.error((Object)("    " + e.getMessage()));
        } else if (type == 0) {
            this.log.warn((Object)("    WARNING on line " + e.getLineNumber() + " of file " + xmlFile.getName() + ","));
            this.log.warn((Object)("    XPath location " + this.tracker.getXPath() + ":"));
            this.log.warn((Object)e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EntityResolverImpl
    implements EntityResolver {
        private EntityResolverImpl() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            JaxpMsvBean.this.log.warn((Object)("    WARNING: External entity " + systemId + " won't be resolved"));
            return new InputSource(EMPTY_STREAM);
        }
    }

    private class ErrorHandlerImpl
    implements ErrorHandler {
        private ErrorHandlerImpl() {
        }

        public void warning(SAXParseException e) throws SAXException {
            JaxpMsvBean.this.errorMessage(e, 0);
            throw e;
        }

        public void error(SAXParseException e) throws SAXException {
            JaxpMsvBean.this.errorMessage(e, 1);
            JaxpMsvBean.this.isValid = false;
            if (e.getMessage() != null && e.getMessage().startsWith("namespace URI of tag")) {
                JaxpMsvBean.this.validNamespace = false;
            }
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            JaxpMsvBean.this.errorMessage(e, 2);
            JaxpMsvBean.this.isValid = false;
            throw e;
        }
    }
}

