/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scm;

import java.io.File;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.util.FileUtils;

public class ScmBean {
    private String url;
    private String tag;
    private String workingDirectory;
    private File checkoutDirectory;
    private String tagBase;

    protected Embedder getEmbedder() throws Exception {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        Embedder embedder = new Embedder();
        embedder.start();
        Thread.currentThread().setContextClassLoader(oldClassLoader);
        return embedder;
    }

    public void checkout() throws Exception {
        ScmManager scmManager = this.lookupScmManager();
        ScmRepository repository = scmManager.makeScmRepository(this.url);
        String module = repository.getProviderRepository().getModule();
        if (repository.getProvider().equals("svn")) {
            if (this.tagBase != null && this.tagBase.length() > 0) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
                svnRepo.setTagBase(this.tagBase);
            }
            if (this.tag != null) {
                module = this.tag;
            }
        }
        this.checkoutDirectory = new File(this.workingDirectory);
        if (module.length() > 0) {
            this.checkoutDirectory = new File(this.checkoutDirectory, module);
        }
        if (this.checkoutDirectory.exists()) {
            FileUtils.deleteDirectory((File)this.checkoutDirectory);
        }
        this.checkoutDirectory.mkdirs();
        CheckOutScmResult result = scmManager.checkOut(repository, new ScmFileSet(this.checkoutDirectory), this.tag);
        this.checkResult((ScmResult)result);
    }

    protected ScmManager lookupScmManager() throws Exception {
        Embedder embedder = this.getEmbedder();
        ScmManager scmManager = (ScmManager)embedder.lookup(ScmManager.ROLE);
        return scmManager;
    }

    protected void checkResult(ScmResult result) throws Exception {
        if (!result.isSuccess()) {
            System.err.println("Provider message:");
            System.err.println(result.getProviderMessage());
            System.err.println("Command output:");
            System.err.println(result.getCommandOutput());
            throw new Exception("Error!");
        }
    }

    public void update() throws Exception {
        ScmManager scmManager = this.lookupScmManager();
        ScmRepository repository = scmManager.makeScmRepository(this.url);
        if (repository.getProvider().equals("svn") && this.tagBase != null && this.tagBase.length() > 0) {
            SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
            svnRepo.setTagBase(this.tagBase);
        }
        this.checkoutDirectory = new File(this.workingDirectory);
        UpdateScmResult result = scmManager.update(repository, new ScmFileSet(new File(this.workingDirectory)), this.tag);
        this.checkResult((ScmResult)result);
    }

    public void tag() throws Exception {
        ScmManager scmManager = this.lookupScmManager();
        ScmRepository repository = scmManager.makeScmRepository(this.url);
        if (repository.getProvider().equals("svn") && this.tagBase != null && this.tagBase.length() > 0) {
            SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
            svnRepo.setTagBase(this.tagBase);
        }
        TagScmResult result = scmManager.tag(repository, new ScmFileSet(new File(this.workingDirectory)), this.tag);
        this.checkResult((ScmResult)result);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public File getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public String getTagBase() {
        return this.tagBase;
    }

    public void setTagBase(String tagBase) {
        this.tagBase = tagBase;
    }
}

