/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.scm;

import java.io.File;
import org.apache.maven.plugins.scm.ScmPatternBean;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.FileUtils;

public class ScmDiffBean
extends ScmPatternBean {
    private String patchFile;
    private String startRevision;
    private String endRevision;

    public void diff() throws Exception {
        ScmManager scmManager = this.lookupScmManager();
        ScmRepository repository = this.getScmRepository(scmManager);
        ScmFileSet fileSet = new ScmFileSet(new File(this.getWorkingDirectory()), this.getIncludes(), this.getExcludes());
        DiffScmResult result = scmManager.diff(repository, fileSet, this.startRevision, this.endRevision);
        this.checkResult((ScmResult)result);
        FileUtils.fileWrite((String)this.patchFile, (String)result.getPatch());
    }

    public void setPatchFile(String patchFile) {
        this.patchFile = patchFile;
    }

    public String getPatchFile() {
        return this.patchFile;
    }

    public String getStartRevision() {
        return this.startRevision;
    }

    public void setStartRevision(String startRevision) {
        this.startRevision = startRevision;
    }

    public String getEndRevision() {
        return this.endRevision;
    }

    public void setEndRevision(String endRevision) {
        this.endRevision = endRevision;
    }
}

