/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.support.providers.proxy;

import java.io.IOException;
import java.io.NotSerializableException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import javax.management.MBeanServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnectException;
import org.mc4j.ems.connection.EmsUnsupportedTypeException;
import org.mc4j.ems.connection.LoadException;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.support.providers.JBossConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.StatsProxy;

public class GenericMBeanServerProxy
implements InvocationHandler,
StatsProxy {
    private static Log log = LogFactory.getLog((Class)GenericMBeanServerProxy.class);
    private Object remoteServer;
    private ConnectionProvider provider;
    private long roundTrips;
    private long failures;
    private boolean reconnecting = false;

    public GenericMBeanServerProxy(Object remoteServer) {
        this.remoteServer = remoteServer;
    }

    public GenericMBeanServerProxy() {
    }

    public ConnectionProvider getProvider() {
        return this.provider;
    }

    public void setProvider(ConnectionProvider provider) {
        this.provider = provider;
    }

    public Object getRemoteServer() {
        return this.remoteServer;
    }

    public void setRemoteServer(Object remoteServer) {
        this.remoteServer = remoteServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Class<?> serverClass = this.remoteServer.getClass();
        Method[] ms = serverClass.getMethods();
        Method queryMethod = null;
        for (int i = 0; i < ms.length; ++i) {
            if (!ms[i].getName().equals("queryMBeans")) continue;
            queryMethod = ms[i];
        }
        Method method = null;
        method = "queryMBeans".equals(m.getName()) ? queryMethod : serverClass.getMethod(m.getName(), m.getParameterTypes());
        if (method == null) {
            throw new EmsConnectException("Unsupported operation [" + m.getName() + "]");
        }
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        try {
            ++this.roundTrips;
            if (!(this.provider instanceof JBossConnectionProvider)) return method.invoke(this.remoteServer, args);
            JBossConnectionProvider jbossProvider = (JBossConnectionProvider)this.provider;
            jbossProvider.resetPrincipalInfo();
            return method.invoke(this.remoteServer, args);
        }
        catch (InvocationTargetException e) {
            ++this.failures;
            if (e.getCause() == null) throw e;
            Throwable t = e.getCause();
            if (t instanceof ConnectException) {
                throw new EmsConnectException(t);
            }
            if (t instanceof NoSuchObjectException) {
                if (this.provider == null) throw new EmsConnectException(t);
                if (this.reconnecting) throw new EmsConnectException(t);
                try {
                    log.info((Object)("Reestablishing RMI stub " + this.provider.getConnectionSettings().getServerUrl()));
                    this.reconnecting = true;
                    this.provider.connect();
                    Object object = this.invoke(proxy, m, args);
                    return object;
                }
                catch (Exception f) {
                    log.warn((Object)"Unable to reestablish RMI stub to restarted server.", (Throwable)f);
                    throw new EmsConnectException(t);
                }
                finally {
                    this.reconnecting = false;
                }
            }
            if (t instanceof IOException) {
                throw new EmsConnectException(t);
            }
            if (!(t instanceof NotSerializableException)) throw new EmsConnectException("Connection failure " + t.getLocalizedMessage(), t);
            throw new EmsUnsupportedTypeException("Value was not serializable " + t.getLocalizedMessage(), t);
        }
        catch (Exception e) {
            ++this.failures;
            throw e;
        }
    }

    public long getRoundTrips() {
        return this.roundTrips;
    }

    public long getFailures() {
        return this.failures;
    }

    public MBeanServer buildServerProxy() {
        try {
            Object proxy = Proxy.newProxyInstance(GenericMBeanServerProxy.class.getClassLoader(), new Class[]{Class.forName("javax.management.MBeanServer")}, (InvocationHandler)this);
            return (MBeanServer)proxy;
        }
        catch (ClassNotFoundException e) {
            throw new LoadException("Unable to find JMX Classes", (Throwable)e);
        }
    }
}

