/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection;

import com.vladium.utils.ObjectProfiler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionTracker;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.impl.jmx.connection.DConnection;
import org.mc4j.ems.impl.jmx.connection.bean.DMBean;

public class PooledConnectionTracker
implements ConnectionTracker {
    private static Log log = LogFactory.getLog((Class)PooledConnectionTracker.class);
    protected DConnection connection;
    protected List<RefreshItem> refreshItems = new ArrayList<RefreshItem>();
    protected ScheduledThreadPoolExecutor executor;
    private static int POOL_SIZE = 2;

    public PooledConnectionTracker(DConnection connection) {
        this.connection = connection;
        this.initTracker();
    }

    protected void initTracker() {
        ConnectionRefresh connectionRefresh = new ConnectionRefresh(20000L, this.connection);
        this.refreshItems.add(connectionRefresh);
        MBeanRefresh attributeRefresh = new MBeanRefresh(20000L);
        this.refreshItems.add(attributeRefresh);
        this.executor = new ScheduledThreadPoolExecutor(POOL_SIZE, new ThreadFactory(){
            private AtomicInteger index = new AtomicInteger(1);

            public Thread newThread(Runnable r) {
                return new Thread(r, "EMS-ConnectionTracker-" + this.index.getAndIncrement());
            }
        });
        this.executor.scheduleAtFixedRate(connectionRefresh, 1000L, connectionRefresh.getUpdateDelay(), TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(attributeRefresh, 1500L, attributeRefresh.getUpdateDelay(), TimeUnit.MILLISECONDS);
    }

    public void stopTracker() {
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor.shutdown();
    }

    public void registerUpdateRequest(String objectName, long delay) {
        throw new UnsupportedOperationException();
    }

    public void removeUpdateRequest(String objectName) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MBeanRefresh
    extends AbstractConnectionRefresh {
        private DMBean mbean;
        Set<String> attributes;
        boolean first;

        public MBeanRefresh(long updateDelay) {
            super(updateDelay);
            this.first = true;
        }

        public MBeanRefresh(long updateDelay, DMBean mbean) {
            super(updateDelay);
            this.first = true;
            this.mbean = mbean;
        }

        public MBeanRefresh(long updateDelay, DMBean mbean, Set<String> attributes) {
            super(updateDelay);
            this.first = true;
            this.mbean = mbean;
            this.attributes = attributes;
        }

        @Override
        public void run() {
            if (this.mbean == null) {
                System.gc();
                long beforeMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                long total = 0L;
                long count = 0L;
                for (EmsBean bean : PooledConnectionTracker.this.connection.getBeans()) {
                    bean.refreshAttributes();
                    for (EmsAttribute attribute : bean.getAttributes()) {
                        int size = attribute.getValueSize();
                        total += (long)size;
                        if (size > 0) {
                            ++count;
                        }
                        if (!attribute.getName().equalsIgnoreCase("stats")) continue;
                        log.debug((Object)new StringBuffer().append("Stats size: ").append(ObjectProfiler.sizeof((Object)attribute.getValue())).toString());
                    }
                }
                log.debug((Object)new StringBuffer().append("Total size of ").append(count).append(" attributes: ").append(total).toString());
                log.debug((Object)new StringBuffer().append("Total connection size: ").append(ObjectProfiler.sizeof((Object)PooledConnectionTracker.this.connection)).toString());
                System.gc();
                long afterMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                log.debug((Object)new StringBuffer().append("Memory difference for update: ").append(afterMem - beforeMem).toString());
            } else if (this.attributes == null) {
                this.mbean.refreshAttributes();
            } else {
                for (String attributeName : this.attributes) {
                    this.mbean.getAttribute(attributeName).refresh();
                }
            }
        }
    }

    private class ConnectionRefresh
    extends AbstractConnectionRefresh {
        private DConnection connection;

        public ConnectionRefresh(long updateDelay, DConnection connection) {
            super(updateDelay);
            this.connection = connection;
        }

        public void run() {
            this.connection.loadSynchronous(false);
        }
    }

    private abstract class AbstractConnectionRefresh
    implements RefreshItem {
        long updateDelay;

        public AbstractConnectionRefresh(long updateDelay) {
            this.updateDelay = updateDelay;
        }

        public long getUpdateDelay() {
            return this.updateDelay;
        }
    }

    private static interface RefreshItem
    extends Runnable {
        public long getUpdateDelay();
    }
}

