/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionTracker;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.impl.jmx.connection.DConnection;
import org.mc4j.ems.impl.jmx.connection.bean.DMBean;

public class PooledConnectionTracker
implements ConnectionTracker {
    private static Log log = LogFactory.getLog(PooledConnectionTracker.class);
    protected DConnection connection;
    protected List<RefreshItem> refreshItems = new ArrayList<RefreshItem>();
    protected ScheduledThreadPoolExecutor executor;
    private static int POOL_SIZE = 2;

    public PooledConnectionTracker(DConnection connection) {
        this.connection = connection;
        this.initTracker();
    }

    protected void initTracker() {
        ConnectionRefresh connectionRefresh = new ConnectionRefresh(20000L, this.connection);
        this.refreshItems.add(connectionRefresh);
        MBeanRefresh attributeRefresh = new MBeanRefresh(20000L);
        this.refreshItems.add(attributeRefresh);
        this.executor = new ScheduledThreadPoolExecutor(POOL_SIZE, new ThreadFactory(){
            private AtomicInteger index = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "EMS-ConnectionTracker-" + this.index.getAndIncrement());
            }
        });
        this.executor.scheduleAtFixedRate(connectionRefresh, 1000L, connectionRefresh.getUpdateDelay(), TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(attributeRefresh, 1500L, attributeRefresh.getUpdateDelay(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void stopTracker() {
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor.shutdown();
    }

    @Override
    public void registerUpdateRequest(String objectName, long delay) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeUpdateRequest(String objectName) {
        throw new UnsupportedOperationException();
    }

    private class MBeanRefresh
    extends AbstractConnectionRefresh {
        private DMBean mbean;
        Set<String> attributes;
        boolean first;

        public MBeanRefresh(long updateDelay) {
            super(updateDelay);
            this.first = true;
        }

        public MBeanRefresh(long updateDelay, DMBean mbean) {
            super(updateDelay);
            this.first = true;
            this.mbean = mbean;
        }

        public MBeanRefresh(long updateDelay, DMBean mbean, Set<String> attributes) {
            super(updateDelay);
            this.first = true;
            this.mbean = mbean;
            this.attributes = attributes;
        }

        @Override
        public void run() {
            if (this.mbean == null) {
                System.gc();
                long beforeMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                long total = 0L;
                long count = 0L;
                for (EmsBean bean : PooledConnectionTracker.this.connection.getBeans()) {
                    bean.refreshAttributes();
                    for (EmsAttribute attribute : bean.getAttributes()) {
                        int size = attribute.getValueSize();
                        total += (long)size;
                        if (size > 0) {
                            ++count;
                        }
                        if (!attribute.getName().equalsIgnoreCase("stats")) continue;
                    }
                }
                log.debug((Object)("Total size of " + count + " attributes: " + total));
                System.gc();
                long afterMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                log.debug((Object)("Memory difference for update: " + (afterMem - beforeMem)));
            } else if (this.attributes == null) {
                this.mbean.refreshAttributes();
            } else {
                for (String attributeName : this.attributes) {
                    this.mbean.getAttribute(attributeName).refresh();
                }
            }
        }
    }

    private class ConnectionRefresh
    extends AbstractConnectionRefresh {
        private DConnection connection;

        public ConnectionRefresh(long updateDelay, DConnection connection) {
            super(updateDelay);
            this.connection = connection;
        }

        @Override
        public void run() {
            this.connection.loadSynchronous(false);
        }
    }

    private abstract class AbstractConnectionRefresh
    implements RefreshItem {
        long updateDelay;

        public AbstractConnectionRefresh(long updateDelay) {
            this.updateDelay = updateDelay;
        }

        @Override
        public long getUpdateDelay() {
            return this.updateDelay;
        }
    }

    private static interface RefreshItem
    extends Runnable {
        public long getUpdateDelay();
    }
}

