/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsBeanNotFoundException;
import org.mc4j.ems.connection.EmsUnsupportedTypeException;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.EmsBeanName;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.notification.EmsNotification;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.mc4j.ems.connection.bean.parameter.EmsParameter;
import org.mc4j.ems.impl.jmx.connection.bean.DBeanName;
import org.mc4j.ems.impl.jmx.connection.bean.attribute.DAttribute;
import org.mc4j.ems.impl.jmx.connection.bean.attribute.DUnkownAttribute;
import org.mc4j.ems.impl.jmx.connection.bean.notification.DNotification;
import org.mc4j.ems.impl.jmx.connection.bean.operation.DOperation;
import org.mc4j.ems.impl.jmx.connection.support.providers.AbstractConnectionProvider;

public class DMBean
implements EmsBean {
    private static Log log = LogFactory.getLog(DMBean.class);
    protected AbstractConnectionProvider connectionProvider;
    protected ObjectName objectName;
    protected EmsBeanName beanName;
    private MBeanInfo info;
    private boolean loaded = false;
    private boolean unsupportedType = false;
    protected boolean deleted = false;
    private Map<String, EmsAttribute> attributes;
    private Map<String, EmsOperation> operations;
    private Map<String, EmsNotification> notifications;
    protected List<Throwable> failures;
    protected boolean hasUnsupportedType = false;
    private static final Map TYPES = new HashMap();

    public DMBean(AbstractConnectionProvider connectionProvider, ObjectName objectName) {
        this.connectionProvider = connectionProvider;
        this.objectName = objectName;
        this.beanName = new DBeanName(objectName);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public EmsBeanName getBeanName() {
        return this.beanName;
    }

    @Override
    public AbstractConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public List<Throwable> getFailures() {
        return this.failures;
    }

    protected void registerFailure(Throwable t) {
        if (this.failures == null) {
            this.failures = new LinkedList<Throwable>();
        }
        this.failures.add(t);
        log.debug((Object)"MBean access failure", t);
    }

    @Override
    public boolean isHasUnsupportedType() {
        return this.unsupportedType;
    }

    @Override
    public boolean isNotificationEmiter() {
        try {
            return this.connectionProvider.getMBeanServer().isInstanceOf(this.getObjectName(), "javax.management.NotificationEmitter");
        }
        catch (InstanceNotFoundException e) {
            throw new EmsBeanNotFoundException("Bean doesn't exist", e);
        }
    }

    @Override
    public <T> T getProxy(Class<T> beanInterface) {
        throw new UnsupportedOperationException("Proxies not supported pre-jmx 1.2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void loadSynchronous() {
        if (!this.loaded) {
            try {
                this.info = this.connectionProvider.getMBeanServer().getMBeanInfo(this.objectName);
                if (this.info.getAttributes().length > 0) {
                    this.attributes = new TreeMap<String, EmsAttribute>(String.CASE_INSENSITIVE_ORDER);
                    for (MBeanFeatureInfo mBeanFeatureInfo : this.info.getAttributes()) {
                        DAttribute attribute = new DAttribute((MBeanAttributeInfo)mBeanFeatureInfo, this);
                        this.attributes.put(mBeanFeatureInfo.getName(), attribute);
                    }
                }
                if (this.info.getOperations().length > 0) {
                    this.operations = new TreeMap<String, EmsOperation>(String.CASE_INSENSITIVE_ORDER);
                    for (MBeanFeatureInfo mBeanFeatureInfo : this.info.getOperations()) {
                        DOperation operation = new DOperation((MBeanOperationInfo)mBeanFeatureInfo, this);
                        this.operations.put(mBeanFeatureInfo.getName(), operation);
                    }
                }
                if (this.info.getNotifications().length > 0) {
                    this.notifications = new TreeMap<String, EmsNotification>(String.CASE_INSENSITIVE_ORDER);
                    for (MBeanFeatureInfo mBeanFeatureInfo : this.info.getNotifications()) {
                        DNotification notification = new DNotification((MBeanNotificationInfo)mBeanFeatureInfo, this);
                        this.notifications.put(mBeanFeatureInfo.getName(), notification);
                    }
                }
            }
            catch (InstanceNotFoundException infe) {
                this.deleted = true;
                this.attributes = null;
                this.operations = null;
                this.notifications = null;
            }
            catch (Exception e) {
                this.unsupportedType = true;
                EmsUnsupportedTypeException emsUnsupportedTypeException = new EmsUnsupportedTypeException("Could not load MBean info, unsupported type on bean " + this.objectName, e);
            }
            finally {
                this.loaded = true;
            }
        }
    }

    @Override
    public void unload() {
        if (this.loaded) {
            this.loaded = false;
            this.info = null;
            this.attributes.clear();
            this.operations.clear();
            this.notifications.clear();
        }
    }

    @Override
    public boolean isRegistered() {
        MBeanServer server = this.getConnectionProvider().getMBeanServer();
        return server.isRegistered(this.getObjectName());
    }

    @Override
    public EmsAttribute getAttribute(String name) {
        EmsAttribute attribute;
        if (!this.loaded) {
            this.loadSynchronous();
        }
        if ((attribute = this.attributes.get(name)) == null && this.unsupportedType) {
            attribute = new DUnkownAttribute(this, name);
            this.attributes.put(name, attribute);
        }
        return attribute;
    }

    @Override
    public SortedSet<EmsAttribute> getAttributes() {
        if (!this.loaded) {
            this.loadSynchronous();
        }
        return new TreeSet<EmsAttribute>(this.attributes.values());
    }

    @Override
    public List<EmsAttribute> refreshAttributes() {
        if (this.info == null) {
            this.loadSynchronous();
        }
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[]{};
        try {
            infos = this.info.getAttributes();
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (MBeanAttributeInfo info : infos) {
            try {
                DMBean.findType(info.getType());
                nameList.add(info.getName());
            }
            catch (ClassNotFoundException cnfe) {
                log.info((Object)("Can't load attribute type of [" + info.getName() + "] because class not locally available"));
            }
        }
        return this.refreshAttributes(nameList);
    }

    @Override
    public List<EmsAttribute> refreshAttributes(List<String> attributeNames) {
        if (this.info == null) {
            this.loadSynchronous();
        }
        MBeanServer server = this.getConnectionProvider().getMBeanServer();
        try {
            String[] names = attributeNames.toArray(new String[attributeNames.size()]);
            AttributeList attributeList = server.getAttributes(this.getObjectName(), names);
            ArrayList<EmsAttribute> attributeResults = new ArrayList<EmsAttribute>();
            for (Attribute attr : attributeList) {
                EmsAttribute attribute = this.getAttribute(attr.getName());
                attribute.alterValue(attr.getValue());
                attributeResults.add(attribute);
            }
            return attributeResults;
        }
        catch (InstanceNotFoundException infe) {
            this.deleted = true;
            this.attributes = null;
            this.operations = null;
            this.notifications = null;
            throw new RuntimeException("Unable to load attributes, bean not found", infe);
        }
        catch (Exception e) {
            this.hasUnsupportedType = true;
            throw new RuntimeException("Unable to load attributes on bean [" + this.getBeanName().toString() + "] " + e.getMessage(), e);
        }
    }

    @Override
    public String getClassTypeName() {
        return this.getMBeanInfo().getClassName();
    }

    public static Class findType(String className) throws ClassNotFoundException {
        if (TYPES.containsKey(className)) {
            return (Class)TYPES.get(className);
        }
        return Class.forName(className, true, DMBean.class.getClassLoader());
    }

    @Override
    public Class getClassType() throws ClassNotFoundException {
        String className = this.getMBeanInfo().getClassName();
        return DMBean.findType(className);
    }

    @Override
    public EmsOperation getOperation(String name) {
        if (this.info == null) {
            this.loadSynchronous();
        }
        return this.operations.get(name);
    }

    @Override
    public EmsOperation getOperation(String operationName, Class ... parameterTypes) {
        this.getOperations();
        if (this.operations == null || this.operations.isEmpty()) {
            return null;
        }
        Object[] parameterTypeNames = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypeNames[i] = parameterTypes[i].getName();
        }
        EmsOperation selectedOperation = null;
        for (EmsOperation operation : this.operations.values()) {
            List<EmsParameter> operationParameters;
            if (!operation.getName().equals(operationName) || parameterTypeNames.length != (operationParameters = operation.getParameters()).size()) continue;
            Object[] operationParameterTypeNames = new String[operationParameters.size()];
            int i = 0;
            for (EmsParameter operationParameter : operationParameters) {
                operationParameterTypeNames[i] = operationParameter.getType();
                ++i;
            }
            if (!Arrays.equals(parameterTypeNames, operationParameterTypeNames)) continue;
            selectedOperation = operation;
            break;
        }
        return selectedOperation;
    }

    @Override
    public SortedSet<EmsOperation> getOperations() {
        if (this.info == null) {
            this.loadSynchronous();
        }
        return new TreeSet<EmsOperation>(this.operations.values());
    }

    @Override
    public EmsNotification getNotification(String name) {
        if (this.info == null) {
            this.loadSynchronous();
        }
        return this.notifications.get(name);
    }

    @Override
    public SortedSet<EmsNotification> getNotifications() {
        if (this.info == null) {
            this.loadSynchronous();
        }
        return new TreeSet<EmsNotification>(this.notifications.values());
    }

    @Override
    public void unregister() {
        try {
            this.connectionProvider.getMBeanServer().unregisterMBean(this.getObjectName());
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
        catch (InstanceNotFoundException e) {
            throw new EmsBeanNotFoundException("Could not unregister bean, instance not found [" + this.getObjectName().getCanonicalName() + "]", e);
        }
    }

    protected MBeanInfo getMBeanInfo() {
        if (this.info == null) {
            this.loadSynchronous();
        }
        return this.info;
    }

    public int compareTo(Object o) {
        DMBean otherBean = (DMBean)o;
        return this.getObjectName().getCanonicalName().compareTo(otherBean.getObjectName().getCanonicalName());
    }

    public String toString() {
        return this.getBeanName().toString();
    }

    static {
        TYPES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        TYPES.put(Character.TYPE.getName(), Character.TYPE);
        TYPES.put(Byte.TYPE.getName(), Byte.TYPE);
        TYPES.put(Short.TYPE.getName(), Short.TYPE);
        TYPES.put(Integer.TYPE.getName(), Integer.TYPE);
        TYPES.put(Long.TYPE.getName(), Long.TYPE);
        TYPES.put(Float.TYPE.getName(), Float.TYPE);
        TYPES.put(Double.TYPE.getName(), Double.TYPE);
        TYPES.put(Void.TYPE.getClass(), Void.TYPE);
    }
}

