/*
 * Decompiled with CFR 0.152.
 */
package me.xx2bab.polyfill.arsc.base;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import me.xx2bab.polyfill.arsc.base.CommonConstantsKt;
import me.xx2bab.polyfill.arsc.base.Header;
import me.xx2bab.polyfill.arsc.base.IParsable;
import me.xx2bab.polyfill.arsc.export.IResArscTweaker;
import me.xx2bab.polyfill.arsc.export.SimpleResource;
import me.xx2bab.polyfill.arsc.export.SupportedResConfig;
import me.xx2bab.polyfill.arsc.export.SupportedResType;
import me.xx2bab.polyfill.arsc.io.ByteBufferExtensionKt;
import me.xx2bab.polyfill.arsc.io.LittleEndianInputStream;
import me.xx2bab.polyfill.arsc.io.LittleEndianOutputStream;
import me.xx2bab.polyfill.arsc.pack.AbsResType;
import me.xx2bab.polyfill.arsc.pack.ResPackage;
import me.xx2bab.polyfill.arsc.pack.TypeType;
import me.xx2bab.polyfill.arsc.pack.type.ResEntry;
import me.xx2bab.polyfill.arsc.pack.type.ResValue;
import me.xx2bab.polyfill.arsc.stringpool.StringPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001c2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0002J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bH\u0002J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bH\u0002J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bH\u0002J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u000b0,H\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020-H\u0002J\u001a\u00106\u001a\u0004\u0018\u00010-2\u0006\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020\u000bH\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000bH\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010-2\u0006\u0010;\u001a\u00020:2\u0006\u0010=\u001a\u00020\u000bH\u0002J\u0010\u0010>\u001a\u00020/2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\b\u0010C\u001a\u00020DH\u0016J\u0018\u0010E\u001a\u00020B2\u0006\u0010F\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020@H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006I"}, d2={"Lme/xx2bab/polyfill/arsc/base/ResTable;", "Lme/xx2bab/polyfill/arsc/base/IParsable;", "Lme/xx2bab/polyfill/arsc/export/IResArscTweaker;", "()V", "header", "Lme/xx2bab/polyfill/arsc/base/Header;", "getHeader", "()Lme/xx2bab/polyfill/arsc/base/Header;", "setHeader", "(Lme/xx2bab/polyfill/arsc/base/Header;)V", "packageCount", "", "getPackageCount", "()I", "setPackageCount", "(I)V", "packages", "", "Lme/xx2bab/polyfill/arsc/pack/ResPackage;", "getPackages", "()Ljava/util/List;", "stringPool", "Lme/xx2bab/polyfill/arsc/stringpool/StringPool;", "getStringPool", "()Lme/xx2bab/polyfill/arsc/stringpool/StringPool;", "setStringPool", "(Lme/xx2bab/polyfill/arsc/stringpool/StringPool;)V", "findResourceById", "", "Lme/xx2bab/polyfill/arsc/export/SimpleResource;", "id", "findResourceEntriesById", "Lme/xx2bab/polyfill/arsc/pack/type/ResEntry;", "config", "Lme/xx2bab/polyfill/arsc/export/SupportedResConfig;", "generateResourceId", "packageId", "typeId", "entryId", "getPackageId", "resourceId", "getResourceEntryId", "getResourceTypeId", "getResourceTypes", "", "", "parse", "", "input", "Lme/xx2bab/polyfill/arsc/io/LittleEndianInputStream;", "start", "", "parseColor", "colorString", "parseName", "resPackage", "nameIndex", "parseSupportType", "Lme/xx2bab/polyfill/arsc/export/SupportedResType;", "type", "parseValue", "value", "read", "source", "Ljava/io/File;", "removeResourceById", "", "toByteArray", "", "updateResourceById", "resource", "write", "dest", "android-arsc-parser"})
public final class ResTable
implements IParsable,
IResArscTweaker {
    public Header header;
    private int packageCount;
    public StringPool stringPool;
    @NotNull
    private final List<ResPackage> packages = new ArrayList();

    @NotNull
    public final Header getHeader() {
        Header header = this.header;
        if (header != null) {
            return header;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"header");
        return null;
    }

    public final void setHeader(@NotNull Header header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"<set-?>");
        this.header = header;
    }

    public final int getPackageCount() {
        return this.packageCount;
    }

    public final void setPackageCount(int n) {
        this.packageCount = n;
    }

    @NotNull
    public final StringPool getStringPool() {
        StringPool stringPool = this.stringPool;
        if (stringPool != null) {
            return stringPool;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"stringPool");
        return null;
    }

    public final void setStringPool(@NotNull StringPool stringPool) {
        Intrinsics.checkNotNullParameter((Object)stringPool, (String)"<set-?>");
        this.stringPool = stringPool;
    }

    @NotNull
    public final List<ResPackage> getPackages() {
        return this.packages;
    }

    @Override
    public void parse(@NotNull LittleEndianInputStream input, long start) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.setHeader(new Header());
        this.getHeader().parse(input, start);
        this.packageCount = input.readInt();
        this.setStringPool(new StringPool());
        this.getStringPool().parse(input, input.getFilePointer());
        int n = 0;
        int n2 = this.packageCount;
        while (n < n2) {
            int i = n++;
            ResPackage resPackage = new ResPackage();
            resPackage.parse(input, input.getFilePointer());
            this.packages.add(resPackage);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public byte[] toByteArray() {
        void $this$mapTo$iv$iv;
        int headerSize = this.getHeader().size() + CommonConstantsKt.sizeOf(this.packageCount);
        byte[] stringPoolByteArray = this.getStringPool().toByteArray();
        int stringPoolSize = stringPoolByteArray.length;
        Iterable $this$map$iv = this.packages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResPackage resPackage = (ResPackage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toByteArray());
        }
        List packageByteArrays = (List)destination$iv$iv;
        Iterable $this$sumBy$iv = packageByteArrays;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            Object item$iv$iv;
            item$iv$iv = (byte[])element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = ((void)it).length;
            sum$iv = n + n2;
        }
        int packageSize = sum$iv;
        int newChunkSize = headerSize + stringPoolSize + packageSize;
        ByteBuffer bf = ByteBuffer.allocate(newChunkSize);
        Intrinsics.checkNotNullExpressionValue((Object)bf, (String)"bf");
        ByteBufferExtensionKt.takeLittleEndianOrder(bf);
        bf.putShort(this.getHeader().getType());
        bf.putShort((short)headerSize);
        bf.putInt(newChunkSize);
        bf.putInt(this.packages.size());
        bf.put(stringPoolByteArray);
        Iterable $this$forEach$iv = packageByteArrays;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] it = (byte[])element$iv;
            boolean bl = false;
            bf.put(it);
        }
        return ByteBufferExtensionKt.flipToArray(bf);
    }

    @Override
    public void read(@NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source.exists() && source.isFile() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)source), (Object)"arsc")) {
            LittleEndianInputStream inputStream = new LittleEndianInputStream(source);
            this.parse(inputStream, 0L);
            return;
        }
        throw new IllegalArgumentException("The arsc file is illegal.");
    }

    @Override
    public void write(@NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (dest.exists()) {
            dest.delete();
        }
        dest.getParentFile().mkdirs();
        dest.createNewFile();
        LittleEndianOutputStream outputStream = new LittleEndianOutputStream(dest);
        outputStream.writeByte(this.toByteArray());
        outputStream.close();
    }

    @Override
    @NotNull
    public Map<String, Integer> getResourceTypes() {
        Map<String, Integer> map = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(map, (String)"emptyMap()");
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SimpleResource> findResourceById(int id) {
        void $this$mapTo$iv$iv;
        IParsable it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.packages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResPackage)element$iv$iv;
            boolean bl = false;
            if (!(((ResPackage)it).getPackageId() == this.getPackageId(id))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredPackages = (List)destination$iv$iv;
        Iterable $this$map$iv = this.findResourceEntriesById(id, new SupportedResConfig());
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SupportedResType type = this.parseSupportType(((ResEntry)it).getResValue().getDataType());
            String name = this.parseName((ResPackage)filteredPackages.get(0), ((ResEntry)it).getStringPoolIndex());
            String value = this.parseValue(type, ((ResEntry)it).getResValue().getData());
            collection.add(new SimpleResource(id, type, name, value));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean removeResourceById(int id) {
        return false;
    }

    @Override
    public boolean updateResourceById(@NotNull SimpleResource resource, @NotNull SupportedResConfig config) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        List<ResEntry> entries = this.findResourceEntriesById(resource.getId(), config);
        if (entries.isEmpty()) {
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[resource.getType().ordinal()]) {
            case 1: {
                Iterable $this$forEach$iv = entries;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResEntry it = (ResEntry)element$iv;
                    boolean bl = false;
                    ResValue resValue = it.getResValue();
                    String string = resource.getValue();
                    Intrinsics.checkNotNull((Object)string);
                    resValue.setData(this.parseColor(string));
                }
                break;
            }
            case 2: {
                Iterable $this$forEach$iv = entries;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResEntry it = (ResEntry)element$iv;
                    boolean bl = false;
                    this.getStringPool().getStrings()[it.getResValue().getData()] = resource.getValue();
                }
                break;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResEntry> findResourceEntriesById(int id, SupportedResConfig config) {
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        boolean bl;
        Iterable $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        int packageId = this.getPackageId(id);
        int typeId = this.getResourceTypeId(id);
        int entryId = this.getResourceEntryId(id);
        List<ResEntry> $this$filter$iv = (List<ResEntry>)this.packages;
        boolean $i$f$filter = false;
        List<ResEntry> list = $this$filter$iv;
        Collection<Object> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ResPackage resPackage = (ResPackage)element$iv$iv;
            boolean bl2 = false;
            if (!(resPackage.getPackageId() == packageId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredPackages = (List)destination$iv$iv;
        if (((Collection)filteredPackages).isEmpty()) {
            $this$filter$iv = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue($this$filter$iv, (String)"emptyList()");
            return $this$filter$iv;
        }
        List<ResEntry> $this$filter$iv2 = (List<ResEntry>)((ResPackage)filteredPackages.get(0)).getResTypes();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object e : $this$filterTo$iv$iv) {
            AbsResType it = (AbsResType)e;
            bl = false;
            if (!(it.getTypeId() == typeId)) continue;
            destination$iv$iv2.add(e);
        }
        List filteredTypes = (List)destination$iv$iv2;
        if (((Collection)filteredTypes).isEmpty()) {
            $this$filter$iv2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue($this$filter$iv2, (String)"emptyList()");
            return $this$filter$iv2;
        }
        Iterable $this$filter$iv3 = filteredTypes;
        boolean $i$f$filter3 = false;
        $this$filterTo$iv$iv = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object e : $this$filterTo$iv$iv) {
            AbsResType it = (AbsResType)e;
            bl = false;
            if (!(it instanceof TypeType && ((TypeType)it).getEntries().length > entryId)) continue;
            destination$iv$iv3.add(e);
        }
        $this$filter$iv3 = (List)destination$iv$iv3;
        $i$f$filter3 = false;
        $this$filterTo$iv$iv = $this$filter$iv3;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterTo3 = false;
        for (Object e : $this$filterTo$iv$iv) {
            boolean result2;
            String lang;
            boolean result1;
            short v;
            AbsResType it = (AbsResType)e;
            bl = false;
            TypeType tt = (TypeType)it;
            boolean bl3 = config.getMinOsVersion() != -2147483647 ? ((v = tt.getConfig().getSdkVersion()) == 0 ? false : config.getMinOsVersion() >= v) : (result1 = true);
            boolean bl4 = !StringsKt.isBlank((CharSequence)config.getLanguage()) ? (Intrinsics.areEqual((Object)(lang = tt.getConfig().unpackLanguage(tt.getConfig().getLanguage())), (Object)"") ? false : StringsKt.equals((String)config.getLanguage(), (String)lang, (boolean)true)) : (result2 = true);
            if (!(result1 && result2)) continue;
            destination$iv$iv3.add(e);
        }
        $this$filter$iv3 = (List)destination$iv$iv3;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean bl5 = false;
        Object it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            ResEntry resEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl6 = false;
            AbsResType it2 = (AbsResType)element$iv$iv;
            boolean bl4 = false;
            if (((TypeType)it2).getEntries()[entryId] == null) continue;
            ResEntry it$iv$iv = resEntry;
            boolean bl52 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv3;
        $i$f$filter3 = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv3;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterTo3 = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (ResEntry)t;
            boolean bl7 = false;
            if (!(((ResEntry)it).getPairCount() == 0)) continue;
            destination$iv$iv3.add(t);
        }
        $this$filter$iv3 = (List)destination$iv$iv3;
        $i$f$filter3 = false;
        $this$filterTo$iv$iv = $this$filter$iv3;
        destination$iv$iv3 = new ArrayList();
        $i$f$filterTo3 = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (ResEntry)t;
            boolean bl8 = false;
            byte type = ((ResEntry)it).getResValue().getDataType();
            if (!(this.parseSupportType(type) != SupportedResType.UNSUPPORTED)) continue;
            destination$iv$iv3.add(t);
        }
        return (List)destination$iv$iv3;
    }

    private final SupportedResType parseSupportType(int type) {
        int n = type;
        return (28 <= n ? n < 32 : false) ? SupportedResType.COLOR : (n == 3 ? SupportedResType.STRING : SupportedResType.UNSUPPORTED);
    }

    private final String parseName(ResPackage resPackage, int nameIndex) {
        return resPackage.getResKeywordStringPool().getStrings()[nameIndex];
    }

    private final String parseValue(SupportedResType type, int value) {
        if (type == SupportedResType.COLOR) {
            return Intrinsics.stringPlus((String)"#", (Object)Integer.toHexString(value));
        }
        if (type == SupportedResType.STRING) {
            return this.getStringPool().getStrings()[value];
        }
        return "";
    }

    private final int getPackageId(int resourceId) {
        return (resourceId & 0xFF000000) >> 24;
    }

    private final int getResourceTypeId(int resourceId) {
        return (resourceId & 0xFF0000) >> 16;
    }

    private final int getResourceEntryId(int resourceId) {
        return resourceId & 0xFFFF;
    }

    private final int generateResourceId(int packageId, int typeId, int entryId) {
        return (packageId << 24) + (typeId << 16) + entryId;
    }

    private final int parseColor(String colorString) {
        if (colorString.charAt(0) == '#') {
            String string = colorString;
            int n = 1;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            long color = Long.parseLong(string3, CharsKt.checkRadix((int)16));
            if (colorString.length() == 7) {
                color |= 0xFFFFFFFFFF000000L;
            } else if (!(colorString.length() == 9)) {
                boolean bl = false;
                String string4 = "Unknown color";
                throw (Throwable)new IllegalArgumentException(string4.toString());
            }
            return (int)color;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SupportedResType.values().length];
            nArray[SupportedResType.COLOR.ordinal()] = 1;
            nArray[SupportedResType.STRING.ordinal()] = 2;
            nArray[SupportedResType.UNSUPPORTED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

