/*
 * Decompiled with CFR 0.152.
 */
package me.xx2bab.polyfill.arsc.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0013H\u0007J\u0006\u0010\u001a\u001a\u00020\u0013J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u000bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lme/xx2bab/polyfill/arsc/io/LittleEndianInputStream;", "Ljava/io/InputStream;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "", "(Ljava/lang/String;)V", "original", "Ljava/io/RandomAccessFile;", "(Ljava/io/RandomAccessFile;)V", "fileLength", "", "getFileLength", "()J", "filePointer", "getFilePointer", "close", "", "read", "", "readByte", "", "buffer", "", "offset", "length", "readInt", "readShort", "", "seek", "pos", "android-arsc-parser"})
public final class LittleEndianInputStream
extends InputStream {
    @NotNull
    private final RandomAccessFile original;

    public LittleEndianInputStream(@NotNull RandomAccessFile original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.original = original;
    }

    public LittleEndianInputStream(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(new RandomAccessFile(file, "r"));
    }

    public LittleEndianInputStream(@NotNull String file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(new RandomAccessFile(file, "r"));
    }

    @Override
    public int read() throws IOException {
        return this.original.read();
    }

    public final short readShort() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(this.original.readByte());
        byteBuffer.put(this.original.readByte());
        byteBuffer.flip();
        return byteBuffer.getShort();
    }

    public final int readInt() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.clear();
        int n = 1;
        while (n < 5) {
            int i = n++;
            byteBuffer.put(this.original.readByte());
        }
        byteBuffer.flip();
        return byteBuffer.getInt();
    }

    public final byte readByte() throws IOException {
        return this.original.readByte();
    }

    @JvmOverloads
    public final void readByte(@NotNull byte[] buffer, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        byteBuffer.clear();
        int n = 1;
        if (n <= length) {
            int i;
            do {
                i = n++;
                byteBuffer.put(this.original.readByte());
            } while (i != length);
        }
        byteBuffer.flip();
        byteBuffer.get(buffer, offset, length);
    }

    public static /* synthetic */ void readByte$default(LittleEndianInputStream littleEndianInputStream, byte[] byArray, int n, int n2, int n3, Object object) throws IOException {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        littleEndianInputStream.readByte(byArray, n, n2);
    }

    public final void seek(long pos) throws IOException {
        this.original.seek(pos);
    }

    public final long getFilePointer() throws IOException {
        return this.original.getFilePointer();
    }

    public final long getFileLength() throws IOException {
        return this.original.length();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.original.close();
    }

    @JvmOverloads
    public final void readByte(@NotNull byte[] buffer, int offset) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        LittleEndianInputStream.readByte$default(this, buffer, offset, 0, 4, null);
    }

    @JvmOverloads
    public final void readByte(@NotNull byte[] buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        LittleEndianInputStream.readByte$default(this, buffer, 0, 0, 6, null);
    }
}

