/*
 * Decompiled with CFR 0.152.
 */
package me.xx2bab.polyfill.arsc.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\n\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000bJ\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u0017\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ \u0010\u0017\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0016J\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020 R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lme/xx2bab/polyfill/arsc/io/LittleEndianOutputStream;", "Ljava/io/OutputStream;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "", "(Ljava/lang/String;)V", "original", "Ljava/io/RandomAccessFile;", "(Ljava/io/RandomAccessFile;)V", "fileLength", "", "getFileLength", "()J", "filePointer", "getFilePointer", "close", "", "seek", "pos", "write", "b", "", "writeByte", "data", "", "buffer", "", "offset", "length", "writeInt", "writeShort", "", "android-arsc-parser"})
public final class LittleEndianOutputStream
extends OutputStream {
    @NotNull
    private final RandomAccessFile original;

    public LittleEndianOutputStream(@NotNull RandomAccessFile original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.original = original;
    }

    public LittleEndianOutputStream(@Nullable File file) {
        this(new RandomAccessFile(file, "rw"));
    }

    public LittleEndianOutputStream(@Nullable String file) {
        this(new RandomAccessFile(file, "rw"));
    }

    @Override
    public void write(int b) throws IOException {
        this.original.write(b);
    }

    public final void writeShort(short data) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putShort(data);
        byteBuffer.flip();
        this.original.write(byteBuffer.array());
    }

    public final void writeInt(int data) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(data);
        byteBuffer.flip();
        this.original.write(byteBuffer.array());
    }

    public final void writeByte(byte data) throws IOException {
        this.original.write(data);
    }

    public final void writeByte(@Nullable byte[] buffer) throws IOException {
        this.original.write(buffer);
    }

    public final void writeByte(@Nullable byte[] buffer, int offset, int length) throws IOException {
        this.original.write(buffer, offset, length);
    }

    public final void seek(long pos) throws IOException {
        this.original.seek(pos);
    }

    public final long getFilePointer() throws IOException {
        return this.original.getFilePointer();
    }

    public final long getFileLength() throws IOException {
        return this.original.length();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.original.close();
    }
}

