/*
 * Decompiled with CFR 0.152.
 */
package me.xx2bab.polyfill.arsc.stringpool;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.UnsignedBytes;
import java.io.DataOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\bH\u0002J \u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\bH\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u001e"}, d2={"Lme/xx2bab/polyfill/arsc/stringpool/UtfUtil;", "", "()V", "byteArrayToString", "", "array", "", "flag", "", "computeLengthOffset", "length", "decodeLength", "buffer", "Ljava/nio/ByteBuffer;", "offset", "decodeLengthUTF16", "decodeLengthUTF8", "decodeUtf8OrModifiedUtf8", "", "utf8Buffer", "characterCount", "decodeUtf8OrModifiedUtf8CodePoint", "in", "out", "encodeLength", "", "output", "Ljava/io/DataOutput;", "stringToByteArray", "str", "android-arsc-parser"})
public final class UtfUtil {
    @NotNull
    public static final UtfUtil INSTANCE = new UtfUtil();

    private UtfUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String byteArrayToString(@NotNull byte[] array, int flag) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int offset = 0;
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        int charCount = this.decodeLength(buffer, offset, flag);
        offset += this.computeLengthOffset(charCount, flag);
        if (flag == 256) {
            Object object2;
            int length = this.decodeLength(buffer, offset, flag);
            int originPosition = buffer.position();
            buffer.position(offset += this.computeLengthOffset(length, flag));
            try {
                object2 = this.decodeUtf8OrModifiedUtf8(buffer, charCount);
                object2 = new String((char[])object2);
            }
            finally {
                buffer.position(originPosition);
            }
            object = object2;
        } else {
            byte[] byArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"buffer.array()");
            int n = charCount * 2;
            Charset charset = Charsets.UTF_16LE;
            object = new String(byArray, offset, n, charset);
        }
        return object;
    }

    @NotNull
    public final byte[] stringToByteArray(@NotNull String str, int flag) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String string = str;
        Object object = flag == 256 ? Charsets.UTF_8 : Charsets.UTF_16LE;
        byte[] byArray = string.getBytes((Charset)object);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput((int)(bytes.length + 5));
        Intrinsics.checkNotNullExpressionValue((Object)dataOutput, (String)"dataOutput");
        this.encodeLength((DataOutput)dataOutput, str.length(), flag);
        if (flag == 256) {
            this.encodeLength((DataOutput)dataOutput, bytes.length, flag);
        }
        dataOutput.write(bytes);
        if (flag == 256) {
            dataOutput.write(0);
        } else {
            dataOutput.writeShort(0);
        }
        object = dataOutput.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dataOutput.toByteArray()");
        return object;
    }

    private final void encodeLength(DataOutput output, int length, int flag) {
        if (length < 0) {
            output.write(0);
            return;
        }
        if (flag == 256) {
            if (length > 127) {
                output.write((length & 0x7F00) >> 8 | 0x80);
            }
            output.write(length & 0xFF);
        } else {
            if (length > Short.MAX_VALUE) {
                int highBytes = (length & 0x7FFF0000) >> 16 | 0x8000;
                output.write(highBytes & 0xFF);
                output.write((highBytes & 0xFF00) >> 8);
            }
            int lowBytes = length & 0xFFFF;
            output.write(lowBytes & 0xFF);
            output.write((lowBytes & 0xFF00) >> 8);
        }
    }

    private final int decodeLength(ByteBuffer buffer, int offset, int flag) {
        return flag == 256 ? this.decodeLengthUTF8(buffer, offset) : this.decodeLengthUTF16(buffer, offset);
    }

    private final int decodeLengthUTF8(ByteBuffer buffer, int offset) {
        int length = UnsignedBytes.toInt((byte)buffer.get(offset));
        if ((length & 0x80) != 0) {
            length = (length & 0x7F) << 8 | UnsignedBytes.toInt((byte)buffer.get(offset + 1));
        }
        return length;
    }

    private final int decodeLengthUTF16(ByteBuffer buffer, int offset) {
        int length = buffer.getShort(offset) & 0xFFFF;
        if ((length & 0x8000) != 0) {
            length = (length & Short.MAX_VALUE) << 16 | buffer.getShort(offset + 2) & 0xFFFF;
        }
        return length;
    }

    private final int computeLengthOffset(int length, int flag) {
        return (flag == 256 ? 1 : 2) * (length >= (flag == 256 ? 128 : 32768) ? 2 : 1);
    }

    private final char[] decodeUtf8OrModifiedUtf8(ByteBuffer utf8Buffer, int characterCount) {
        char[] charBuffer = new char[characterCount];
        int offset = 0;
        while (offset < characterCount) {
            offset = this.decodeUtf8OrModifiedUtf8CodePoint(utf8Buffer, charBuffer, offset);
        }
        return charBuffer;
    }

    private final int decodeUtf8OrModifiedUtf8CodePoint(ByteBuffer in, char[] out, int offset) {
        int offset2 = offset;
        byte one = in.get();
        if ((one & 0x80) == 0) {
            int n = offset2;
            offset2 = n + 1;
            out[n] = (char)one;
            return offset2;
        }
        byte two = in.get();
        if ((one & 0x20) == 0) {
            int n = offset2;
            offset2 = n + 1;
            out[n] = (char)((one & 0x1F) << 6 | two & 0x3F);
            return offset2;
        }
        byte three = in.get();
        if ((one & 0x10) == 0) {
            int n = offset2;
            offset2 = n + 1;
            out[n] = (char)((one & 0xF) << 12 | (two & 0x3F) << 6 | three & 0x3F);
            return offset2;
        }
        byte four = in.get();
        int codePoint = (one & 0xF) << 18 | (two & 0x3F) << 12 | (three & 0x3F) << 6 | four & 0x3F;
        int n = offset2;
        offset2 = n + 1;
        out[n] = (char)((codePoint >> 10) + 55232 & 0xFFFF);
        n = offset2;
        offset2 = n + 1;
        out[n] = (char)((codePoint & 0x3FF) + 56320);
        return offset2;
    }
}

