/*
 * Decompiled with CFR 0.152.
 */
package me.xx2bab.scratchpaper.icon;

import com.android.ide.common.vectordrawable.Svg2Vector;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.xx2bab.scratchpaper.icon.BaseIconProcessor;
import me.xx2bab.scratchpaper.icon.IconProcessorParam;
import me.xx2bab.scratchpaper.utils.Logger;
import org.jetbrains.annotations.NotNull;
import org.jfree.graphics2d.svg.SVGGraphics2D;
import org.jfree.graphics2d.svg.SVGUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u001eH\u0016J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0016\u00a2\u0006\u0002\u0010!R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lme/xx2bab/scratchpaper/icon/AdaptiveIconProcessor;", "Lme/xx2bab/scratchpaper/icon/BaseIconProcessor;", "originIcon", "Ljava/io/File;", "destDir", "param", "Lme/xx2bab/scratchpaper/icon/IconProcessorParam;", "(Ljava/io/File;Ljava/io/File;Lme/xx2bab/scratchpaper/icon/IconProcessorParam;)V", "attrDrawable", "", "graphic", "Ljava/awt/Graphics2D;", "height", "", "layerList", "Lorg/w3c/dom/Element;", "originIconXmlDoc", "Lorg/w3c/dom/Document;", "tagAdaptiveIcon", "tagForeground", "tagItem", "tagLayerList", "width", "drawText", "", "line", "x", "y", "getGraphic", "getSize", "Lkotlin/Pair;", "writeIcon", "", "()[Ljava/io/File;", "scratchpaper"})
@SourceDebugExtension(value={"SMAP\nAdaptiveIconProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaptiveIconProcessor.kt\nme/xx2bab/scratchpaper/icon/AdaptiveIconProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class AdaptiveIconProcessor
extends BaseIconProcessor {
    @NotNull
    private final String attrDrawable;
    @NotNull
    private final String tagForeground;
    @NotNull
    private final String tagLayerList;
    @NotNull
    private final String tagItem;
    @NotNull
    private final String tagAdaptiveIcon;
    private final int width;
    private final int height;
    @NotNull
    private final Graphics2D graphic;
    @NotNull
    private final Document originIconXmlDoc;
    @NotNull
    private Element layerList;

    public AdaptiveIconProcessor(@NotNull File originIcon, @NotNull File destDir, @NotNull IconProcessorParam param) {
        Intrinsics.checkNotNullParameter((Object)originIcon, (String)"originIcon");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        super(originIcon, destDir, param);
        this.attrDrawable = "android:drawable";
        this.tagForeground = "foreground";
        this.tagLayerList = "layer-list";
        this.tagItem = "item";
        this.tagAdaptiveIcon = "adaptive-icon";
        this.width = 100;
        this.height = 100;
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(originIcon);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"newInstance()\n        .n\u2026ilder().parse(originIcon)");
        this.originIconXmlDoc = document;
        String drawableInForeground = null;
        Node foregroundElement = this.originIconXmlDoc.getElementsByTagName(this.tagForeground).item(0);
        if (foregroundElement != null) {
            if (foregroundElement.getAttributes().getNamedItem(this.attrDrawable) != null) {
                drawableInForeground = foregroundElement.getAttributes().getNamedItem(this.attrDrawable).getNodeValue();
                foregroundElement.getAttributes().removeNamedItem(this.attrDrawable);
            }
        } else {
            foregroundElement = this.originIconXmlDoc.createElement(this.tagForeground);
            Node adaptiveIconNode = this.originIconXmlDoc.getElementsByTagName(this.tagAdaptiveIcon).item(0);
            adaptiveIconNode.appendChild(foregroundElement);
        }
        Element element = this.originIconXmlDoc.createElement(this.tagLayerList);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"originIconXmlDoc.createElement(tagLayerList)");
        this.layerList = element;
        foregroundElement.appendChild(this.layerList);
        if (drawableInForeground != null) {
            Element itemDrawableElement = this.originIconXmlDoc.createElement(this.tagItem);
            Attr drawableAttr = this.originIconXmlDoc.createAttribute(this.attrDrawable);
            drawableAttr.setValue(drawableInForeground);
            itemDrawableElement.setAttributeNode(drawableAttr);
            this.layerList.appendChild(itemDrawableElement);
        }
        this.graphic = (Graphics2D)new SVGGraphics2D(this.width, this.height);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> getSize() {
        return new Pair((Object)this.width, (Object)this.height);
    }

    @Override
    @NotNull
    public Graphics2D getGraphic() {
        return this.graphic;
    }

    @Override
    public void drawText(@NotNull String line, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        TextLayout tl = new TextLayout(line, this.getGraphic().getFont(), this.getGraphic().getFontRenderContext());
        tl.draw(this.getGraphic(), x, y);
    }

    @Override
    @NotNull
    public File[] writeIcon() {
        File file;
        File file2;
        File imageParentFile = new File(this.getDestDir(), this.getOriginIcon().getParentFile().getName());
        if (!imageParentFile.exists() && !imageParentFile.mkdirs()) {
            Logger.INSTANCE.e("Can not create cache directory for ScratchPaper.");
        }
        File $this$writeIcon_u24lambda_u240 = file2 = new File(imageParentFile, this.getOriginIcon().getName());
        boolean bl = false;
        $this$writeIcon_u24lambda_u240.createNewFile();
        File destIcon = file2;
        File $this$writeIcon_u24lambda_u241 = $this$writeIcon_u24lambda_u240 = new File(destIcon.getParentFile().getParent() + File.separator + "drawable");
        boolean bl2 = false;
        $this$writeIcon_u24lambda_u241.mkdir();
        File commonDrawableDir = $this$writeIcon_u24lambda_u240;
        File overlaySVG = new File(commonDrawableDir, FilesKt.getNameWithoutExtension((File)destIcon) + "_overlay.svg");
        String overlayVectorDrawableFileName = FilesKt.getNameWithoutExtension((File)destIcon) + "_overlay.xml";
        File $this$writeIcon_u24lambda_u242 = file = new File(commonDrawableDir, overlayVectorDrawableFileName);
        boolean bl3 = false;
        $this$writeIcon_u24lambda_u242.createNewFile();
        File overlayVectorDrawable = file;
        Graphics2D graphics2D = this.getGraphic();
        Intrinsics.checkNotNull((Object)graphics2D, (String)"null cannot be cast to non-null type org.jfree.graphics2d.svg.SVGGraphics2D");
        SVGUtils.writeToSVG((File)overlaySVG, (String)((SVGGraphics2D)graphics2D).getSVGElement());
        FileOutputStream out = new FileOutputStream(overlayVectorDrawable);
        Svg2Vector.parseSvgToXml((Path)overlaySVG.toPath(), (OutputStream)out);
        Element itemDrawableElement = this.originIconXmlDoc.createElement(this.tagItem);
        Attr drawableAttr = this.originIconXmlDoc.createAttribute(this.attrDrawable);
        drawableAttr.setValue(StringsKt.removeSuffix((String)("@drawable/" + overlayVectorDrawableFileName), (CharSequence)".xml"));
        itemDrawableElement.setAttributeNode(drawableAttr);
        this.layerList.appendChild(itemDrawableElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(this.originIconXmlDoc);
        StreamResult result = new StreamResult(destIcon);
        transformer.transform(source, result);
        File[] fileArray = new File[]{destIcon, overlayVectorDrawable};
        return fileArray;
    }
}

