/*
 * Decompiled with CFR 0.152.
 */
package me.xx2bab.scratchpaper.icon;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.xx2bab.scratchpaper.icon.IconProcessorParam;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH&J\b\u0010\u0015\u001a\u00020\u0016H&J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0018H&J\u0011\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aH&\u00a2\u0006\u0002\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/xx2bab/scratchpaper/icon/BaseIconProcessor;", "", "originIcon", "Ljava/io/File;", "destDir", "param", "Lme/xx2bab/scratchpaper/icon/IconProcessorParam;", "(Ljava/io/File;Ljava/io/File;Lme/xx2bab/scratchpaper/icon/IconProcessorParam;)V", "getDestDir", "()Ljava/io/File;", "getOriginIcon", "getParam", "()Lme/xx2bab/scratchpaper/icon/IconProcessorParam;", "prettyImageSizeFits14FontSize", "", "drawText", "", "line", "", "x", "y", "getGraphic", "Ljava/awt/Graphics2D;", "getSize", "Lkotlin/Pair;", "process", "", "()[Ljava/io/File;", "writeIcon", "scratchpaper"})
public abstract class BaseIconProcessor {
    @NotNull
    private final File originIcon;
    @NotNull
    private final File destDir;
    @NotNull
    private final IconProcessorParam param;
    private final int prettyImageSizeFits14FontSize;

    public BaseIconProcessor(@NotNull File originIcon, @NotNull File destDir, @NotNull IconProcessorParam param) {
        Intrinsics.checkNotNullParameter((Object)originIcon, (String)"originIcon");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        this.originIcon = originIcon;
        this.destDir = destDir;
        this.param = param;
        this.prettyImageSizeFits14FontSize = 96;
    }

    @NotNull
    public final File getOriginIcon() {
        return this.originIcon;
    }

    @NotNull
    public final File getDestDir() {
        return this.destDir;
    }

    @NotNull
    public final IconProcessorParam getParam() {
        return this.param;
    }

    @NotNull
    public final File[] process() {
        Graphics2D graphics2D;
        Pair<Integer, Integer> size = this.getSize();
        int imgWidth = ((Number)size.getFirst()).intValue();
        int imgHeight = ((Number)size.getSecond()).intValue();
        double ratio = (double)imgWidth * 1.0 / (double)this.prettyImageSizeFits14FontSize;
        int fontSize = (int)((double)this.param.getTextSize() * ratio);
        int linePadding = (int)((double)this.param.getLineSpace() * ratio);
        int lineCount = this.param.getText().size();
        int totalLineHeight = fontSize * lineCount + (linePadding + 1) * lineCount;
        Graphics2D $this$process_u24lambda_u240 = graphics2D = this.getGraphic();
        boolean bl = false;
        $this$process_u24lambda_u240.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int marginTop = (imgHeight - totalLineHeight) / 2;
        $this$process_u24lambda_u240.setColor(this.param.getBgColor());
        $this$process_u24lambda_u240.fillRect(0, marginTop, imgWidth, totalLineHeight);
        $this$process_u24lambda_u240.setFont(new Font("SansSerif", 0, fontSize));
        $this$process_u24lambda_u240.setColor(this.param.getTextColor());
        Iterator iterator = CollectionsKt.reversed((Iterable)this.param.getText()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String line = (String)iterator.next();
            if (StringsKt.isBlank((CharSequence)line)) continue;
            int strWidth = $this$process_u24lambda_u240.getFontMetrics().stringWidth(line);
            int x = 0;
            if (imgWidth >= strWidth) {
                x = (imgWidth - strWidth) / 2;
            }
            int y = imgHeight - fontSize * i - (i + 1) * linePadding - marginTop;
            this.drawText(line, x, y);
        }
        return this.writeIcon();
    }

    @NotNull
    public abstract Pair<Integer, Integer> getSize();

    @NotNull
    public abstract Graphics2D getGraphic();

    public abstract void drawText(@NotNull String var1, int var2, int var3);

    @NotNull
    public abstract File[] writeIcon();
}

