/*
 * Decompiled with CFR 0.152.
 */
package me.xx2bab.scratchpaper.icon;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import me.xx2bab.scratchpaper.icon.BaseIconProcessor;
import me.xx2bab.scratchpaper.icon.IconProcessorParam;
import me.xx2bab.scratchpaper.utils.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/xx2bab/scratchpaper/icon/RegularIconProcessor;", "Lme/xx2bab/scratchpaper/icon/BaseIconProcessor;", "originIcon", "Ljava/io/File;", "destDir", "param", "Lme/xx2bab/scratchpaper/icon/IconProcessorParam;", "(Ljava/io/File;Ljava/io/File;Lme/xx2bab/scratchpaper/icon/IconProcessorParam;)V", "bufferedImage", "Ljava/awt/image/BufferedImage;", "graphic", "Ljava/awt/Graphics2D;", "drawText", "", "line", "", "x", "", "y", "getGraphic", "getSize", "Lkotlin/Pair;", "writeIcon", "", "()[Ljava/io/File;", "scratchpaper"})
public final class RegularIconProcessor
extends BaseIconProcessor {
    @NotNull
    private final BufferedImage bufferedImage;
    @NotNull
    private final Graphics2D graphic;

    public RegularIconProcessor(@NotNull File originIcon, @NotNull File destDir, @NotNull IconProcessorParam param) {
        Intrinsics.checkNotNullParameter((Object)originIcon, (String)"originIcon");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        super(originIcon, destDir, param);
        BufferedImage bufferedImage = ImageIO.read(originIcon);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(originIcon)");
        this.bufferedImage = bufferedImage;
        Graphics2D graphics2D = GraphicsEnvironment.getLocalGraphicsEnvironment().createGraphics(this.bufferedImage);
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"getLocalGraphicsEnvironm\u2026teGraphics(bufferedImage)");
        this.graphic = graphics2D;
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> getSize() {
        return new Pair((Object)this.bufferedImage.getWidth(), (Object)this.bufferedImage.getHeight());
    }

    @Override
    @NotNull
    public Graphics2D getGraphic() {
        return this.graphic;
    }

    @Override
    public void drawText(@NotNull String line, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.getGraphic().drawString(line, x, y);
    }

    @Override
    @NotNull
    public File[] writeIcon() {
        File imageParentFile = new File(this.getDestDir(), this.getOriginIcon().getParentFile().getName());
        if (!imageParentFile.exists() && !imageParentFile.mkdirs()) {
            Logger.INSTANCE.e("Can not create cache directory for ScratchPaper.");
        }
        File destIcon = new File(imageParentFile, this.getOriginIcon().getName());
        ImageIO.write((RenderedImage)this.bufferedImage, "png", destIcon);
        File[] fileArray = new File[]{destIcon};
        return fileArray;
    }
}

