/*
 * Decompiled with CFR 0.152.
 */
package me.aflak.arduino;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.util.Log;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.usbserial.UsbSerialInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.aflak.arduino.ArduinoListener;

public class Arduino
implements UsbSerialInterface.UsbReadCallback {
    private Context context;
    private ArduinoListener listener;
    private UsbDeviceConnection connection;
    private UsbSerialDevice serialPort;
    private UsbReceiver usbReceiver;
    private UsbManager usbManager;
    private UsbDevice lastArduinoAttached;
    private int baudRate;
    private boolean isOpened;
    private List<Integer> vendorIds;
    private List<Byte> bytesReceived;
    private byte delimiter;
    private static final String ACTION_USB_DEVICE_PERMISSION = "me.aflak.arduino.USB_PERMISSION";
    private static final int DEFAULT_BAUD_RATE = 9600;
    private static final byte DEFAULT_DELIMITER = 10;

    public Arduino(Context context, int baudRate) {
        this.init(context, baudRate);
    }

    public Arduino(Context context) {
        this.init(context, 9600);
    }

    private void init(Context context, int baudRate) {
        this.context = context;
        this.usbReceiver = new UsbReceiver();
        this.usbManager = (UsbManager)context.getSystemService("usb");
        this.baudRate = baudRate;
        this.isOpened = false;
        this.vendorIds = new ArrayList<Integer>();
        this.vendorIds.add(9025);
        this.bytesReceived = new ArrayList<Byte>();
        this.delimiter = (byte)10;
    }

    public void setArduinoListener(ArduinoListener listener) {
        this.listener = listener;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        intentFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        intentFilter.addAction(ACTION_USB_DEVICE_PERMISSION);
        this.context.registerReceiver((BroadcastReceiver)this.usbReceiver, intentFilter);
        this.lastArduinoAttached = this.getAttachedArduino();
        if (this.lastArduinoAttached != null && listener != null) {
            listener.onArduinoAttached(this.lastArduinoAttached);
        }
    }

    public void unsetArduinoListener() {
        this.listener = null;
    }

    public void open(UsbDevice device) {
        PendingIntent permissionIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(ACTION_USB_DEVICE_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_USB_DEVICE_PERMISSION);
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.context.registerReceiver((BroadcastReceiver)this.usbReceiver, filter);
        this.usbManager.requestPermission(device, permissionIntent);
    }

    public void reopen() {
        this.open(this.lastArduinoAttached);
    }

    public void close() {
        if (this.serialPort != null) {
            this.serialPort.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
        this.isOpened = false;
        this.context.unregisterReceiver((BroadcastReceiver)this.usbReceiver);
    }

    public void send(byte[] bytes) {
        if (this.serialPort != null) {
            this.serialPort.write(bytes);
        }
    }

    public void setDelimiter(byte delimiter) {
        this.delimiter = delimiter;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public void addVendorId(int id) {
        this.vendorIds.add(id);
    }

    private UsbDevice getAttachedArduino() {
        HashMap map = this.usbManager.getDeviceList();
        for (UsbDevice device : map.values()) {
            if (!this.hasId(device.getVendorId())) continue;
            return device;
        }
        return null;
    }

    private List<Integer> indexOf(byte[] bytes, byte b) {
        ArrayList<Integer> idx = new ArrayList<Integer>();
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != b) continue;
            idx.add(i);
        }
        return idx;
    }

    private List<Byte> toByteList(byte[] bytes) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (byte b : bytes) {
            list.add(b);
        }
        return list;
    }

    private byte[] toByteArray(List<Byte> bytes) {
        byte[] array = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            array[i] = bytes.get(i);
        }
        return array;
    }

    public void onReceivedData(byte[] bytes) {
        if (bytes.length != 0) {
            List<Integer> idx = this.indexOf(bytes, this.delimiter);
            if (idx.isEmpty()) {
                this.bytesReceived.addAll(this.toByteList(bytes));
            } else {
                int offset = 0;
                for (int index : idx) {
                    byte[] tmp = Arrays.copyOfRange(bytes, offset, index);
                    this.bytesReceived.addAll(this.toByteList(tmp));
                    if (this.listener != null) {
                        this.listener.onArduinoMessage(this.toByteArray(this.bytesReceived));
                    }
                    this.bytesReceived.clear();
                    offset += index + 1;
                }
                if (offset < bytes.length - 1) {
                    byte[] tmp = Arrays.copyOfRange(bytes, offset, bytes.length);
                    this.bytesReceived.addAll(this.toByteList(tmp));
                }
            }
        }
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    private boolean hasId(int id) {
        Log.i((String)this.getClass().getSimpleName(), (String)("Vendor id : " + id));
        for (int vendorId : this.vendorIds) {
            if (vendorId != id) continue;
            return true;
        }
        return false;
    }

    private class UsbReceiver
    extends BroadcastReceiver {
        private UsbReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction() != null) {
                switch (intent.getAction()) {
                    case "android.hardware.usb.action.USB_DEVICE_ATTACHED": {
                        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                        if (!Arduino.this.hasId(device.getVendorId())) break;
                        Arduino.this.lastArduinoAttached = device;
                        if (Arduino.this.listener == null) break;
                        Arduino.this.listener.onArduinoAttached(device);
                        break;
                    }
                    case "android.hardware.usb.action.USB_DEVICE_DETACHED": {
                        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                        if (!Arduino.this.hasId(device.getVendorId()) || Arduino.this.listener == null) break;
                        Arduino.this.listener.onArduinoDetached();
                        break;
                    }
                    case "me.aflak.arduino.USB_PERMISSION": {
                        if (intent.getBooleanExtra("permission", false)) {
                            UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                            if (!Arduino.this.hasId(device.getVendorId())) break;
                            Arduino.this.connection = Arduino.this.usbManager.openDevice(device);
                            Arduino.this.serialPort = UsbSerialDevice.createUsbSerialDevice((UsbDevice)device, (UsbDeviceConnection)Arduino.this.connection);
                            if (Arduino.this.serialPort == null || !Arduino.this.serialPort.open()) break;
                            Arduino.this.serialPort.setBaudRate(Arduino.this.baudRate);
                            Arduino.this.serialPort.setDataBits(8);
                            Arduino.this.serialPort.setStopBits(1);
                            Arduino.this.serialPort.setParity(0);
                            Arduino.this.serialPort.setFlowControl(0);
                            Arduino.this.serialPort.read((UsbSerialInterface.UsbReadCallback)Arduino.this);
                            Arduino.this.isOpened = true;
                            if (Arduino.this.listener == null) break;
                            Arduino.this.listener.onArduinoOpened();
                            break;
                        }
                        if (Arduino.this.listener == null) break;
                        Arduino.this.listener.onUsbPermissionDenied();
                    }
                }
            }
        }
    }
}

