/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.coapi.spring.client.reactive;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.coapi.spring.CoApiDefinition;
import me.ahoo.coapi.spring.client.ClientProperties;
import me.ahoo.coapi.spring.client.reactive.WebClientBuilderCustomizer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\f\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u001a\u0010\u0017\u001a\u00020\u0015*\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/ahoo/coapi/spring/client/reactive/AbstractWebClientFactoryBean;", "Lorg/springframework/beans/factory/FactoryBean;", "Lorg/springframework/web/reactive/function/client/WebClient;", "Lorg/springframework/context/ApplicationContextAware;", "definition", "Lme/ahoo/coapi/spring/CoApiDefinition;", "(Lme/ahoo/coapi/spring/CoApiDefinition;)V", "appContext", "Lorg/springframework/context/ApplicationContext;", "getAppContext", "()Lorg/springframework/context/ApplicationContext;", "setAppContext", "(Lorg/springframework/context/ApplicationContext;)V", "builderCustomizer", "Lme/ahoo/coapi/spring/client/reactive/WebClientBuilderCustomizer;", "getBuilderCustomizer", "()Lme/ahoo/coapi/spring/client/reactive/WebClientBuilderCustomizer;", "getObject", "getObjectType", "Ljava/lang/Class;", "setApplicationContext", "", "applicationContext", "initFilters", "Lme/ahoo/coapi/spring/client/ClientProperties$FilterDefinition;", "filters", "", "Lorg/springframework/web/reactive/function/client/ExchangeFilterFunction;", "coapi-spring"})
@SourceDebugExtension(value={"SMAP\nAbstractWebClientFactoryBean.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractWebClientFactoryBean.kt\nme/ahoo/coapi/spring/client/reactive/AbstractWebClientFactoryBean\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1855#2,2:70\n1855#2,2:72\n*S KotlinDebug\n*F\n+ 1 AbstractWebClientFactoryBean.kt\nme/ahoo/coapi/spring/client/reactive/AbstractWebClientFactoryBean\n*L\n55#1:70,2\n59#1:72,2\n*E\n"})
public abstract class AbstractWebClientFactoryBean
implements FactoryBean<WebClient>,
ApplicationContextAware {
    @NotNull
    private final CoApiDefinition definition;
    protected ApplicationContext appContext;
    @NotNull
    private final WebClientBuilderCustomizer builderCustomizer;

    public AbstractWebClientFactoryBean(@NotNull CoApiDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        this.definition = definition;
        this.builderCustomizer = WebClientBuilderCustomizer.NoOp.INSTANCE;
    }

    @NotNull
    protected final ApplicationContext getAppContext() {
        ApplicationContext applicationContext = this.appContext;
        if (applicationContext != null) {
            return applicationContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
        return null;
    }

    protected final void setAppContext(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"<set-?>");
        this.appContext = applicationContext;
    }

    @NotNull
    protected WebClientBuilderCustomizer getBuilderCustomizer() {
        return this.builderCustomizer;
    }

    @NotNull
    public Class<?> getObjectType() {
        return WebClient.class;
    }

    @NotNull
    public WebClient getObject() {
        Object object = this.getAppContext().getBean(WebClient.Builder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
        WebClient.Builder clientBuilder = (WebClient.Builder)object;
        clientBuilder.baseUrl(this.definition.getBaseUrl());
        Object object2 = this.getAppContext().getBean(ClientProperties.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getBean(...)");
        ClientProperties clientProperties = (ClientProperties)object2;
        ClientProperties.FilterDefinition filterDefinition = clientProperties.getFilter(this.definition.getName());
        clientBuilder.filters(arg_0 -> AbstractWebClientFactoryBean.getObject$lambda$0(this, filterDefinition, arg_0));
        this.getBuilderCustomizer().customize(this.definition, clientBuilder);
        this.getAppContext().getBeanProvider(WebClientBuilderCustomizer.class).orderedStream().forEach(arg_0 -> AbstractWebClientFactoryBean.getObject$lambda$1((Function1)new Function1<WebClientBuilderCustomizer, Unit>(this, clientBuilder){
            final /* synthetic */ AbstractWebClientFactoryBean this$0;
            final /* synthetic */ WebClient.Builder $clientBuilder;
            {
                this.this$0 = $receiver;
                this.$clientBuilder = $clientBuilder;
                super(1);
            }

            public final void invoke(WebClientBuilderCustomizer customizer) {
                customizer.customize(AbstractWebClientFactoryBean.access$getDefinition$p(this.this$0), this.$clientBuilder);
            }
        }, arg_0));
        WebClient webClient = clientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        return webClient;
    }

    private final void initFilters(ClientProperties.FilterDefinition $this$initFilters, List<ExchangeFilterFunction> filters) {
        ExchangeFilterFunction filter;
        Iterable $this$forEach$iv = $this$initFilters.getNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String filterName = (String)element$iv;
            boolean bl = false;
            Object object = this.getAppContext().getBean(filterName, ExchangeFilterFunction.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
            filter = (ExchangeFilterFunction)object;
            filters.add(filter);
        }
        $this$forEach$iv = $this$initFilters.getTypes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class filterType = (Class)element$iv;
            boolean bl = false;
            filter = (ExchangeFilterFunction)this.getAppContext().getBean(filterType);
            filters.add(filter);
        }
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.setAppContext(applicationContext);
    }

    private static final void getObject$lambda$0(AbstractWebClientFactoryBean this$0, ClientProperties.FilterDefinition $filterDefinition, List it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$filterDefinition, (String)"$filterDefinition");
        Intrinsics.checkNotNull((Object)it);
        this$0.initFilters($filterDefinition, it);
    }

    private static final void getObject$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ CoApiDefinition access$getDefinition$p(AbstractWebClientFactoryBean $this) {
        return $this.definition;
    }
}

