/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.coapi.spring;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.coapi.spring.ClientMode;
import me.ahoo.coapi.spring.CoApiDefinition;
import me.ahoo.coapi.spring.CoApiFactoryBean;
import me.ahoo.coapi.spring.client.reactive.WebClientFactoryBean;
import me.ahoo.coapi.spring.client.sync.RestClientFactoryBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/coapi/spring/CoApiRegistrar;", "", "registry", "Lorg/springframework/beans/factory/support/BeanDefinitionRegistry;", "clientMode", "Lme/ahoo/coapi/spring/ClientMode;", "<init>", "(Lorg/springframework/beans/factory/support/BeanDefinitionRegistry;Lme/ahoo/coapi/spring/ClientMode;)V", "register", "", "coApiDefinitions", "", "Lme/ahoo/coapi/spring/CoApiDefinition;", "coApiDefinition", "registerRestClient", "registerWebClient", "registerApiClient", "Companion", "coapi-spring"})
@SourceDebugExtension(value={"SMAP\nCoApiRegistrar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoApiRegistrar.kt\nme/ahoo/coapi/spring/CoApiRegistrar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1869#2,2:90\n*S KotlinDebug\n*F\n+ 1 CoApiRegistrar.kt\nme/ahoo/coapi/spring/CoApiRegistrar\n*L\n28#1:90,2\n*E\n"})
public final class CoApiRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BeanDefinitionRegistry registry;
    @NotNull
    private final ClientMode clientMode;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(CoApiRegistrar::log$lambda$7);

    public CoApiRegistrar(@NotNull BeanDefinitionRegistry registry, @NotNull ClientMode clientMode) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)((Object)clientMode), (String)"clientMode");
        this.registry = registry;
        this.clientMode = clientMode;
    }

    public final void register(@NotNull Set<CoApiDefinition> coApiDefinitions) {
        Intrinsics.checkNotNullParameter(coApiDefinitions, (String)"coApiDefinitions");
        Iterable $this$forEach$iv = coApiDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CoApiDefinition it = (CoApiDefinition)element$iv;
            boolean bl = false;
            this.register(it);
        }
    }

    public final void register(@NotNull CoApiDefinition coApiDefinition) {
        Intrinsics.checkNotNullParameter((Object)coApiDefinition, (String)"coApiDefinition");
        if (this.clientMode == ClientMode.SYNC) {
            this.registerRestClient(this.registry, coApiDefinition);
        } else {
            this.registerWebClient(this.registry, coApiDefinition);
        }
        this.registerApiClient(this.registry, coApiDefinition);
    }

    private final void registerRestClient(BeanDefinitionRegistry registry, CoApiDefinition coApiDefinition) {
        log.info(() -> CoApiRegistrar.registerRestClient$lambda$1(coApiDefinition));
        if (registry.containsBeanDefinition(coApiDefinition.getHttpClientBeanName())) {
            log.warn(() -> CoApiRegistrar.registerRestClient$lambda$2(coApiDefinition));
            return;
        }
        Class<RestClientFactoryBean> clientFactoryBeanClass = RestClientFactoryBean.class;
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clientFactoryBeanClass);
        Intrinsics.checkNotNullExpressionValue((Object)beanDefinitionBuilder, (String)"genericBeanDefinition(...)");
        BeanDefinitionBuilder beanDefinitionBuilder2 = beanDefinitionBuilder;
        beanDefinitionBuilder2.addConstructorArgValue((Object)coApiDefinition);
        registry.registerBeanDefinition(coApiDefinition.getHttpClientBeanName(), (BeanDefinition)beanDefinitionBuilder2.getBeanDefinition());
    }

    private final void registerWebClient(BeanDefinitionRegistry registry, CoApiDefinition coApiDefinition) {
        log.info(() -> CoApiRegistrar.registerWebClient$lambda$3(coApiDefinition));
        if (registry.containsBeanDefinition(coApiDefinition.getHttpClientBeanName())) {
            log.warn(() -> CoApiRegistrar.registerWebClient$lambda$4(coApiDefinition));
            return;
        }
        Class<WebClientFactoryBean> clientFactoryBeanClass = WebClientFactoryBean.class;
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clientFactoryBeanClass);
        Intrinsics.checkNotNullExpressionValue((Object)beanDefinitionBuilder, (String)"genericBeanDefinition(...)");
        BeanDefinitionBuilder beanDefinitionBuilder2 = beanDefinitionBuilder;
        beanDefinitionBuilder2.addConstructorArgValue((Object)coApiDefinition);
        registry.registerBeanDefinition(coApiDefinition.getHttpClientBeanName(), (BeanDefinition)beanDefinitionBuilder2.getBeanDefinition());
    }

    private final void registerApiClient(BeanDefinitionRegistry registry, CoApiDefinition coApiDefinition) {
        log.info(() -> CoApiRegistrar.registerApiClient$lambda$5(coApiDefinition));
        if (registry.containsBeanDefinition(coApiDefinition.getCoApiBeanName())) {
            log.warn(() -> CoApiRegistrar.registerApiClient$lambda$6(coApiDefinition));
            return;
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(CoApiFactoryBean.class);
        Intrinsics.checkNotNullExpressionValue((Object)beanDefinitionBuilder, (String)"genericBeanDefinition(...)");
        BeanDefinitionBuilder beanDefinitionBuilder2 = beanDefinitionBuilder;
        beanDefinitionBuilder2.addConstructorArgValue((Object)coApiDefinition);
        registry.registerBeanDefinition(coApiDefinition.getCoApiBeanName(), (BeanDefinition)beanDefinitionBuilder2.getBeanDefinition());
    }

    private static final Object registerRestClient$lambda$1(CoApiDefinition $coApiDefinition) {
        return "Register RestClient [" + $coApiDefinition.getHttpClientBeanName() + "].";
    }

    private static final Object registerRestClient$lambda$2(CoApiDefinition $coApiDefinition) {
        return "RestClient [" + $coApiDefinition.getHttpClientBeanName() + "] already exists - Ignore.";
    }

    private static final Object registerWebClient$lambda$3(CoApiDefinition $coApiDefinition) {
        return "Register WebClient [" + $coApiDefinition.getHttpClientBeanName() + "].";
    }

    private static final Object registerWebClient$lambda$4(CoApiDefinition $coApiDefinition) {
        return "WebClient [" + $coApiDefinition.getHttpClientBeanName() + "] already exists - Ignore.";
    }

    private static final Object registerApiClient$lambda$5(CoApiDefinition $coApiDefinition) {
        return "Register CoApi [" + $coApiDefinition.getCoApiBeanName() + "].";
    }

    private static final Object registerApiClient$lambda$6(CoApiDefinition $coApiDefinition) {
        return "CoApi [" + $coApiDefinition.getCoApiBeanName() + "] already exists - Ignore.";
    }

    private static final Unit log$lambda$7() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/coapi/spring/CoApiRegistrar$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "coapi-spring"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

