/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.coapi.spring.client.reactive;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.coapi.spring.CoApiDefinition;
import me.ahoo.coapi.spring.client.ClientProperties;
import me.ahoo.coapi.spring.client.IHttpClientFactoryBean;
import me.ahoo.coapi.spring.client.reactive.WebClientBuilderCustomizer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\u001a\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lme/ahoo/coapi/spring/client/reactive/AbstractWebClientFactoryBean;", "Lme/ahoo/coapi/spring/client/IHttpClientFactoryBean;", "Lorg/springframework/beans/factory/FactoryBean;", "Lorg/springframework/web/reactive/function/client/WebClient;", "Lorg/springframework/context/ApplicationContextAware;", "definition", "Lme/ahoo/coapi/spring/CoApiDefinition;", "<init>", "(Lme/ahoo/coapi/spring/CoApiDefinition;)V", "getDefinition", "()Lme/ahoo/coapi/spring/CoApiDefinition;", "appContext", "Lorg/springframework/context/ApplicationContext;", "getAppContext", "()Lorg/springframework/context/ApplicationContext;", "setAppContext", "(Lorg/springframework/context/ApplicationContext;)V", "builderCustomizer", "Lme/ahoo/coapi/spring/client/reactive/WebClientBuilderCustomizer;", "getBuilderCustomizer", "()Lme/ahoo/coapi/spring/client/reactive/WebClientBuilderCustomizer;", "getObjectType", "Ljava/lang/Class;", "getObject", "initFilters", "", "Lme/ahoo/coapi/spring/client/ClientProperties$FilterDefinition;", "filters", "", "Lorg/springframework/web/reactive/function/client/ExchangeFilterFunction;", "setApplicationContext", "applicationContext", "coapi-spring"})
@SourceDebugExtension(value={"SMAP\nAbstractWebClientFactoryBean.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractWebClientFactoryBean.kt\nme/ahoo/coapi/spring/client/reactive/AbstractWebClientFactoryBean\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1869#2,2:77\n1869#2,2:79\n*S KotlinDebug\n*F\n+ 1 AbstractWebClientFactoryBean.kt\nme/ahoo/coapi/spring/client/reactive/AbstractWebClientFactoryBean\n*L\n62#1:77,2\n66#1:79,2\n*E\n"})
public abstract class AbstractWebClientFactoryBean
implements IHttpClientFactoryBean,
FactoryBean<WebClient>,
ApplicationContextAware {
    @NotNull
    private final CoApiDefinition definition;
    public ApplicationContext appContext;
    @NotNull
    private final WebClientBuilderCustomizer builderCustomizer;

    public AbstractWebClientFactoryBean(@NotNull CoApiDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        this.definition = definition;
        this.builderCustomizer = WebClientBuilderCustomizer.NoOp.INSTANCE;
    }

    @Override
    @NotNull
    public CoApiDefinition getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public ApplicationContext getAppContext() {
        ApplicationContext applicationContext = this.appContext;
        if (applicationContext != null) {
            return applicationContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
        return null;
    }

    public void setAppContext(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"<set-?>");
        this.appContext = applicationContext;
    }

    @NotNull
    protected WebClientBuilderCustomizer getBuilderCustomizer() {
        return this.builderCustomizer;
    }

    @NotNull
    public Class<?> getObjectType() {
        return WebClient.class;
    }

    @NotNull
    public WebClient getObject() {
        Object object = this.getAppContext().getBean(WebClient.Builder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
        WebClient.Builder clientBuilder = (WebClient.Builder)object;
        Object object2 = this.getAppContext().getBean(ClientProperties.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getBean(...)");
        ClientProperties clientProperties = (ClientProperties)object2;
        String baseUrl = this.getBaseUrl();
        clientBuilder.baseUrl(baseUrl);
        ClientProperties.FilterDefinition filterDefinition = clientProperties.getFilter(this.getDefinition().getName());
        clientBuilder.filters(arg_0 -> AbstractWebClientFactoryBean.getObject$lambda$0(this, filterDefinition, arg_0));
        this.getBuilderCustomizer().customize(this.getDefinition(), clientBuilder);
        this.getAppContext().getBeanProvider(WebClientBuilderCustomizer.class).orderedStream().forEach(arg_0 -> AbstractWebClientFactoryBean.getObject$lambda$2(arg_0 -> AbstractWebClientFactoryBean.getObject$lambda$1(this, clientBuilder, arg_0), arg_0));
        WebClient webClient = clientBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        return webClient;
    }

    private final void initFilters(ClientProperties.FilterDefinition $this$initFilters, List<ExchangeFilterFunction> filters) {
        ExchangeFilterFunction filter;
        Iterable $this$forEach$iv = $this$initFilters.getNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String filterName = (String)element$iv;
            boolean bl = false;
            Object object = this.getAppContext().getBean(filterName, ExchangeFilterFunction.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
            filter = (ExchangeFilterFunction)object;
            filters.add(filter);
        }
        $this$forEach$iv = $this$initFilters.getTypes();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class filterType = (Class)element$iv;
            boolean bl = false;
            Object object = this.getAppContext().getBean(filterType);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
            filter = (ExchangeFilterFunction)object;
            filters.add(filter);
        }
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.setAppContext(applicationContext);
    }

    @Override
    @NotNull
    public String getBaseUrl() {
        return IHttpClientFactoryBean.super.getBaseUrl();
    }

    @Override
    public boolean loadBalanced() {
        return IHttpClientFactoryBean.super.loadBalanced();
    }

    private static final void getObject$lambda$0(AbstractWebClientFactoryBean this$0, ClientProperties.FilterDefinition $filterDefinition, List it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.initFilters($filterDefinition, it);
    }

    private static final Unit getObject$lambda$1(AbstractWebClientFactoryBean this$0, WebClient.Builder $clientBuilder, WebClientBuilderCustomizer customizer) {
        customizer.customize(this$0.getDefinition(), $clientBuilder);
        return Unit.INSTANCE;
    }

    private static final void getObject$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

