/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.coapi.spring.client.reactive.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lme/ahoo/coapi/spring/client/reactive/auth/ExpirableToken;", "", "token", "", "expireAt", "", "<init>", "(Ljava/lang/String;J)V", "getToken", "()Ljava/lang/String;", "getExpireAt", "()J", "isExpired", "", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "coapi-spring"})
public final class ExpirableToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String token;
    private final long expireAt;
    @NotNull
    private static final JWT jwtParser = new JWT();

    public ExpirableToken(@NotNull String token, long expireAt) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.token = token;
        this.expireAt = expireAt;
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    public final long getExpireAt() {
        return this.expireAt;
    }

    public final boolean isExpired() {
        return System.currentTimeMillis() > this.expireAt;
    }

    @NotNull
    public final String component1() {
        return this.token;
    }

    public final long component2() {
        return this.expireAt;
    }

    @NotNull
    public final ExpirableToken copy(@NotNull String token, long expireAt) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return new ExpirableToken(token, expireAt);
    }

    public static /* synthetic */ ExpirableToken copy$default(ExpirableToken expirableToken, String string, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = expirableToken.token;
        }
        if ((n & 2) != 0) {
            l = expirableToken.expireAt;
        }
        return expirableToken.copy(string, l);
    }

    @NotNull
    public String toString() {
        return "ExpirableToken(token=" + this.token + ", expireAt=" + this.expireAt + ")";
    }

    public int hashCode() {
        int result = this.token.hashCode();
        result = result * 31 + Long.hashCode(this.expireAt);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExpirableToken)) {
            return false;
        }
        ExpirableToken expirableToken = (ExpirableToken)other;
        if (!Intrinsics.areEqual((Object)this.token, (Object)expirableToken.token)) {
            return false;
        }
        return this.expireAt == expirableToken.expireAt;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0006\u001a\u00020\u0007*\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lme/ahoo/coapi/spring/client/reactive/auth/ExpirableToken$Companion;", "", "<init>", "()V", "jwtParser", "Lcom/auth0/jwt/JWT;", "jwtToExpirableToken", "Lme/ahoo/coapi/spring/client/reactive/auth/ExpirableToken;", "", "coapi-spring"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExpirableToken jwtToExpirableToken(@NotNull String $this$jwtToExpirableToken) {
            Intrinsics.checkNotNullParameter((Object)$this$jwtToExpirableToken, (String)"<this>");
            DecodedJWT decodedJWT = jwtParser.decodeJwt($this$jwtToExpirableToken);
            Date date = decodedJWT.getExpiresAt();
            if (date == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Date expiresAt = date;
            return new ExpirableToken($this$jwtToExpirableToken, expiresAt.getTime());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

