/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.coapi.spring;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.coapi.api.CoApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.env.Environment;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J5\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0013\u0010\fR\u001b\u0010\u0016\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0017\u0010\f\u00a8\u0006$"}, d2={"Lme/ahoo/coapi/spring/CoApiDefinition;", "", "name", "", "apiType", "Ljava/lang/Class;", "baseUrl", "loadBalanced", "", "<init>", "(Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "getApiType", "()Ljava/lang/Class;", "getBaseUrl", "getLoadBalanced", "()Z", "httpClientBeanName", "getHttpClientBeanName", "httpClientBeanName$delegate", "Lkotlin/Lazy;", "coApiBeanName", "getCoApiBeanName", "coApiBeanName$delegate", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "coapi-spring"})
public final class CoApiDefinition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Class<?> apiType;
    @NotNull
    private final String baseUrl;
    private final boolean loadBalanced;
    @NotNull
    private final Lazy httpClientBeanName$delegate;
    @NotNull
    private final Lazy coApiBeanName$delegate;
    @NotNull
    private static final String CLIENT_BEAN_NAME_SUFFIX = ".HttpClient";
    @NotNull
    private static final String COAPI_BEAN_NAME_SUFFIX = ".CoApi";
    @NotNull
    private static final String LB_SCHEME_PREFIX = "http://";

    public CoApiDefinition(@NotNull String name, @NotNull Class<?> apiType, @NotNull String baseUrl, boolean loadBalanced) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(apiType, (String)"apiType");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.name = name;
        this.apiType = apiType;
        this.baseUrl = baseUrl;
        this.loadBalanced = loadBalanced;
        this.httpClientBeanName$delegate = LazyKt.lazy(() -> CoApiDefinition.httpClientBeanName_delegate$lambda$0(this));
        this.coApiBeanName$delegate = LazyKt.lazy(() -> CoApiDefinition.coApiBeanName_delegate$lambda$1(this));
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Class<?> getApiType() {
        return this.apiType;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    public final boolean getLoadBalanced() {
        return this.loadBalanced;
    }

    @NotNull
    public final String getHttpClientBeanName() {
        Lazy lazy = this.httpClientBeanName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getCoApiBeanName() {
        Lazy lazy = this.coApiBeanName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Class<?> component2() {
        return this.apiType;
    }

    @NotNull
    public final String component3() {
        return this.baseUrl;
    }

    public final boolean component4() {
        return this.loadBalanced;
    }

    @NotNull
    public final CoApiDefinition copy(@NotNull String name, @NotNull Class<?> apiType, @NotNull String baseUrl, boolean loadBalanced) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(apiType, (String)"apiType");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        return new CoApiDefinition(name, apiType, baseUrl, loadBalanced);
    }

    public static /* synthetic */ CoApiDefinition copy$default(CoApiDefinition coApiDefinition, String string, Class clazz, String string2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = coApiDefinition.name;
        }
        if ((n & 2) != 0) {
            clazz = coApiDefinition.apiType;
        }
        if ((n & 4) != 0) {
            string2 = coApiDefinition.baseUrl;
        }
        if ((n & 8) != 0) {
            bl = coApiDefinition.loadBalanced;
        }
        return coApiDefinition.copy(string, clazz, string2, bl);
    }

    @NotNull
    public String toString() {
        return "CoApiDefinition(name=" + this.name + ", apiType=" + this.apiType + ", baseUrl=" + this.baseUrl + ", loadBalanced=" + this.loadBalanced + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.apiType.hashCode();
        result = result * 31 + this.baseUrl.hashCode();
        result = result * 31 + Boolean.hashCode(this.loadBalanced);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CoApiDefinition)) {
            return false;
        }
        CoApiDefinition coApiDefinition = (CoApiDefinition)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)coApiDefinition.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.apiType, coApiDefinition.apiType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.baseUrl, (Object)coApiDefinition.baseUrl)) {
            return false;
        }
        return this.loadBalanced == coApiDefinition.loadBalanced;
    }

    private static final String httpClientBeanName_delegate$lambda$0(CoApiDefinition this$0) {
        return this$0.name + CLIENT_BEAN_NAME_SUFFIX;
    }

    private static final String coApiBeanName_delegate$lambda$1(CoApiDefinition this$0) {
        return this$0.name + COAPI_BEAN_NAME_SUFFIX;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/coapi/spring/CoApiDefinition$Companion;", "", "<init>", "()V", "CLIENT_BEAN_NAME_SUFFIX", "", "COAPI_BEAN_NAME_SUFFIX", "LB_SCHEME_PREFIX", "toCoApiDefinition", "Lme/ahoo/coapi/spring/CoApiDefinition;", "Ljava/lang/Class;", "environment", "Lorg/springframework/core/env/Environment;", "resolveBaseUrl", "Lme/ahoo/coapi/api/CoApi;", "resolveClientName", "coApi", "resolveLoadBalanced", "", "coapi-spring"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CoApiDefinition toCoApiDefinition(@NotNull Class<?> $this$toCoApiDefinition, @NotNull Environment environment) {
            Intrinsics.checkNotNullParameter($this$toCoApiDefinition, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            CoApi coApi = $this$toCoApiDefinition.getAnnotation(CoApi.class);
            if (coApi == null) {
                throw new IllegalArgumentException("The class must be annotated by @CoApi.");
            }
            CoApi coApi2 = coApi;
            String baseUrl = this.resolveBaseUrl(coApi2, environment);
            return new CoApiDefinition(this.resolveClientName($this$toCoApiDefinition, coApi2), $this$toCoApiDefinition, baseUrl, this.resolveLoadBalanced(coApi2));
        }

        private final String resolveBaseUrl(CoApi $this$resolveBaseUrl, Environment environment) {
            if (!StringsKt.isBlank((CharSequence)$this$resolveBaseUrl.baseUrl())) {
                String string = environment.resolvePlaceholders($this$resolveBaseUrl.baseUrl());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resolvePlaceholders(...)");
                return string;
            }
            if (!StringsKt.isBlank((CharSequence)$this$resolveBaseUrl.serviceId())) {
                return CoApiDefinition.LB_SCHEME_PREFIX + environment.resolvePlaceholders($this$resolveBaseUrl.serviceId());
            }
            return "";
        }

        private final String resolveClientName(Class<?> $this$resolveClientName, CoApi coApi) {
            if (!StringsKt.isBlank((CharSequence)coApi.name())) {
                return coApi.name();
            }
            String string = $this$resolveClientName.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            return string;
        }

        private final boolean resolveLoadBalanced(CoApi $this$resolveLoadBalanced) {
            if (!StringsKt.isBlank((CharSequence)$this$resolveLoadBalanced.baseUrl())) {
                return false;
            }
            return !StringsKt.isBlank((CharSequence)$this$resolveLoadBalanced.serviceId());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

