/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import me.ahoo.cosec.api.tenant.TenantCapable;
import me.ahoo.cosec.api.token.CompositeToken;
import me.ahoo.cosec.jwt.JwtTokenConverter;
import me.ahoo.cosec.token.SimpleCompositeToken;
import me.ahoo.cosec.token.TokenConverter;
import me.ahoo.cosid.IdGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/ahoo/cosec/jwt/JwtTokenConverter;", "Lme/ahoo/cosec/token/TokenConverter;", "idGenerator", "Lme/ahoo/cosid/IdGenerator;", "algorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "accessTokenValidity", "Ljava/time/Duration;", "refreshTokenValidity", "(Lme/ahoo/cosid/IdGenerator;Lcom/auth0/jwt/algorithms/Algorithm;Ljava/time/Duration;Ljava/time/Duration;)V", "asToken", "Lme/ahoo/cosec/api/token/CompositeToken;", "principal", "Lme/ahoo/cosec/api/principal/CoSecPrincipal;", "cosec-jwt"})
public final class JwtTokenConverter
implements TokenConverter {
    @NotNull
    private final IdGenerator idGenerator;
    @NotNull
    private final Algorithm algorithm;
    @NotNull
    private final Duration accessTokenValidity;
    @NotNull
    private final Duration refreshTokenValidity;

    public JwtTokenConverter(@NotNull IdGenerator idGenerator, @NotNull Algorithm algorithm, @NotNull Duration accessTokenValidity, @NotNull Duration refreshTokenValidity) {
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)accessTokenValidity, (String)"accessTokenValidity");
        Intrinsics.checkNotNullParameter((Object)refreshTokenValidity, (String)"refreshTokenValidity");
        this.idGenerator = idGenerator;
        this.algorithm = algorithm;
        this.accessTokenValidity = accessTokenValidity;
        this.refreshTokenValidity = refreshTokenValidity;
    }

    public /* synthetic */ JwtTokenConverter(IdGenerator idGenerator, Algorithm algorithm, Duration duration, Duration duration2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Duration duration3 = Duration.ofMinutes(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(10)");
            duration = duration3;
        }
        if ((n & 8) != 0) {
            Duration duration4 = Duration.ofDays(7L);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofDays(7)");
            duration2 = duration4;
        }
        this(idGenerator, algorithm, duration, duration2);
    }

    @NotNull
    public CompositeToken asToken(@NotNull CoSecPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        String string = this.idGenerator.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"idGenerator.generateAsString()");
        String accessTokenId = string;
        Date now = new Date();
        Date accessTokenExp = new Date(System.currentTimeMillis() + this.accessTokenValidity.toMillis());
        Map payloadClaims2 = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence((Map)principal.getAttributes()), (Function1)asToken.payloadClaims.1.INSTANCE), (Function1)asToken.payloadClaims.2.INSTANCE));
        JWTCreator.Builder accessTokenBuilder = JWT.create().withJWTId(accessTokenId).withSubject(principal.getId()).withClaim("policies", CollectionsKt.toList((Iterable)principal.getPolicies())).withClaim("roles", CollectionsKt.toList((Iterable)principal.getRoles())).withPayload(payloadClaims2).withIssuedAt(now).withExpiresAt(accessTokenExp);
        if (principal instanceof TenantCapable) {
            TenantCapable tenantCapable = (TenantCapable)principal;
            accessTokenBuilder.withClaim("tenantId", tenantCapable.getTenant().getTenantId());
        }
        String accessToken = accessTokenBuilder.sign(this.algorithm);
        String string2 = this.idGenerator.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"idGenerator.generateAsString()");
        String refreshTokenId = string2;
        Date refreshTokenExp = new Date(System.currentTimeMillis() + this.refreshTokenValidity.toMillis());
        String refreshToken = JWT.create().withJWTId(refreshTokenId).withSubject(accessTokenId).withIssuedAt(now).withExpiresAt(refreshTokenExp).sign(this.algorithm);
        Intrinsics.checkNotNullExpressionValue((Object)accessToken, (String)"accessToken");
        Intrinsics.checkNotNullExpressionValue((Object)refreshToken, (String)"refreshToken");
        return (CompositeToken)new SimpleCompositeToken(accessToken, refreshToken);
    }
}

