/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosec.api.token.AccessToken;
import me.ahoo.cosec.api.token.CompositeToken;
import me.ahoo.cosec.api.token.TokenPrincipal;
import me.ahoo.cosec.jwt.Jwts;
import me.ahoo.cosec.token.TokenExpiredException;
import me.ahoo.cosec.token.TokenVerificationException;
import me.ahoo.cosec.token.TokenVerifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0082\bJ\u001f\u0010\r\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/cosec/jwt/JwtTokenVerifier;", "Lme/ahoo/cosec/token/TokenVerifier;", "algorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "(Lcom/auth0/jwt/algorithms/Algorithm;)V", "jwtVerifier", "Lcom/auth0/jwt/interfaces/JWTVerifier;", "refresh", "T", "Lme/ahoo/cosec/api/token/TokenPrincipal;", "token", "Lme/ahoo/cosec/api/token/CompositeToken;", "(Lme/ahoo/cosec/api/token/CompositeToken;)Lme/ahoo/cosec/api/token/TokenPrincipal;", "verify", "Lcom/auth0/jwt/interfaces/DecodedJWT;", "accessToken", "", "Lme/ahoo/cosec/api/token/AccessToken;", "(Lme/ahoo/cosec/api/token/AccessToken;)Lme/ahoo/cosec/api/token/TokenPrincipal;", "cosec-jwt"})
@SourceDebugExtension(value={"SMAP\nJwtTokenVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtTokenVerifier.kt\nme/ahoo/cosec/jwt/JwtTokenVerifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n30#1,6:52\n30#1,6:58\n1#2:64\n*S KotlinDebug\n*F\n+ 1 JwtTokenVerifier.kt\nme/ahoo/cosec/jwt/JwtTokenVerifier\n*L\n40#1:52,6\n45#1:58,6\n*E\n"})
public final class JwtTokenVerifier
implements TokenVerifier {
    @NotNull
    private final com.auth0.jwt.interfaces.JWTVerifier jwtVerifier;

    public JwtTokenVerifier(@NotNull Algorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        JWTVerifier jWTVerifier = JWT.require((Algorithm)algorithm).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTVerifier, (String)"require(algorithm).build()");
        this.jwtVerifier = (com.auth0.jwt.interfaces.JWTVerifier)jWTVerifier;
    }

    private final DecodedJWT verify(String accessToken) {
        boolean $i$f$verify = false;
        try {
            DecodedJWT decodedJWT = this.jwtVerifier.verify(accessToken);
            Intrinsics.checkNotNullExpressionValue((Object)decodedJWT, (String)"jwtVerifier.verify(accessToken)");
            return decodedJWT;
        }
        catch (com.auth0.jwt.exceptions.TokenExpiredException tokenExpiredException) {
            String string = tokenExpiredException.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new TokenExpiredException(string, (Throwable)tokenExpiredException);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new TokenVerificationException(string, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends TokenPrincipal> T verify(@NotNull AccessToken accessToken) {
        DecodedJWT decodedJWT;
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        JwtTokenVerifier jwtTokenVerifier = this;
        String accessToken$iv = accessToken.getAccessToken();
        boolean $i$f$verify = false;
        try {
            void this_$iv;
            DecodedJWT decodedJWT2 = this_$iv.jwtVerifier.verify(accessToken$iv);
            decodedJWT = decodedJWT2;
            Intrinsics.checkNotNullExpressionValue((Object)decodedJWT2, (String)"jwtVerifier.verify(accessToken)");
        }
        catch (com.auth0.jwt.exceptions.TokenExpiredException tokenExpiredException$iv) {
            String string = tokenExpiredException$iv.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new TokenExpiredException(string, (Throwable)tokenExpiredException$iv);
        }
        catch (Exception exception$iv) {
            String string = exception$iv.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new TokenVerificationException(string, (Throwable)exception$iv);
        }
        DecodedJWT decodedAccessToken = decodedJWT;
        return Jwts.INSTANCE.asPrincipal(decodedAccessToken);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T extends TokenPrincipal> T refresh(@NotNull CompositeToken token) {
        DecodedJWT decodedJWT;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        JwtTokenVerifier jwtTokenVerifier = this;
        String accessToken$iv = token.getRefreshToken();
        boolean $i$f$verify = false;
        try {
            void this_$iv;
            DecodedJWT decodedJWT2 = this_$iv.jwtVerifier.verify(accessToken$iv);
            decodedJWT = decodedJWT2;
            Intrinsics.checkNotNullExpressionValue((Object)decodedJWT2, (String)"jwtVerifier.verify(accessToken)");
        }
        catch (com.auth0.jwt.exceptions.TokenExpiredException tokenExpiredException$iv) {
            String string = tokenExpiredException$iv.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new TokenExpiredException(string, (Throwable)tokenExpiredException$iv);
        }
        catch (Exception exception$iv) {
            String string = exception$iv.getMessage();
            Intrinsics.checkNotNull((Object)string);
            throw new TokenVerificationException(string, (Throwable)exception$iv);
        }
        DecodedJWT decodedRefreshToken = decodedJWT;
        DecodedJWT decodedAccessToken = Jwts.INSTANCE.decode(token.getAccessToken());
        if (!Intrinsics.areEqual((Object)decodedRefreshToken.getSubject(), (Object)decodedAccessToken.getId())) {
            boolean bl = false;
            String string = "Illegal refreshToken.";
            throw new IllegalArgumentException(string.toString());
        }
        return Jwts.INSTANCE.asPrincipal(decodedAccessToken);
    }
}

