/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import me.ahoo.cosec.api.principal.AttributeValue;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import me.ahoo.cosec.api.tenant.Tenant;
import me.ahoo.cosec.api.token.TokenPrincipal;
import me.ahoo.cosec.jwt.Jwts;
import me.ahoo.cosec.principal.ObjectAttributeValue;
import me.ahoo.cosec.principal.SimplePrincipal;
import me.ahoo.cosec.tenant.SimpleTenant;
import me.ahoo.cosec.token.SimpleAccessToken;
import me.ahoo.cosec.token.SimpleTokenPrincipal;
import me.ahoo.cosec.token.SimpleTokenTenantPrincipal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001f\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lme/ahoo/cosec/jwt/Jwts;", "", "()V", "AUTHORIZATION_KEY", "", "TOKEN_PREFIX", "jwtParser", "Lcom/auth0/jwt/JWT;", "asPrincipal", "T", "Lme/ahoo/cosec/api/token/TokenPrincipal;", "decodedAccessToken", "Lcom/auth0/jwt/interfaces/DecodedJWT;", "(Lcom/auth0/jwt/interfaces/DecodedJWT;)Lme/ahoo/cosec/api/token/TokenPrincipal;", "accessToken", "(Ljava/lang/String;)Lme/ahoo/cosec/api/token/TokenPrincipal;", "decode", "token", "isRegisteredClaim", "", "key", "parseAccessToken", "Lme/ahoo/cosec/token/SimpleAccessToken;", "authorization", "cosec-jwt"})
@SourceDebugExtension(value={"SMAP\nJwts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jwts.kt\nme/ahoo/cosec/jwt/Jwts\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,104:1\n689#2:105\n722#2,4:106\n*S KotlinDebug\n*F\n+ 1 Jwts.kt\nme/ahoo/cosec/jwt/Jwts\n*L\n73#1:105\n73#1:106,4\n*E\n"})
public final class Jwts {
    @NotNull
    public static final Jwts INSTANCE = new Jwts();
    @NotNull
    public static final String AUTHORIZATION_KEY = "authorization";
    @NotNull
    public static final String TOKEN_PREFIX = "Bearer ";
    @NotNull
    private static final JWT jwtParser = new JWT();

    private Jwts() {
    }

    public final boolean isRegisteredClaim(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Intrinsics.areEqual((Object)"iss", (Object)key) || Intrinsics.areEqual((Object)"sub", (Object)key) || Intrinsics.areEqual((Object)"exp", (Object)key) || Intrinsics.areEqual((Object)"nbf", (Object)key) || Intrinsics.areEqual((Object)"iat", (Object)key) || Intrinsics.areEqual((Object)"jti", (Object)key) || Intrinsics.areEqual((Object)"aud", (Object)key) || Intrinsics.areEqual((Object)"tenantId", (Object)key) || Intrinsics.areEqual((Object)"policies", (Object)key) || Intrinsics.areEqual((Object)"roles", (Object)key);
    }

    @JvmStatic
    @Nullable
    public static final SimpleAccessToken parseAccessToken(@Nullable String authorization) {
        String string = authorization;
        if (!(string != null ? StringsKt.startsWith$default((String)string, (String)TOKEN_PREFIX, (boolean)false, (int)2, null) : false)) {
            return null;
        }
        String string2 = authorization.substring(7);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        String accessToken = string2;
        return new SimpleAccessToken(accessToken);
    }

    @NotNull
    public final DecodedJWT decode(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        DecodedJWT decodedJWT = jwtParser.decodeJwt(token);
        Intrinsics.checkNotNullExpressionValue((Object)decodedJWT, (String)"jwtParser.decodeJwt(token)");
        return decodedJWT;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends TokenPrincipal> T asPrincipal(@NotNull DecodedJWT decodedAccessToken) {
        Set set;
        Set set2;
        Object object;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)decodedAccessToken, (String)"decodedAccessToken");
        String accessTokenId = decodedAccessToken.getId();
        String principalId = decodedAccessToken.getSubject();
        Map map = decodedAccessToken.getClaims();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"decodedAccessToken\n            .claims");
        Sequence sequence = SequencesKt.filter((Sequence)MapsKt.asSequence((Map)map), (Function1)asPrincipal.attributes.1.INSTANCE);
        boolean $i$f$associateBy = false;
        void var7_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            object = (Map.Entry)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            String string = (String)it.getKey();
            boolean bl2 = false;
            AttributeValue attributeValue = ObjectAttributeValue.Companion.asAttributeValue((Object)((Claim)it.getValue()).asString());
            map2.put(string, attributeValue);
        }
        Map attributes2 = destination$iv$iv;
        Claim policyClaim = decodedAccessToken.getClaim("policies");
        if (policyClaim.isMissing()) {
            set2 = SetsKt.emptySet();
        } else {
            List list = policyClaim.asList(String.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"policyClaim.asList(String::class.java)");
            set2 = CollectionsKt.toSet((Iterable)list);
        }
        Set policies = set2;
        Claim rolesClaim = decodedAccessToken.getClaim("roles");
        if (rolesClaim.isMissing()) {
            set = SetsKt.emptySet();
        } else {
            List list = rolesClaim.asList(String.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"rolesClaim.asList(String::class.java)");
            set = CollectionsKt.toSet((Iterable)list);
        }
        Set roles = set;
        Intrinsics.checkNotNullExpressionValue((Object)principalId, (String)"principalId");
        SimplePrincipal principal = new SimplePrincipal(principalId, policies, roles, attributes2);
        String tenantId = decodedAccessToken.getClaim("tenantId").asString();
        Intrinsics.checkNotNullExpressionValue((Object)accessTokenId, (String)"accessTokenId");
        SimpleTokenPrincipal tokenPrincipal = new SimpleTokenPrincipal(accessTokenId, (CoSecPrincipal)principal);
        object = tenantId;
        if (object == null || object.length() == 0) {
            return (T)((TokenPrincipal)tokenPrincipal);
        }
        TokenPrincipal tokenPrincipal2 = (TokenPrincipal)tokenPrincipal;
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"tenantId");
        return (T)((TokenPrincipal)new SimpleTokenTenantPrincipal(tokenPrincipal2, (Tenant)new SimpleTenant(tenantId)));
    }

    @JvmStatic
    @NotNull
    public static final <T extends TokenPrincipal> T asPrincipal(@NotNull String accessToken) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        DecodedJWT decodedAccessToken = INSTANCE.decode(accessToken);
        return INSTANCE.asPrincipal(decodedAccessToken);
    }
}

