/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.authentication.social;

import java.lang.reflect.Constructor;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.social.DirectSocialUserPrincipalConverter;
import me.ahoo.cosec.social.SocialAuthentication;
import me.ahoo.cosec.social.SocialAuthenticationProvider;
import me.ahoo.cosec.social.SocialProviderManager;
import me.ahoo.cosec.social.SocialUser;
import me.ahoo.cosec.social.SocialUserPrincipalConverter;
import me.ahoo.cosec.social.justauth.JustAuthProvider;
import me.ahoo.cosec.social.justauth.RedisAuthStateCache;
import me.ahoo.cosec.spring.boot.starter.ConditionalOnCoSecEnabled;
import me.ahoo.cosec.spring.boot.starter.authentication.ConditionalOnAuthenticationEnabled;
import me.ahoo.cosec.spring.boot.starter.authentication.social.ConditionalOnSocialAuthenticationEnabled;
import me.ahoo.cosec.spring.boot.starter.authentication.social.SocialAuthenticationProperties;
import me.ahoo.cosid.IdGenerator;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.request.AuthRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.StringRedisTemplate;

@AutoConfiguration
@ConditionalOnCoSecEnabled
@ConditionalOnAuthenticationEnabled
@ConditionalOnSocialAuthenticationEnabled
@ConditionalOnClass(value={SocialUser.class})
@EnableConfigurationProperties(value={SocialAuthenticationProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/cosec/spring/boot/starter/authentication/social/CoSecSocialAuthenticationAutoConfiguration;", "", "socialAuthenticationProperties", "Lme/ahoo/cosec/spring/boot/starter/authentication/social/SocialAuthenticationProperties;", "(Lme/ahoo/cosec/spring/boot/starter/authentication/social/SocialAuthenticationProperties;)V", "authStateCache", "Lme/zhyd/oauth/cache/AuthStateCache;", "stringRedisTemplate", "Lorg/springframework/data/redis/core/StringRedisTemplate;", "socialAuthentication", "Lme/ahoo/cosec/social/SocialAuthentication;", "principalConverter", "Lme/ahoo/cosec/social/SocialUserPrincipalConverter;", "socialProviderManager", "Lme/ahoo/cosec/social/SocialProviderManager;", "idGenerator", "Lme/ahoo/cosid/IdGenerator;", "socialUserPrincipalConverter", "cosec-spring-boot-starter"})
public class CoSecSocialAuthenticationAutoConfiguration {
    @NotNull
    private final SocialAuthenticationProperties socialAuthenticationProperties;

    public CoSecSocialAuthenticationAutoConfiguration(@NotNull SocialAuthenticationProperties socialAuthenticationProperties) {
        Intrinsics.checkNotNullParameter((Object)socialAuthenticationProperties, (String)"socialAuthenticationProperties");
        this.socialAuthenticationProperties = socialAuthenticationProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public AuthStateCache authStateCache(@NotNull StringRedisTemplate stringRedisTemplate) {
        Intrinsics.checkNotNullParameter((Object)stringRedisTemplate, (String)"stringRedisTemplate");
        return (AuthStateCache)new RedisAuthStateCache(stringRedisTemplate, null, 2, null);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SocialProviderManager socialProviderManager(@NotNull AuthStateCache authStateCache, @NotNull IdGenerator idGenerator) {
        Intrinsics.checkNotNullParameter((Object)authStateCache, (String)"authStateCache");
        Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
        for (Map.Entry<String, SocialAuthenticationProperties.Provider> entry : this.socialAuthenticationProperties.getRegistration().entrySet()) {
            Constructor authRequestCtor;
            Class authRequestClass;
            String key = entry.getKey();
            SocialAuthenticationProperties.Provider provider = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)provider.getType().getTargetClass(), (String)"getTargetClass(...)");
            Object[] objectArray = new Class[]{AuthConfig.class, AuthStateCache.class};
            Intrinsics.checkNotNullExpressionValue(authRequestClass.getConstructor((Class<?>[])objectArray), (String)"getConstructor(...)");
            objectArray = new Object[]{provider, authStateCache};
            AuthRequest authRequest = (AuthRequest)BeanUtils.instantiateClass(authRequestCtor, (Object[])objectArray);
            SocialAuthenticationProvider authProvider = (SocialAuthenticationProvider)new JustAuthProvider(key, authRequest, idGenerator);
            SocialProviderManager.INSTANCE.register(authProvider);
        }
        return SocialProviderManager.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SocialUserPrincipalConverter socialUserPrincipalConverter() {
        return (SocialUserPrincipalConverter)DirectSocialUserPrincipalConverter.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public SocialAuthentication socialAuthentication(@NotNull SocialUserPrincipalConverter principalConverter) {
        Intrinsics.checkNotNullParameter((Object)principalConverter, (String)"principalConverter");
        return new SocialAuthentication(principalConverter);
    }
}

