/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.spring.boot.starter.jwt;

import com.auth0.jwt.algorithms.Algorithm;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosec.authentication.CompositeAuthentication;
import me.ahoo.cosec.jwt.JwtTokenConverter;
import me.ahoo.cosec.jwt.JwtTokenVerifier;
import me.ahoo.cosec.spring.boot.starter.ConditionalOnCoSecEnabled;
import me.ahoo.cosec.spring.boot.starter.authentication.ConditionalOnAuthenticationEnabled;
import me.ahoo.cosec.spring.boot.starter.jwt.ConditionalOnJwtEnabled;
import me.ahoo.cosec.spring.boot.starter.jwt.JwtProperties;
import me.ahoo.cosec.token.TokenCompositeAuthentication;
import me.ahoo.cosec.token.TokenConverter;
import me.ahoo.cosec.token.TokenVerifier;
import me.ahoo.cosid.IdGenerator;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@ConditionalOnCoSecEnabled
@ConditionalOnJwtEnabled
@ConditionalOnClass(value={JwtTokenConverter.class})
@EnableConfigurationProperties(value={JwtProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\u000b"}, d2={"Lme/ahoo/cosec/spring/boot/starter/jwt/CoSecJwtAutoConfiguration;", "", "()V", "cosecJwtTokenVerifier", "Lme/ahoo/cosec/token/TokenVerifier;", "algorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "cosecTokenAlgorithm", "jwtProperties", "Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties;", "OnAuthentication", "cosec-spring-boot-starter"})
public class CoSecJwtAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public Algorithm cosecTokenAlgorithm(@NotNull JwtProperties jwtProperties) {
        Algorithm algorithm;
        Intrinsics.checkNotNullParameter((Object)jwtProperties, (String)"jwtProperties");
        switch (WhenMappings.$EnumSwitchMapping$0[jwtProperties.getAlgorithm().ordinal()]) {
            case 1: {
                Algorithm algorithm2 = Algorithm.HMAC256((String)jwtProperties.getSecret());
                algorithm = algorithm2;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm2, (String)"HMAC256(...)");
                break;
            }
            case 2: {
                Algorithm algorithm3 = Algorithm.HMAC384((String)jwtProperties.getSecret());
                algorithm = algorithm3;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm3, (String)"HMAC384(...)");
                break;
            }
            case 3: {
                Algorithm algorithm4 = Algorithm.HMAC512((String)jwtProperties.getSecret());
                algorithm = algorithm4;
                Intrinsics.checkNotNullExpressionValue((Object)algorithm4, (String)"HMAC512(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return algorithm;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public TokenVerifier cosecJwtTokenVerifier(@NotNull Algorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        return (TokenVerifier)new JwtTokenVerifier(algorithm);
    }

    @Configuration
    @ConditionalOnAuthenticationEnabled
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0017\u00a8\u0006\u0010"}, d2={"Lme/ahoo/cosec/spring/boot/starter/jwt/CoSecJwtAutoConfiguration$OnAuthentication;", "", "()V", "cosecTokenConverter", "Lme/ahoo/cosec/token/TokenConverter;", "idGenerator", "Lme/ahoo/cosid/IdGenerator;", "algorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "jwtProperties", "Lme/ahoo/cosec/spring/boot/starter/jwt/JwtProperties;", "tokenCompositeAuthentication", "Lme/ahoo/cosec/token/TokenCompositeAuthentication;", "compositeAuthentication", "Lme/ahoo/cosec/authentication/CompositeAuthentication;", "tokenConverter", "cosec-spring-boot-starter"})
    public static class OnAuthentication {
        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public TokenConverter cosecTokenConverter(@NotNull IdGenerator idGenerator, @NotNull Algorithm algorithm, @NotNull JwtProperties jwtProperties) {
            Intrinsics.checkNotNullParameter((Object)idGenerator, (String)"idGenerator");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Intrinsics.checkNotNullParameter((Object)jwtProperties, (String)"jwtProperties");
            return (TokenConverter)new JwtTokenConverter(idGenerator, algorithm, jwtProperties.getTokenValidity().getAccess(), jwtProperties.getTokenValidity().getRefresh());
        }

        @Bean
        @ConditionalOnBean(value={CompositeAuthentication.class})
        @NotNull
        public TokenCompositeAuthentication tokenCompositeAuthentication(@NotNull CompositeAuthentication compositeAuthentication, @NotNull TokenConverter tokenConverter) {
            Intrinsics.checkNotNullParameter((Object)compositeAuthentication, (String)"compositeAuthentication");
            Intrinsics.checkNotNullParameter((Object)tokenConverter, (String)"tokenConverter");
            return new TokenCompositeAuthentication(compositeAuthentication, tokenConverter);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JwtProperties.Algorithm.values().length];
            try {
                nArray[JwtProperties.Algorithm.HMAC256.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JwtProperties.Algorithm.HMAC384.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JwtProperties.Algorithm.HMAC512.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

