/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosec.webflux;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import me.ahoo.cosec.api.authorization.Authorization;
import me.ahoo.cosec.api.authorization.AuthorizeResult;
import me.ahoo.cosec.api.context.SecurityContext;
import me.ahoo.cosec.api.context.request.Request;
import me.ahoo.cosec.api.principal.CoSecPrincipal;
import me.ahoo.cosec.context.RequestSecurityContexts;
import me.ahoo.cosec.context.SecurityContextParser;
import me.ahoo.cosec.context.SimpleSecurityContext;
import me.ahoo.cosec.context.request.RequestParser;
import me.ahoo.cosec.policy.condition.limiter.TooManyRequestsException;
import me.ahoo.cosec.serialization.CoSecJsonSerializer;
import me.ahoo.cosec.token.TokenVerificationException;
import me.ahoo.cosec.token.TokenVerificationExceptionKt;
import me.ahoo.cosec.webflux.ReactiveSecurityContexts;
import me.ahoo.cosec.webflux.ReactiveSecurityFilterKt;
import me.ahoo.cosec.webflux.ServerWebExchanges;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00062\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0015J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lme/ahoo/cosec/webflux/ReactiveSecurityFilter;", "", "securityContextParser", "Lme/ahoo/cosec/context/SecurityContextParser;", "requestParser", "Lme/ahoo/cosec/context/request/RequestParser;", "Lorg/springframework/web/server/ServerWebExchange;", "authorization", "Lme/ahoo/cosec/api/authorization/Authorization;", "(Lme/ahoo/cosec/context/SecurityContextParser;Lme/ahoo/cosec/context/request/RequestParser;Lme/ahoo/cosec/api/authorization/Authorization;)V", "getAuthorization", "()Lme/ahoo/cosec/api/authorization/Authorization;", "getRequestParser", "()Lme/ahoo/cosec/context/request/RequestParser;", "getSecurityContextParser", "()Lme/ahoo/cosec/context/SecurityContextParser;", "filterInternal", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "exchange", "chain", "Lkotlin/Function1;", "writeWithAuthorizeResult", "Lorg/springframework/http/server/reactive/ServerHttpResponse;", "authorizeResult", "Lme/ahoo/cosec/api/authorization/AuthorizeResult;", "cosec-webflux"})
public abstract class ReactiveSecurityFilter {
    @NotNull
    private final SecurityContextParser securityContextParser;
    @NotNull
    private final RequestParser<ServerWebExchange> requestParser;
    @NotNull
    private final Authorization authorization;

    public ReactiveSecurityFilter(@NotNull SecurityContextParser securityContextParser, @NotNull RequestParser<ServerWebExchange> requestParser, @NotNull Authorization authorization) {
        Intrinsics.checkNotNullParameter((Object)securityContextParser, (String)"securityContextParser");
        Intrinsics.checkNotNullParameter(requestParser, (String)"requestParser");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        this.securityContextParser = securityContextParser;
        this.requestParser = requestParser;
        this.authorization = authorization;
    }

    @NotNull
    public final SecurityContextParser getSecurityContextParser() {
        return this.securityContextParser;
    }

    @NotNull
    public final RequestParser<ServerWebExchange> getRequestParser() {
        return this.requestParser;
    }

    @NotNull
    public final Authorization getAuthorization() {
        return this.authorization;
    }

    @NotNull
    public final Mono<Void> filterInternal(@NotNull ServerWebExchange exchange, @NotNull Function1<? super ServerWebExchange, ? extends Mono<Void>> chain) {
        SecurityContext securityContext;
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Request request = this.requestParser.parse((Object)exchange);
        Ref.ObjectRef tokenVerificationException = new Ref.ObjectRef();
        try {
            securityContext = this.securityContextParser.parse(request);
        }
        catch (TokenVerificationException verificationException) {
            if (ReactiveSecurityFilterKt.access$getLog$p().isDebugEnabled()) {
                ReactiveSecurityFilterKt.access$getLog$p().debug("Parse request to security context failed.", (Throwable)verificationException);
            }
            tokenVerificationException.element = verificationException;
            securityContext = SimpleSecurityContext.Companion.anonymous();
        }
        SecurityContext securityContext2 = securityContext;
        ServerWebExchanges.setSecurityContext(exchange, securityContext2);
        RequestSecurityContexts.INSTANCE.setRequest(securityContext2, request);
        Mono mono = this.authorization.authorize(request, securityContext2).flatMap(arg_0 -> ReactiveSecurityFilter.filterInternal$lambda$0((Function1)new Function1<AuthorizeResult, Mono<? extends Void>>(exchange, securityContext2, this, (Ref.ObjectRef<TokenVerificationException>)tokenVerificationException, chain){
            final /* synthetic */ ServerWebExchange $exchange;
            final /* synthetic */ SecurityContext $securityContext;
            final /* synthetic */ ReactiveSecurityFilter this$0;
            final /* synthetic */ Ref.ObjectRef<TokenVerificationException> $tokenVerificationException;
            final /* synthetic */ Function1<ServerWebExchange, Mono<Void>> $chain;
            {
                this.$exchange = $exchange;
                this.$securityContext = $securityContext;
                this.this$0 = $receiver;
                this.$tokenVerificationException = $tokenVerificationException;
                this.$chain = $chain;
                super(1);
            }

            public final Mono<? extends Void> invoke(AuthorizeResult authorizeResult) {
                if (authorizeResult.getAuthorized()) {
                    ServerWebExchange serverWebExchange = this.$exchange.mutate().principal(MonoExtensionsKt.toMono((Object)this.$securityContext.getPrincipal())).build();
                    Function1<ServerWebExchange, Mono<Void>> function1 = this.$chain;
                    SecurityContext securityContext = this.$securityContext;
                    ServerWebExchange it = serverWebExchange;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    return ReactiveSecurityContexts.INSTANCE.writeSecurityContext((Mono)function1.invoke((Object)it), securityContext);
                }
                CoSecPrincipal principal = this.$securityContext.getPrincipal();
                if (!principal.authenticated()) {
                    this.$exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
                } else {
                    this.$exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.FORBIDDEN);
                }
                ServerHttpResponse serverHttpResponse = this.$exchange.getResponse();
                Intrinsics.checkNotNullExpressionValue((Object)serverHttpResponse, (String)"getResponse(...)");
                TokenVerificationException tokenVerificationException = (TokenVerificationException)((Object)this.$tokenVerificationException.element);
                if (tokenVerificationException == null || (tokenVerificationException = TokenVerificationExceptionKt.asAuthorizeResult((TokenVerificationException)tokenVerificationException)) == null) {
                    tokenVerificationException = authorizeResult;
                }
                TokenVerificationException tokenVerificationException2 = tokenVerificationException;
                Intrinsics.checkNotNull((Object)((Object)tokenVerificationException2));
                return this.this$0.writeWithAuthorizeResult(serverHttpResponse, (AuthorizeResult)tokenVerificationException2);
            }
        }, arg_0)).onErrorResume(TooManyRequestsException.class, arg_0 -> ReactiveSecurityFilter.filterInternal$lambda$1((Function1)new Function1<TooManyRequestsException, Mono<? extends Void>>(exchange, this){
            final /* synthetic */ ServerWebExchange $exchange;
            final /* synthetic */ ReactiveSecurityFilter this$0;
            {
                this.$exchange = $exchange;
                this.this$0 = $receiver;
                super(1);
            }

            public final Mono<? extends Void> invoke(TooManyRequestsException tooManyRequestsException) {
                this.$exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.TOO_MANY_REQUESTS);
                ServerHttpResponse serverHttpResponse = this.$exchange.getResponse();
                Intrinsics.checkNotNullExpressionValue((Object)serverHttpResponse, (String)"getResponse(...)");
                return this.this$0.writeWithAuthorizeResult(serverHttpResponse, AuthorizeResult.Companion.getTOO_MANY_REQUESTS());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"onErrorResume(...)");
        return mono;
    }

    @NotNull
    public final Mono<Void> writeWithAuthorizeResult(@NotNull ServerHttpResponse $this$writeWithAuthorizeResult, @NotNull AuthorizeResult authorizeResult) {
        Intrinsics.checkNotNullParameter((Object)$this$writeWithAuthorizeResult, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)authorizeResult, (String)"authorizeResult");
        $this$writeWithAuthorizeResult.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        byte[] responseBodyBytes = CoSecJsonSerializer.INSTANCE.writeValueAsBytes((Object)authorizeResult);
        Mono builder = MonoExtensionsKt.toMono((Object)$this$writeWithAuthorizeResult.bufferFactory().wrap(responseBodyBytes));
        Mono mono = $this$writeWithAuthorizeResult.writeWith((Publisher)builder);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"writeWith(...)");
        return mono;
    }

    private static final Mono filterInternal$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono filterInternal$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }
}

