/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.jdbc.exception.NotFoundMaxIdException;
import me.ahoo.cosid.jdbc.exception.SegmentNameMissingException;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcIdSegmentDistributor
implements IdSegmentDistributor {
    private static final Logger log = LoggerFactory.getLogger(JdbcIdSegmentDistributor.class);
    public static final String INCREMENT_MAX_ID_SQL = "update cosid set last_max_id=(last_max_id + ?),last_fetch_time=unix_timestamp() where name = ?;";
    public static final String FETCH_MAX_ID_SQL = "select last_max_id from cosid where name = ?;";
    private final String namespace;
    private final String name;
    private final long step;
    private final DataSource dataSource;
    private final String incrementMaxIdSql;
    private final String fetchMaxIdSql;

    public JdbcIdSegmentDistributor(String namespace, String name, long step, DataSource dataSource) {
        this(namespace, name, step, INCREMENT_MAX_ID_SQL, FETCH_MAX_ID_SQL, dataSource);
    }

    public JdbcIdSegmentDistributor(String namespace, String name, long step, String incrementMaxIdSql, String fetchMaxIdSql, DataSource dataSource) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name can not be empty!");
        Preconditions.checkArgument((step > 0L ? 1 : 0) != 0, (String)"step:[%s] must be greater than 0!", (long)step);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)incrementMaxIdSql) ? 1 : 0) != 0, (Object)"incrementMaxIdSql can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fetchMaxIdSql) ? 1 : 0) != 0, (Object)"fetchMaxIdSql can not be empty!");
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource can not be null!");
        this.namespace = namespace;
        this.name = name;
        this.step = step;
        this.incrementMaxIdSql = incrementMaxIdSql;
        this.fetchMaxIdSql = fetchMaxIdSql;
        this.dataSource = dataSource;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public long getStep() {
        return this.step;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long nextMaxId(long step) {
        IdSegmentDistributor.ensureStep((long)step);
        try (Connection connection = this.dataSource.getConnection();){
            long nextMaxId;
            connection.setAutoCommit(false);
            try (PreparedStatement accStatement = connection.prepareStatement(this.incrementMaxIdSql);){
                accStatement.setLong(1, step);
                accStatement.setString(2, this.getNamespacedName());
                int affected = accStatement.executeUpdate();
                if (affected == 0) {
                    throw new SegmentNameMissingException(this.getNamespacedName());
                }
            }
            try (PreparedStatement fetchStatement = connection.prepareStatement(this.fetchMaxIdSql);){
                fetchStatement.setString(1, this.getNamespacedName());
                try (ResultSet resultSet = fetchStatement.executeQuery();){
                    if (!resultSet.next()) {
                        throw new NotFoundMaxIdException(this.getNamespacedName());
                    }
                    nextMaxId = resultSet.getLong(1);
                }
            }
            connection.commit();
            long l = nextMaxId;
            return l;
        }
        catch (SQLException sqlException) {
            if (!log.isErrorEnabled()) throw new CosIdException(sqlException.getMessage(), (Throwable)sqlException);
            log.error(sqlException.getMessage(), (Throwable)sqlException);
            throw new CosIdException(sqlException.getMessage(), (Throwable)sqlException);
        }
    }
}

