/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.jdbc;

import javax.sql.DataSource;
import me.ahoo.cosid.jdbc.JdbcIdSegmentDistributor;
import me.ahoo.cosid.jdbc.JdbcIdSegmentInitializer;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.IdSegmentDistributorDefinition;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;

public class JdbcIdSegmentDistributorFactory
implements IdSegmentDistributorFactory {
    private final DataSource dataSource;
    private final boolean enableAutoInitIdSegment;
    private final JdbcIdSegmentInitializer jdbcIdSegmentInitializer;
    private final String incrementMaxIdSql;
    private final String fetchMaxIdSql;

    public JdbcIdSegmentDistributorFactory(DataSource dataSource, boolean enableAutoInitIdSegment, JdbcIdSegmentInitializer jdbcIdSegmentInitializer, String incrementMaxIdSql, String fetchMaxIdSql) {
        this.dataSource = dataSource;
        this.enableAutoInitIdSegment = enableAutoInitIdSegment;
        this.jdbcIdSegmentInitializer = jdbcIdSegmentInitializer;
        this.incrementMaxIdSql = incrementMaxIdSql;
        this.fetchMaxIdSql = fetchMaxIdSql;
    }

    public IdSegmentDistributor create(IdSegmentDistributorDefinition definition) {
        if (this.enableAutoInitIdSegment) {
            this.jdbcIdSegmentInitializer.tryInitIdSegment(definition.getNamespacedName(), definition.getOffset());
        }
        return new JdbcIdSegmentDistributor(definition.getNamespace(), definition.getName(), definition.getStep(), this.incrementMaxIdSql, this.fetchMaxIdSql, this.dataSource);
    }
}

