/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcIdSegmentInitializer {
    private static final Logger log = LoggerFactory.getLogger(JdbcIdSegmentInitializer.class);
    public static final String INIT_COSID_TABLE_SQL = "create table if not exists cosid\n(\n    name            varchar(100) not null comment '{namespace}.{name}',\n    last_max_id     bigint unsigned not null default 0,\n    last_fetch_time bigint unsigned not null default 0,\n    constraint cosid_pk\n        primary key (name)\n) engine = InnoDB;";
    public static final String INIT_ID_SEGMENT_SQL = "insert into cosid (name, last_max_id,last_fetch_time) value (?, ?,unix_timestamp());";
    private final String initCosIdTableSql;
    private final String initIdSegmentSql;
    private final DataSource dataSource;

    public JdbcIdSegmentInitializer(DataSource dataSource) {
        this(INIT_COSID_TABLE_SQL, INIT_ID_SEGMENT_SQL, dataSource);
    }

    public JdbcIdSegmentInitializer(String initCosIdTableSql, String initIdSegmentSql, DataSource dataSource) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)initCosIdTableSql) ? 1 : 0) != 0, (Object)"initCosIdTableSql can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)initIdSegmentSql) ? 1 : 0) != 0, (Object)"initIdSegmentSql can not be empty!");
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource can not be null!");
        this.initCosIdTableSql = initCosIdTableSql;
        this.initIdSegmentSql = initIdSegmentSql;
        this.dataSource = dataSource;
    }

    /*
     * Exception decompiling
     */
    public int initCosIdTable() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean tryInitCosIdTable() {
        try {
            this.initCosIdTable();
            return true;
        }
        catch (Throwable throwable) {
            if (log.isInfoEnabled()) {
                log.info("tryInitCosIdTable failed.[{}]", (Object)throwable.getMessage());
            }
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public int initIdSegment(String segmentName, long offset) throws SQLException, SQLIntegrityConstraintViolationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean tryInitIdSegment(String segmentName, long offset) {
        try {
            this.initIdSegment(segmentName, offset);
            return true;
        }
        catch (Throwable throwable) {
            if (log.isInfoEnabled()) {
                log.info("tryInitIdSegment failed.[{}]", (Object)throwable.getMessage());
            }
            return false;
        }
    }
}

