/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.jdbc;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.time.Duration;
import javax.sql.DataSource;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.snowflake.ClockBackwardsSynchronizer;
import me.ahoo.cosid.snowflake.machine.AbstractMachineIdDistributor;
import me.ahoo.cosid.snowflake.machine.InstanceId;
import me.ahoo.cosid.snowflake.machine.MachineIdDistributor;
import me.ahoo.cosid.snowflake.machine.MachineIdLostException;
import me.ahoo.cosid.snowflake.machine.MachineIdOverflowException;
import me.ahoo.cosid.snowflake.machine.MachineState;
import me.ahoo.cosid.snowflake.machine.MachineStateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcMachineIdDistributor
extends AbstractMachineIdDistributor {
    private static final Logger log = LoggerFactory.getLogger(JdbcMachineIdDistributor.class);
    private final DataSource dataSource;
    private static final String GET_MACHINE_STATE = "select machine_id, last_timestamp from cosid_machine where namespace=? and instance_id=? and last_timestamp>?";
    private static final String GET_REVERT_MACHINE_STATE = "select machine_id, last_timestamp from cosid_machine where namespace=? and (instance_id='' or last_timestamp<=?)";
    private static final String DISTRIBUTE_REVERT_MACHINE_STATE = "update cosid_machine set instance_id=?,last_timestamp=?,distribute_time=? where name=? and (instance_id='' or last_timestamp<=?)";
    private static final String NEXT_MACHINE_ID = "select max(machine_id)+1 as next_machine_id from cosid_machine where namespace=?";
    private static final String DISTRIBUTE_MACHINE = "insert into cosid_machine (name, namespace, machine_id, last_timestamp, instance_id, distribute_time, revert_time) values (?,?,?,?,?,?,0);";
    private static final String REVERT_MACHINE_STATE = "update cosid_machine set instance_id=?,last_timestamp=?,revert_time=? where namespace=? and instance_id=?";
    private static final String GUARD_MACHINE_STATE = "update cosid_machine set last_timestamp=? where namespace=? and instance_id=? and machine_id=?";

    public JdbcMachineIdDistributor(DataSource dataSource, MachineStateStorage machineStateStorage, ClockBackwardsSynchronizer clockBackwardsSynchronizer) {
        super(machineStateStorage, clockBackwardsSynchronizer);
        this.dataSource = dataSource;
    }

    private String getNamespacedMachineId(String namespace, int machineId) {
        return namespace + "." + Strings.padStart((String)String.valueOf(machineId), (int)4, (char)'0');
    }

    private int distributeRevertMachineState(Connection connection, String namespace, int machineId, InstanceId instanceId, Duration safeGuardDuration) throws SQLException {
        try (PreparedStatement revertMachineStatement = connection.prepareStatement(DISTRIBUTE_REVERT_MACHINE_STATE);){
            int affected;
            revertMachineStatement.setString(1, instanceId.getInstanceId());
            revertMachineStatement.setLong(2, System.currentTimeMillis());
            revertMachineStatement.setLong(3, System.currentTimeMillis());
            revertMachineStatement.setString(4, this.getNamespacedMachineId(namespace, machineId));
            revertMachineStatement.setLong(5, MachineIdDistributor.getSafeGuardAt((Duration)safeGuardDuration, (boolean)instanceId.isStable()));
            int n = affected = revertMachineStatement.executeUpdate();
            return n;
        }
    }

    /*
     * Exception decompiling
     */
    private int nextMachineId(Connection connection, String namespace) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MachineState distributeRemote(String namespace, int machineBit, InstanceId instanceId, Duration safeGuardDuration) {
        if (log.isInfoEnabled()) {
            log.info("distributeRemote - instanceId:[{}] - machineBit:[{}] @ namespace:[{}].", new Object[]{instanceId, machineBit, namespace});
        }
        try (Connection connection = this.dataSource.getConnection();){
            MachineState machineState = this.distributeBySelf(namespace, instanceId, connection, safeGuardDuration);
            if (machineState != null) {
                MachineState machineState2 = machineState;
                return machineState2;
            }
            machineState = this.distributeByRevert(namespace, instanceId, connection, safeGuardDuration);
            if (machineState != null) {
                MachineState machineState3 = machineState;
                return machineState3;
            }
            MachineState machineState4 = this.distributeMachine(namespace, machineBit, instanceId, connection);
            return machineState4;
        }
        catch (SQLException sqlException) {
            if (!log.isErrorEnabled()) throw new CosIdException(sqlException.getMessage(), (Throwable)sqlException);
            log.error(sqlException.getMessage(), (Throwable)sqlException);
            throw new CosIdException(sqlException.getMessage(), (Throwable)sqlException);
        }
    }

    /*
     * Loose catch block
     */
    private MachineState distributeMachine(String namespace, int machineBit, InstanceId instanceId, Connection connection) throws SQLException {
        int nextMachineId = this.nextMachineId(connection, namespace);
        if (nextMachineId > MachineIdDistributor.maxMachineId((int)machineBit)) {
            throw new MachineIdOverflowException(MachineIdDistributor.totalMachineIds((int)machineBit), instanceId);
        }
        MachineState nextMachineState = MachineState.of((int)nextMachineId, (long)System.currentTimeMillis());
        Throwable throwable = null;
        try (PreparedStatement nextMachineStatement = connection.prepareStatement(DISTRIBUTE_MACHINE);){
            nextMachineStatement.setString(1, this.getNamespacedMachineId(namespace, nextMachineId));
            nextMachineStatement.setString(2, namespace);
            nextMachineStatement.setInt(3, nextMachineId);
            nextMachineStatement.setLong(4, nextMachineState.getLastTimeStamp());
            nextMachineStatement.setString(5, instanceId.getInstanceId());
            nextMachineStatement.setLong(6, System.currentTimeMillis());
            try {
                nextMachineStatement.executeUpdate();
                MachineState machineState = nextMachineState;
                return machineState;
            }
            catch (SQLIntegrityConstraintViolationException sqlIntegrityConstraintViolationException) {
                MachineState machineState;
                block19: {
                    block20: {
                        if (log.isInfoEnabled()) {
                            log.info("distributeMachine - [{}]", (Object)sqlIntegrityConstraintViolationException.getMessage());
                        }
                        machineState = this.distributeMachine(namespace, machineBit, instanceId, connection);
                        if (nextMachineStatement == null) break block19;
                        if (throwable == null) break block20;
                        try {
                            nextMachineStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block19;
                    }
                    nextMachineStatement.close();
                }
                return machineState;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    private MachineState distributeByRevert(String namespace, InstanceId instanceId, Connection connection, Duration safeGuardDuration) throws SQLException {
        try (PreparedStatement getRevertMachineStatement = connection.prepareStatement(GET_REVERT_MACHINE_STATE);){
            getRevertMachineStatement.setString(1, namespace);
            getRevertMachineStatement.setLong(2, MachineIdDistributor.getSafeGuardAt((Duration)safeGuardDuration, (boolean)instanceId.isStable()));
            try (ResultSet resultSet = getRevertMachineStatement.executeQuery();){
                if (resultSet.next()) {
                    int machineId = resultSet.getInt(1);
                    long lastTimeStamp = resultSet.getLong(2);
                    if (this.distributeRevertMachineState(connection, namespace, machineId, instanceId, safeGuardDuration) > 0) {
                        MachineState machineState = MachineState.of((int)machineId, (long)lastTimeStamp);
                        return machineState;
                    }
                }
            }
        }
        return null;
    }

    private MachineState distributeBySelf(String namespace, InstanceId instanceId, Connection connection, Duration safeGuardDuration) throws SQLException {
        try (PreparedStatement getMachineStatement = connection.prepareStatement(GET_MACHINE_STATE);){
            getMachineStatement.setString(1, namespace);
            getMachineStatement.setString(2, instanceId.getInstanceId());
            getMachineStatement.setLong(3, MachineIdDistributor.getSafeGuardAt((Duration)safeGuardDuration, (boolean)instanceId.isStable()));
            try (ResultSet resultSet = getMachineStatement.executeQuery();){
                if (resultSet.next()) {
                    int machineId = resultSet.getInt(1);
                    MachineState machineState = MachineState.of((int)machineId, (long)System.currentTimeMillis());
                    this.guardRemote(namespace, instanceId, machineState, safeGuardDuration);
                    MachineState machineState2 = machineState;
                    return machineState2;
                }
            }
        }
        return null;
    }

    protected void revertRemote(String namespace, InstanceId instanceId, MachineState machineState) {
        if (log.isInfoEnabled()) {
            log.info("revertRemote - [{}] instanceId:[{}] @ namespace:[{}].", new Object[]{machineState, instanceId, namespace});
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement revertMachineStatement = connection.prepareStatement(REVERT_MACHINE_STATE);){
            revertMachineStatement.setString(1, instanceId.isStable() ? instanceId.getInstanceId() : "");
            revertMachineStatement.setLong(2, machineState.getLastTimeStamp());
            revertMachineStatement.setLong(3, System.currentTimeMillis());
            revertMachineStatement.setString(4, namespace);
            revertMachineStatement.setString(5, instanceId.getInstanceId());
            int affected = revertMachineStatement.executeUpdate();
            if (log.isInfoEnabled()) {
                log.info("revertRemote - affected:[{}]", (Object)affected);
            }
        }
        catch (SQLException sqlException) {
            if (log.isErrorEnabled()) {
                log.error(sqlException.getMessage(), (Throwable)sqlException);
            }
            throw new CosIdException(sqlException.getMessage(), (Throwable)sqlException);
        }
    }

    protected void guardRemote(String namespace, InstanceId instanceId, MachineState machineState, Duration safeGuardDuration) {
        if (log.isInfoEnabled()) {
            log.info("guardRemote - [{}] instanceId:[{}] @ namespace:[{}].", new Object[]{machineState, instanceId, namespace});
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement guardMachineStatement = connection.prepareStatement(GUARD_MACHINE_STATE);){
            guardMachineStatement.setLong(1, machineState.getLastTimeStamp());
            guardMachineStatement.setString(2, namespace);
            guardMachineStatement.setString(3, instanceId.getInstanceId());
            guardMachineStatement.setInt(4, machineState.getMachineId());
            int affected = guardMachineStatement.executeUpdate();
            if (log.isInfoEnabled()) {
                log.info("guardRemote - affected:[{}]", (Object)affected);
            }
            if (0 == affected) {
                throw new MachineIdLostException(namespace, instanceId, machineState);
            }
        }
        catch (SQLException sqlException) {
            if (log.isErrorEnabled()) {
                log.error(sqlException.getMessage(), (Throwable)sqlException);
            }
            throw new CosIdException(sqlException.getMessage(), (Throwable)sqlException);
        }
    }
}

