/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.mongo.reactive;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.SignalType;

public class BlockingAdapterSubscriber<T>
extends BaseSubscriber<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private T value;
    private Throwable error;

    protected void hookOnNext(T value) {
        this.value = value;
    }

    protected void hookOnError(Throwable throwable) {
        this.error = throwable;
    }

    public T getValue() {
        return this.value;
    }

    public T block(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        return this.await(timeout, unit).getValue();
    }

    public Throwable getError() {
        return this.error;
    }

    protected void hookFinally(SignalType type) {
        this.latch.countDown();
    }

    public BlockingAdapterSubscriber<T> await(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimeoutException("Timeout after " + timeout + " " + unit);
        }
        if (this.getError() != null) {
            if (this.getError() instanceof RuntimeException) {
                throw (RuntimeException)this.getError();
            }
            throw new RuntimeException(this.getError());
        }
        return this;
    }
}

