/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.mongo.reactive;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import me.ahoo.cosid.mongo.reactive.BlockingAdapterSubscriber;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class BlockingAdapter {
    public static final Duration DEFAULT_TIME_OUT = Duration.ofSeconds(10L);

    private BlockingAdapter() {
    }

    public static <R> R block(Publisher<R> publisher) {
        Mono mono = Mono.from(publisher);
        return BlockingAdapter.block(mono);
    }

    public static <R> R block(Mono<R> mono) {
        try {
            BlockingAdapterSubscriber blockingAdapterSubscriber = new BlockingAdapterSubscriber();
            mono.subscribe(blockingAdapterSubscriber);
            return (R)blockingAdapterSubscriber.block(DEFAULT_TIME_OUT.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }
}

