/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.mongo;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import me.ahoo.cosid.mongo.MongoIdSegmentCollection;
import me.ahoo.cosid.mongo.MongoIdSegmentDistributor;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.IdSegmentDistributorDefinition;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import org.bson.Document;

public class MongoIdSegmentDistributorFactory
implements IdSegmentDistributorFactory {
    private final MongoDatabase mongoDatabase;
    private final boolean enableAutoInitIdSegment;

    public MongoIdSegmentDistributorFactory(MongoDatabase mongoDatabase, boolean enableAutoInitIdSegment) {
        this.mongoDatabase = mongoDatabase;
        this.enableAutoInitIdSegment = enableAutoInitIdSegment;
    }

    public IdSegmentDistributor create(IdSegmentDistributorDefinition definition) {
        MongoIdSegmentCollection cosIdSegmentCollection = new MongoIdSegmentCollection((MongoCollection<Document>)this.mongoDatabase.getCollection("cosid"));
        if (this.enableAutoInitIdSegment) {
            cosIdSegmentCollection.ensureIdSegment(definition.getNamespacedName(), definition.getOffset());
        }
        return new MongoIdSegmentDistributor(definition.getNamespace(), definition.getName(), definition.getStep(), cosIdSegmentCollection);
    }
}

