/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.mongo.reactive;

import com.mongodb.MongoCommandException;
import com.mongodb.reactivestreams.client.MongoDatabase;
import lombok.Generated;
import me.ahoo.cosid.mongo.IdSegmentInitializer;
import me.ahoo.cosid.mongo.reactive.BlockingAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoReactiveIdSegmentInitializer
implements IdSegmentInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoReactiveIdSegmentInitializer.class);
    private final MongoDatabase mongoDatabase;

    public MongoReactiveIdSegmentInitializer(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    @Override
    public boolean ensureCosIdCollection() {
        if (log.isInfoEnabled()) {
            log.info("Ensure CosIdCollection");
        }
        try {
            BlockingAdapter.block(this.mongoDatabase.createCollection("cosid"));
            return true;
        }
        catch (MongoCommandException mongoCommandException) {
            if (log.isInfoEnabled()) {
                log.info("Ensure CosIdCollection Failed:[{}]", (Object)mongoCommandException.getMessage());
            }
            return false;
        }
    }
}

