/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.mongo;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.result.UpdateResult;
import java.time.Duration;
import java.util.Objects;
import lombok.Generated;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdLostException;
import me.ahoo.cosid.machine.MachineIdOverflowException;
import me.ahoo.cosid.machine.MachineState;
import me.ahoo.cosid.mongo.Documents;
import me.ahoo.cosid.mongo.MachineCollection;
import me.ahoo.cosid.mongo.MachineOperates;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoMachineCollection
implements MachineCollection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoMachineCollection.class);
    private final MongoCollection<Document> machineCollection;

    public MongoMachineCollection(MongoCollection<Document> machineCollection) {
        this.machineCollection = machineCollection;
    }

    @Override
    public int nextMachineId(String namespace) {
        Document maxMachineIdDoc = (Document)this.machineCollection.aggregate(MachineOperates.nextMachineIdPipeline(namespace)).first();
        if (maxMachineIdDoc == null) {
            return 0;
        }
        Integer maxMachineId = maxMachineIdDoc.getInteger((Object)"maxMachineId");
        return Objects.requireNonNull(maxMachineId) + 1;
    }

    @Override
    public MachineState distribute(String namespace, int machineBit, InstanceId instanceId) {
        int nextMachineId = this.nextMachineId(namespace);
        if (nextMachineId > MachineIdDistributor.maxMachineId((int)machineBit)) {
            throw new MachineIdOverflowException(MachineIdDistributor.totalMachineIds((int)machineBit), instanceId);
        }
        MachineState nextMachineState = MachineState.of((int)nextMachineId, (long)System.currentTimeMillis());
        try {
            this.machineCollection.insertOne((Object)MachineOperates.distributeDocument(namespace, instanceId, nextMachineState));
            return nextMachineState;
        }
        catch (MongoWriteException mongoWriteException) {
            if (mongoWriteException.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                if (log.isInfoEnabled()) {
                    log.info("Distribute Failed:[{}]", (Object)mongoWriteException.getMessage());
                }
                return this.distribute(namespace, machineBit, instanceId);
            }
            throw mongoWriteException;
        }
    }

    @Override
    public MachineState distributeByRevert(String namespace, InstanceId instanceId, Duration safeGuardDuration) {
        long lastTimestamp = System.currentTimeMillis();
        Document afterDoc = (Document)this.machineCollection.findOneAndUpdate(MachineOperates.distributeByRevertFilter(namespace, instanceId, safeGuardDuration), MachineOperates.distributeByRevertUpdate(instanceId, lastTimestamp), Documents.UPDATE_AFTER_OPTIONS);
        if (afterDoc == null) {
            return null;
        }
        int machineId = afterDoc.getInteger((Object)"machineId");
        return MachineState.of((int)machineId, (long)lastTimestamp);
    }

    @Override
    public MachineState distributeBySelf(String namespace, InstanceId instanceId, Duration safeGuardDuration) {
        long lastTimestamp = System.currentTimeMillis();
        Document afterDoc = (Document)this.machineCollection.findOneAndUpdate(MachineOperates.distributeBySelfFilter(namespace, instanceId, safeGuardDuration), MachineOperates.distributeBySelfUpdate(lastTimestamp), Documents.UPDATE_AFTER_OPTIONS);
        if (afterDoc == null) {
            return null;
        }
        int machineId = afterDoc.getInteger((Object)"machineId");
        return MachineState.of((int)machineId, (long)lastTimestamp);
    }

    @Override
    public void revert(String namespace, InstanceId instanceId, MachineState machineState) throws MachineIdLostException {
        UpdateResult updateResult;
        if (log.isInfoEnabled()) {
            log.info("Revert [{}] instanceId:[{}] @ namespace:[{}].", new Object[]{machineState, instanceId, namespace});
        }
        if ((updateResult = this.machineCollection.updateOne(MachineOperates.revertFilter(namespace, instanceId, machineState), MachineOperates.revertUpdate(instanceId, machineState))).getModifiedCount() == 0L) {
            throw new MachineIdLostException(namespace, instanceId, machineState);
        }
    }

    @Override
    public void guard(String namespace, InstanceId instanceId, MachineState machineState, Duration safeGuardDuration) throws MachineIdLostException {
        UpdateResult updateResult;
        if (log.isDebugEnabled()) {
            log.debug("Guard - [{}] instanceId:[{}] @ namespace:[{}].", new Object[]{machineState, instanceId, namespace});
        }
        if ((updateResult = this.machineCollection.updateOne(MachineOperates.guardFilter(namespace, instanceId, machineState), MachineOperates.guardUpdate(machineState.getLastTimeStamp()))).getModifiedCount() == 0L) {
            throw new MachineIdLostException(namespace, instanceId, machineState);
        }
    }
}

