/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.mongo;

import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import lombok.Generated;
import me.ahoo.cosid.mongo.MachineInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoMachineInitializer
implements MachineInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoMachineInitializer.class);
    private final MongoDatabase mongoDatabase;

    public MongoMachineInitializer(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    @Override
    public boolean ensureMachineCollection() {
        if (log.isInfoEnabled()) {
            log.info("Ensure MachineCollection");
        }
        try {
            this.mongoDatabase.createCollection("cosid_machine");
            MongoCollection machineCollection = this.mongoDatabase.getCollection("cosid_machine");
            machineCollection.createIndex(Indexes.hashed((String)"machineId"));
            machineCollection.createIndex(Indexes.hashed((String)"instanceId"));
            return true;
        }
        catch (MongoCommandException mongoCommandException) {
            if (log.isInfoEnabled()) {
                log.info("Ensure MachineCollection Failed", (Throwable)mongoCommandException);
            }
            return false;
        }
    }
}

