/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.mongo.reactive;

import com.google.common.base.Preconditions;
import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Filters;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.Objects;
import lombok.Generated;
import me.ahoo.cosid.mongo.Documents;
import me.ahoo.cosid.mongo.IdSegmentCollection;
import me.ahoo.cosid.mongo.IdSegmentOperates;
import me.ahoo.cosid.mongo.reactive.BlockingAdapter;
import org.bson.Document;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoReactiveIdSegmentCollection
implements IdSegmentCollection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoReactiveIdSegmentCollection.class);
    private final MongoCollection<Document> cosidCollection;

    public MongoReactiveIdSegmentCollection(MongoCollection<Document> cosidCollection) {
        this.cosidCollection = cosidCollection;
    }

    @Override
    public long incrementAndGet(String namespacedName, long step) {
        Publisher publisher = this.cosidCollection.findOneAndUpdate(Filters.eq((String)"_id", (Object)namespacedName), IdSegmentOperates.incrementAndGetUpdates(step), Documents.UPDATE_AFTER_OPTIONS);
        Document afterDoc = (Document)BlockingAdapter.block(publisher);
        assert (afterDoc != null);
        Preconditions.checkNotNull((Object)afterDoc, (String)"IdSegment[%s] can not be null!", (Object)namespacedName);
        Long lastMaxId = afterDoc.getLong((Object)"lastMaxId");
        return Objects.requireNonNull(lastMaxId);
    }

    @Override
    public boolean ensureIdSegment(String segmentName, long offset) {
        if (log.isInfoEnabled()) {
            log.info("Ensure IdSegment:[{}]", (Object)segmentName);
        }
        try {
            Document document = IdSegmentOperates.ensureIdSegmentDocument(segmentName, offset);
            Publisher publisher = this.cosidCollection.insertOne((Object)document);
            BlockingAdapter.block(publisher);
            return true;
        }
        catch (MongoWriteException mongoWriteException) {
            if (log.isInfoEnabled()) {
                log.info("Ensure IdSegment:[{}] Failed:[{}]", (Object)segmentName, (Object)mongoWriteException.getMessage());
            }
            return false;
        }
    }
}

