/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.mongo.reactive;

import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import me.ahoo.cosid.mongo.MongoIdSegmentDistributor;
import me.ahoo.cosid.mongo.reactive.MongoReactiveIdSegmentCollection;
import me.ahoo.cosid.segment.IdSegmentDistributor;
import me.ahoo.cosid.segment.IdSegmentDistributorDefinition;
import me.ahoo.cosid.segment.IdSegmentDistributorFactory;
import org.bson.Document;

public class MongoReactiveIdSegmentDistributorFactory
implements IdSegmentDistributorFactory {
    private final MongoDatabase mongoDatabase;
    private final boolean enableAutoInitIdSegment;

    public MongoReactiveIdSegmentDistributorFactory(MongoDatabase mongoDatabase, boolean enableAutoInitIdSegment) {
        this.mongoDatabase = mongoDatabase;
        this.enableAutoInitIdSegment = enableAutoInitIdSegment;
    }

    public IdSegmentDistributor create(IdSegmentDistributorDefinition definition) {
        MongoReactiveIdSegmentCollection idSegmentCollection = new MongoReactiveIdSegmentCollection((MongoCollection<Document>)this.mongoDatabase.getCollection("cosid"));
        if (this.enableAutoInitIdSegment) {
            idSegmentCollection.ensureIdSegment(definition.getNamespacedName(), definition.getOffset());
        }
        return new MongoIdSegmentDistributor(definition.getNamespace(), definition.getName(), definition.getStep(), idSegmentCollection);
    }
}

