/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.mongo.reactive;

import com.mongodb.MongoCommandException;
import com.mongodb.client.model.Indexes;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import lombok.Generated;
import me.ahoo.cosid.mongo.MachineInitializer;
import me.ahoo.cosid.mongo.reactive.BlockingAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoReactiveMachineInitializer
implements MachineInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoReactiveMachineInitializer.class);
    private final MongoDatabase mongoDatabase;

    public MongoReactiveMachineInitializer(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    @Override
    public boolean ensureMachineCollection() {
        if (log.isInfoEnabled()) {
            log.info("Ensure MachineCollection");
        }
        try {
            BlockingAdapter.block(this.mongoDatabase.createCollection("cosid_machine"));
            MongoCollection machineCollection = this.mongoDatabase.getCollection("cosid_machine");
            BlockingAdapter.block(machineCollection.createIndex(Indexes.hashed((String)"machineId")));
            BlockingAdapter.block(machineCollection.createIndex(Indexes.hashed((String)"instanceId")));
            return true;
        }
        catch (MongoCommandException mongoCommandException) {
            if (log.isInfoEnabled()) {
                log.info("Ensure MachineCollection Failed", (Throwable)mongoCommandException);
            }
            return false;
        }
    }
}

